/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.yarn.YarnClusterClientFactory;
import org.apache.flink.yarn.executors.YarnJobClusterExecutor;
import org.apache.flink.yarn.executors.YarnSessionClusterExecutor;
import org.junit.Assert;
import org.junit.Test;

public class YarnClusterClientFactoryTest {
    @Test
    public void testYarnClusterClientFactoryDiscoveryWithPerJobExecutor() {
        this.testYarnClusterClientFactoryDiscoveryHelper(YarnJobClusterExecutor.NAME);
    }

    @Test
    public void testYarnClusterClientFactoryDiscoveryWithSessionExecutor() {
        this.testYarnClusterClientFactoryDiscoveryHelper(YarnSessionClusterExecutor.NAME);
    }

    private void testYarnClusterClientFactoryDiscoveryHelper(String targetName) {
        Configuration configuration = new Configuration();
        configuration.setString(DeploymentOptions.TARGET, targetName);
        DefaultClusterClientServiceLoader serviceLoader = new DefaultClusterClientServiceLoader();
        ClusterClientFactory factory = serviceLoader.getClusterClientFactory(configuration);
        Assert.assertTrue((boolean)(factory instanceof YarnClusterClientFactory));
    }
}

