/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.yarn.YarnClientYarnClusterInformationRetriever;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.flink.yarn.YarnClusterInformationRetriever;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public final class YarnClusterDescriptorBuilder {
    private final YarnClient yarnClient;
    private final boolean sharedYarnClient;
    private Configuration flinkConfiguration = new Configuration();
    private YarnConfiguration yarnConfiguration = new YarnConfiguration();
    @Nullable
    private YarnClusterInformationRetriever yarnClusterInformationRetriever = null;

    private YarnClusterDescriptorBuilder(YarnClient yarnClient, boolean sharedYarnClient) {
        this.yarnClient = yarnClient;
        this.sharedYarnClient = sharedYarnClient;
    }

    public YarnClusterDescriptorBuilder setFlinkConfiguration(Configuration flinkConfiguration) {
        this.flinkConfiguration = flinkConfiguration;
        return this;
    }

    public YarnClusterDescriptorBuilder setYarnConfiguration(YarnConfiguration yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
        return this;
    }

    public YarnClusterDescriptorBuilder setYarnClusterInformationRetriever(YarnClusterInformationRetriever yarnClusterInformationRetriever) {
        this.yarnClusterInformationRetriever = yarnClusterInformationRetriever;
        return this;
    }

    public YarnClusterDescriptor build() {
        Object clusterInformationRetriever = this.yarnClusterInformationRetriever == null ? YarnClientYarnClusterInformationRetriever.create((YarnClient)this.yarnClient) : this.yarnClusterInformationRetriever;
        return new YarnClusterDescriptor(this.flinkConfiguration, this.yarnConfiguration, this.yarnClient, clusterInformationRetriever, this.sharedYarnClient);
    }

    public static YarnClusterDescriptorBuilder newBuilder(YarnClient yarnClient, boolean sharedYarnClient) {
        return new YarnClusterDescriptorBuilder(yarnClient, sharedYarnClient);
    }
}

