/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.yarn.YarnLocalResourceDescriptor;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class YarnLocalResourceDescriptionTest
extends TestLogger {
    private final String key = "flink.jar";
    private final Path path = new Path("hdfs://nn/tmp/flink.jar");
    private final long size = 0x6400000L;
    private final long ts = System.currentTimeMillis();

    @Test
    public void testFromString() throws Exception {
        YarnLocalResourceDescriptor localResourceDesc = new YarnLocalResourceDescriptor("flink.jar", this.path, 0x6400000L, this.ts, LocalResourceVisibility.PUBLIC, LocalResourceType.FILE);
        String desc = localResourceDesc.toString();
        YarnLocalResourceDescriptor newLocalResourceDesc = YarnLocalResourceDescriptor.fromString((String)desc);
        Assert.assertThat((Object)newLocalResourceDesc.getResourceKey(), (Matcher)Is.is((Object)"flink.jar"));
        Assert.assertThat((Object)newLocalResourceDesc.getPath(), (Matcher)Is.is((Object)this.path));
        Assert.assertThat((Object)newLocalResourceDesc.getSize(), (Matcher)Is.is((Object)0x6400000L));
        Assert.assertThat((Object)newLocalResourceDesc.getModificationTime(), (Matcher)Is.is((Object)this.ts));
        Assert.assertThat((Object)newLocalResourceDesc.getVisibility(), (Matcher)Is.is((Object)LocalResourceVisibility.PUBLIC));
        Assert.assertThat((Object)newLocalResourceDesc.getResourceType(), (Matcher)Is.is((Object)LocalResourceType.FILE));
    }

    @Test
    public void testFromStringMalformed() {
        String desc = String.format("YarnLocalResourceDescriptor{key=%s path=%s size=%d modTime=%d visibility=%s}", "flink.jar", this.path.toString(), 0x6400000L, this.ts, LocalResourceVisibility.PUBLIC);
        CommonTestUtils.assertThrows((String)("Error to parse YarnLocalResourceDescriptor from " + desc), FlinkException.class, () -> YarnLocalResourceDescriptor.fromString((String)desc));
    }
}

