/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.configuration;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.yarn.configuration.YarnDeploymentTarget;
import org.junit.Assert;
import org.junit.Test;

public class YarnDeploymentTargetTest {
    @Test
    public void testCorrectInstantiationFromConfiguration() {
        for (YarnDeploymentTarget t : YarnDeploymentTarget.values()) {
            this.testCorrectInstantiationFromConfigurationHelper(t);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidInstantiationFromConfiguration() {
        Configuration configuration = this.getConfigurationWithTarget("invalid-target");
        YarnDeploymentTarget.fromConfig((Configuration)configuration);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullInstantiationFromConfiguration() {
        YarnDeploymentTarget.fromConfig((Configuration)new Configuration());
    }

    @Test
    public void testThatAValidOptionIsValid() {
        Assert.assertTrue((boolean)YarnDeploymentTarget.isValidYarnTarget((String)YarnDeploymentTarget.APPLICATION.getName()));
    }

    @Test
    public void testThatAnInvalidOptionIsInvalid() {
        Assert.assertFalse((boolean)YarnDeploymentTarget.isValidYarnTarget((String)"invalid-target"));
    }

    private void testCorrectInstantiationFromConfigurationHelper(YarnDeploymentTarget expectedDeploymentTarget) {
        Configuration configuration = this.getConfigurationWithTarget(expectedDeploymentTarget.getName().toUpperCase());
        YarnDeploymentTarget actualDeploymentTarget = YarnDeploymentTarget.fromConfig((Configuration)configuration);
        Assert.assertSame((Object)actualDeploymentTarget, (Object)expectedDeploymentTarget);
    }

    private Configuration getConfigurationWithTarget(String target) {
        Configuration configuration = new Configuration();
        configuration.set(DeploymentOptions.TARGET, (Object)target);
        return configuration;
    }
}

