/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.highavailability;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.highavailability.ServicesThreadFactory;
import org.apache.flink.runtime.highavailability.nonha.leaderelection.SingleLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.yarn.highavailability.AbstractYarnNonHaServices;

public class YarnIntraNonHaMasterServices
extends AbstractYarnNonHaServices {
    private final ExecutorService dispatcher;
    private final SingleLeaderElectionService resourceManagerLeaderElectionService;
    private final SingleLeaderElectionService dispatcherLeaderElectionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YarnIntraNonHaMasterServices(Configuration config, org.apache.hadoop.conf.Configuration hadoopConf) throws IOException {
        super(config, hadoopConf);
        boolean successful = false;
        try {
            this.dispatcher = Executors.newSingleThreadExecutor((ThreadFactory)new ServicesThreadFactory());
            this.resourceManagerLeaderElectionService = new SingleLeaderElectionService((Executor)this.dispatcher, DEFAULT_LEADER_ID);
            this.dispatcherLeaderElectionService = new SingleLeaderElectionService((Executor)this.dispatcher, DEFAULT_LEADER_ID);
            successful = true;
        }
        finally {
            if (!successful) {
                try {
                    super.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        this.enter();
        try {
            LeaderRetrievalService leaderRetrievalService = this.resourceManagerLeaderElectionService.createLeaderRetrievalService();
            return leaderRetrievalService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        this.enter();
        try {
            LeaderRetrievalService leaderRetrievalService = this.dispatcherLeaderElectionService.createLeaderRetrievalService();
            return leaderRetrievalService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        this.enter();
        try {
            SingleLeaderElectionService singleLeaderElectionService = this.resourceManagerLeaderElectionService;
            return singleLeaderElectionService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderElectionService getDispatcherLeaderElectionService() {
        this.enter();
        try {
            SingleLeaderElectionService singleLeaderElectionService = this.dispatcherLeaderElectionService;
            return singleLeaderElectionService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        this.enter();
        try {
            throw new UnsupportedOperationException("needs refactoring to accept default address");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderElectionService getWebMonitorLeaderElectionService() {
        this.enter();
        try {
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        this.enter();
        try {
            throw new UnsupportedOperationException("needs refactoring to accept default address");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        this.enter();
        try {
            throw new UnsupportedOperationException("needs refactoring to accept default address");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        this.enter();
        try {
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.enterUnlessClosed()) {
            try {
                try {
                    this.resourceManagerLeaderElectionService.shutdown();
                    this.dispatcher.shutdownNow();
                }
                finally {
                    super.close();
                }
            }
            finally {
                this.exit();
            }
        }
    }
}

