/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnTaskExecutorRunner {
    protected static final Logger LOG = LoggerFactory.getLogger(YarnTaskExecutorRunner.class);
    private static final Map<String, String> ENV = System.getenv();
    private static final int INIT_ERROR_EXIT_CODE = 31;

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"YARN TaskExecutor runner", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        YarnTaskExecutorRunner.run(args);
    }

    private static void run(String[] args) {
        try {
            LOG.debug("All environment variables: {}", ENV);
            String currDir = ENV.get(ApplicationConstants.Environment.PWD.key());
            LOG.info("Current working Directory: {}", (Object)currDir);
            Configuration configuration = GlobalConfiguration.loadConfiguration((String)currDir);
            FileSystem.initialize((Configuration)configuration, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration));
            YarnTaskExecutorRunner.setupConfigurationAndInstallSecurityContext(configuration, currDir, ENV);
            String containerId = ENV.get("_FLINK_CONTAINER_ID");
            Preconditions.checkArgument((containerId != null ? 1 : 0) != 0, (String)"ContainerId variable %s not set", (Object[])new Object[]{"_FLINK_CONTAINER_ID"});
            SecurityUtils.getInstalledContext().runSecured(() -> {
                TaskManagerRunner.runTaskManager((Configuration)configuration, (ResourceID)new ResourceID(containerId));
                return null;
            });
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            LOG.error("YARN TaskManager initialization failed.", strippedThrowable);
            System.exit(31);
        }
    }

    @VisibleForTesting
    static void setupConfigurationAndInstallSecurityContext(Configuration configuration, String currDir, Map<String, String> variables) throws Exception {
        String localDirs = variables.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        LOG.info("Current working/local Directory: {}", (Object)localDirs);
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)configuration, (String)localDirs);
        YarnTaskExecutorRunner.setupConfigurationFromVariables(configuration, currDir, variables);
        YarnTaskExecutorRunner.installSecurityContext(configuration);
    }

    private static void setupConfigurationFromVariables(Configuration configuration, String currDir, Map<String, String> variables) throws IOException {
        String taskExecutorHostname;
        String yarnClientUsername = variables.get("HADOOP_USER_NAME");
        String remoteKeytabPath = variables.get("_KEYTAB_PATH");
        LOG.info("TM: remote keytab path obtained {}", (Object)remoteKeytabPath);
        String remoteKeytabPrincipal = variables.get("_KEYTAB_PRINCIPAL");
        LOG.info("TM: remote keytab principal obtained {}", (Object)remoteKeytabPrincipal);
        configuration.setBoolean(AkkaOptions.JVM_EXIT_ON_FATAL_ERROR, true);
        String keytabPath = null;
        if (remoteKeytabPath != null) {
            File f = new File(currDir, "krb5.keytab");
            keytabPath = f.getAbsolutePath();
            LOG.info("keytab path: {}", (Object)keytabPath);
        }
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.info("YARN daemon is running as: {} Yarn client user obtainer: {}", (Object)currentUser.getShortUserName(), (Object)yarnClientUsername);
        if (keytabPath != null && remoteKeytabPrincipal != null) {
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keytabPath);
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, remoteKeytabPrincipal);
        }
        if ((taskExecutorHostname = variables.get("_FLINK_NODE_ID")) != null) {
            configuration.setString(TaskManagerOptions.HOST, taskExecutorHostname);
        }
    }

    private static void installSecurityContext(Configuration configuration) throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        SecurityUtils.install((SecurityConfiguration)sc);
    }
}

