/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.entrypoint;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.JobClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.FileJobGraphRetriever;
import org.apache.flink.runtime.entrypoint.component.JobDispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.entrypoint.component.JobGraphRetriever;
import org.apache.flink.runtime.resourcemanager.ResourceManagerFactory;
import org.apache.flink.runtime.security.SecurityContext;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.entrypoint.YarnEntrypointUtils;
import org.apache.flink.yarn.entrypoint.YarnResourceManagerFactory;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;

public class YarnJobClusterEntrypoint
extends JobClusterEntrypoint {
    private final String workingDirectory;

    public YarnJobClusterEntrypoint(Configuration configuration, String workingDirectory) {
        super(configuration);
        this.workingDirectory = (String)Preconditions.checkNotNull((Object)workingDirectory);
    }

    protected SecurityContext installSecurityContext(Configuration configuration) throws Exception {
        return YarnEntrypointUtils.installSecurityContext(configuration, this.workingDirectory);
    }

    protected String getRPCPortRange(Configuration configuration) {
        return configuration.getString(YarnConfigOptions.APPLICATION_MASTER_PORT);
    }

    protected DispatcherResourceManagerComponentFactory<?> createDispatcherResourceManagerComponentFactory(Configuration configuration) {
        return new JobDispatcherResourceManagerComponentFactory((ResourceManagerFactory)YarnResourceManagerFactory.getInstance(), (JobGraphRetriever)FileJobGraphRetriever.createFrom((Configuration)configuration));
    }

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)YarnJobClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        Map<String, String> env = System.getenv();
        String workingDirectory = env.get(ApplicationConstants.Environment.PWD.key());
        Preconditions.checkArgument((workingDirectory != null ? 1 : 0) != 0, (String)"Working directory variable (%s) not set", (Object[])new Object[]{ApplicationConstants.Environment.PWD.key()});
        try {
            YarnEntrypointUtils.logYarnEnvironmentInformation(env, LOG);
        }
        catch (IOException e) {
            LOG.warn("Could not log YARN environment information.", (Throwable)e);
        }
        Configuration configuration = YarnEntrypointUtils.loadConfiguration(workingDirectory, env, LOG);
        YarnJobClusterEntrypoint yarnJobClusterEntrypoint = new YarnJobClusterEntrypoint(configuration, workingDirectory);
        ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)yarnJobClusterEntrypoint);
    }
}

