/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.highavailability;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.yarn.configuration.YarnConfigOptions;
import org.apache.flink.yarn.highavailability.AbstractYarnNonHaServices;

public class YarnPreConfiguredMasterNonHaServices
extends AbstractYarnNonHaServices {
    private final String resourceManagerRpcUrl;
    private final String dispatcherRpcUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YarnPreConfiguredMasterNonHaServices(Configuration config, org.apache.hadoop.conf.Configuration hadoopConf, HighAvailabilityServicesUtils.AddressResolution addressResolution) throws IOException {
        super(config, hadoopConf);
        boolean successful = false;
        try {
            String rmHost = config.getString(YarnConfigOptions.APP_MASTER_RPC_ADDRESS);
            int rmPort = config.getInteger(YarnConfigOptions.APP_MASTER_RPC_PORT);
            if (rmHost == null) {
                throw new IllegalConfigurationException("Config parameter '" + YarnConfigOptions.APP_MASTER_RPC_ADDRESS.key() + "' is missing.");
            }
            if (rmPort < 0) {
                throw new IllegalConfigurationException("Config parameter '" + YarnConfigOptions.APP_MASTER_RPC_PORT.key() + "' is missing.");
            }
            if (rmPort <= 0 || rmPort >= 65536) {
                throw new IllegalConfigurationException("Invalid value for '" + YarnConfigOptions.APP_MASTER_RPC_PORT.key() + "' - port must be in [1, 65535]");
            }
            this.resourceManagerRpcUrl = AkkaRpcServiceUtils.getRpcUrl((String)rmHost, (int)rmPort, (String)"resourcemanager", (HighAvailabilityServicesUtils.AddressResolution)addressResolution, (Configuration)config);
            this.dispatcherRpcUrl = AkkaRpcServiceUtils.getRpcUrl((String)rmHost, (int)rmPort, (String)"dispatcher", (HighAvailabilityServicesUtils.AddressResolution)addressResolution, (Configuration)config);
            successful = true;
        }
        finally {
            if (!successful) {
                try {
                    super.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        this.enter();
        try {
            StandaloneLeaderRetrievalService standaloneLeaderRetrievalService = new StandaloneLeaderRetrievalService(this.resourceManagerRpcUrl, DEFAULT_LEADER_ID);
            return standaloneLeaderRetrievalService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        this.enter();
        try {
            StandaloneLeaderRetrievalService standaloneLeaderRetrievalService = new StandaloneLeaderRetrievalService(this.dispatcherRpcUrl, DEFAULT_LEADER_ID);
            return standaloneLeaderRetrievalService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        this.enter();
        try {
            throw new UnsupportedOperationException("Not supported on the TaskManager side");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderElectionService getDispatcherLeaderElectionService() {
        this.enter();
        try {
            throw new UnsupportedOperationException("Not supported on the TaskManager side");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        this.enter();
        try {
            throw new UnsupportedOperationException("needs refactoring to accept default address");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderElectionService getWebMonitorLeaderElectionService() {
        this.enter();
        try {
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        this.enter();
        try {
            throw new UnsupportedOperationException("needs refactoring to accept default address");
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        this.enter();
        try {
            StandaloneLeaderRetrievalService standaloneLeaderRetrievalService = new StandaloneLeaderRetrievalService(defaultJobManagerAddress, DEFAULT_LEADER_ID);
            return standaloneLeaderRetrievalService;
        }
        finally {
            this.exit();
        }
    }

    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        this.enter();
        try {
            throw new UnsupportedOperationException();
        }
        catch (Throwable throwable) {
            this.exit();
            throw throwable;
        }
    }
}

