/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringInterner;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String KEYTAB_FILE_NAME = "krb5.keytab";
    public static final String KRB5_FILE_NAME = "krb5.conf";
    public static final String YARN_SITE_FILE_NAME = "yarn-site.xml";
    public static final int REMOTE_RESOURCES_FETCH_NUM_RETRY = 3;
    public static final int REMOTE_RESOURCES_FETCH_WAIT_IN_MILLI = 100;

    public static int calculateHeapSize(int memory, Configuration conf) {
        float memoryCutoffRatio = conf.getFloat(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO);
        int minCutoff = conf.getInteger(ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN);
        if (memoryCutoffRatio > 1.0f || memoryCutoffRatio < 0.0f) {
            throw new IllegalArgumentException("The configuration value '" + ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_RATIO.key() + "' must be between 0 and 1. Value given=" + memoryCutoffRatio);
        }
        if (minCutoff > memory) {
            throw new IllegalArgumentException("The configuration value '" + ResourceManagerOptions.CONTAINERIZED_HEAP_CUTOFF_MIN.key() + "' is higher (" + minCutoff + ") than the requested amount of memory " + memory);
        }
        int heapLimit = (int)((float)memory * memoryCutoffRatio);
        if (heapLimit < minCutoff) {
            heapLimit = minCutoff;
        }
        return memory - heapLimit;
    }

    public static void setupYarnClassPath(org.apache.hadoop.conf.Configuration conf, Map<String, String> appMasterEnv) {
        String[] applicationClassPathEntries;
        Utils.addToEnvironment(appMasterEnv, ApplicationConstants.Environment.CLASSPATH.name(), appMasterEnv.get("_FLINK_CLASSPATH"));
        for (String c : applicationClassPathEntries = conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            Utils.addToEnvironment(appMasterEnv, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
        }
    }

    static Tuple2<org.apache.hadoop.fs.Path, LocalResource> setupLocalResource(org.apache.hadoop.fs.FileSystem fs, String appId, org.apache.hadoop.fs.Path localSrcPath, org.apache.hadoop.fs.Path homedir, String relativeTargetPath) throws IOException {
        long dstModificationTime;
        File localFile = new File(localSrcPath.toUri().getPath());
        if (localFile.isDirectory()) {
            throw new IllegalArgumentException("File to copy must not be a directory: " + localSrcPath);
        }
        String suffix = ".flink/" + appId + (relativeTargetPath.isEmpty() ? "" : "/" + relativeTargetPath) + "/" + localSrcPath.getName();
        org.apache.hadoop.fs.Path dst = new org.apache.hadoop.fs.Path(homedir, suffix);
        LOG.debug("Copying from {} to {}", (Object)localSrcPath, (Object)dst);
        fs.copyFromLocalFile(false, true, localSrcPath, dst);
        FileStatus[] fss = null;
        for (int iter = 1; iter <= 4; ++iter) {
            try {
                fss = fs.listStatus(dst);
                break;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Got FileNotFoundException while fetching uploaded remote resources at retry num {}", (Object)iter);
                try {
                    LOG.debug("Sleeping for {}ms", (Object)100);
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Failed to sleep for {}ms at retry num {} while fetching uploaded remote resources", new Object[]{100, iter, ie});
                }
                continue;
            }
        }
        if (fss != null && fss.length > 0) {
            dstModificationTime = fss[0].getModificationTime();
            LOG.debug("Got modification time {} from remote path {}", (Object)dstModificationTime, (Object)dst);
        } else {
            dstModificationTime = localFile.lastModified();
            LOG.debug("Failed to fetch remote modification time from {}, using local timestamp {}", (Object)dst, (Object)dstModificationTime);
        }
        LocalResource resource = Utils.registerLocalResource(dst, localFile.length(), dstModificationTime);
        return Tuple2.of((Object)dst, (Object)resource);
    }

    public static void deleteApplicationFiles(Map<String, String> env) {
        String applicationFilesDir = env.get("_FLINK_YARN_FILES");
        if (!StringUtils.isNullOrWhitespaceOnly((String)applicationFilesDir)) {
            Path path = new Path(applicationFilesDir);
            try {
                FileSystem fileSystem = path.getFileSystem();
                if (!fileSystem.delete(path, true)) {
                    LOG.error("Deleting yarn application files under {} was unsuccessful.", (Object)applicationFilesDir);
                }
            }
            catch (IOException e) {
                LOG.error("Could not properly delete yarn application files directory {}.", (Object)applicationFilesDir, (Object)e);
            }
        } else {
            LOG.debug("No yarn application files directory set. Therefore, cannot clean up the data.");
        }
    }

    private static LocalResource registerLocalResource(org.apache.hadoop.fs.Path remoteRsrcPath, long resourceSize, long resourceModificationTime) {
        LocalResource localResource = (LocalResource)Records.newRecord(LocalResource.class);
        localResource.setResource(ConverterUtils.getYarnUrlFromURI((URI)remoteRsrcPath.toUri()));
        localResource.setSize(resourceSize);
        localResource.setTimestamp(resourceModificationTime);
        localResource.setType(LocalResourceType.FILE);
        localResource.setVisibility(LocalResourceVisibility.APPLICATION);
        return localResource;
    }

    private static LocalResource registerLocalResource(org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path remoteRsrcPath) throws IOException {
        LocalResource localResource = (LocalResource)Records.newRecord(LocalResource.class);
        FileStatus jarStat = fs.getFileStatus(remoteRsrcPath);
        localResource.setResource(ConverterUtils.getYarnUrlFromURI((URI)remoteRsrcPath.toUri()));
        localResource.setSize(jarStat.getLen());
        localResource.setTimestamp(jarStat.getModificationTime());
        localResource.setType(LocalResourceType.FILE);
        localResource.setVisibility(LocalResourceVisibility.APPLICATION);
        return localResource;
    }

    public static void setTokensFor(ContainerLaunchContext amContainer, List<org.apache.hadoop.fs.Path> paths, org.apache.hadoop.conf.Configuration conf) throws IOException {
        Credentials credentials = new Credentials();
        TokenCache.obtainTokensForNamenodes((Credentials)credentials, (org.apache.hadoop.fs.Path[])paths.toArray(new org.apache.hadoop.fs.Path[0]), (org.apache.hadoop.conf.Configuration)conf);
        Utils.obtainTokenForHBase(credentials, conf);
        UserGroupInformation currUsr = UserGroupInformation.getCurrentUser();
        Collection usrTok = currUsr.getTokens();
        for (Token token : usrTok) {
            Text id = new Text(token.getIdentifier());
            LOG.info("Adding user token " + id + " with " + token);
            credentials.addToken(id, token);
        }
        try (DataOutputBuffer dob = new DataOutputBuffer();){
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wrote tokens. Credentials buffer length: " + dob.getLength());
            }
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(securityTokens);
        }
    }

    private static void obtainTokenForHBase(Credentials credentials, org.apache.hadoop.conf.Configuration conf) throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Attempting to obtain Kerberos security token for HBase");
            try {
                Class.forName("org.apache.hadoop.hbase.HBaseConfiguration").getMethod("addHbaseResources", org.apache.hadoop.conf.Configuration.class).invoke(null, conf);
                LOG.info("HBase security setting: {}", (Object)conf.get("hbase.security.authentication"));
                if (!"kerberos".equals(conf.get("hbase.security.authentication"))) {
                    LOG.info("HBase has not been configured to use Kerberos.");
                    return;
                }
                LOG.info("Obtaining Kerberos security token for HBase");
                Token token = (Token)Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil").getMethod("obtainToken", org.apache.hadoop.conf.Configuration.class).invoke(null, conf);
                if (token == null) {
                    LOG.error("No Kerberos security token for HBase available");
                    return;
                }
                credentials.addToken(token.getService(), token);
                LOG.info("Added HBase Kerberos security token to credentials.");
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.info("HBase is not available (not packaged with this application): {} : \"{}\".", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            }
        }
    }

    public static void addToEnvironment(Map<String, String> environment, String variable, String value) {
        String val = environment.get(variable);
        val = val == null ? value : val + File.pathSeparator + value;
        environment.put(StringInterner.weakIntern((String)variable), StringInterner.weakIntern((String)val));
    }

    private Utils() {
        throw new RuntimeException();
    }

    public static Map<String, String> getEnvironmentVariables(String envPrefix, Configuration flinkConfiguration) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : flinkConfiguration.toMap().entrySet()) {
            if (!((String)entry.getKey()).startsWith(envPrefix) || ((String)entry.getKey()).length() <= envPrefix.length()) continue;
            String key = ((String)entry.getKey()).substring(envPrefix.length());
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    public static Map<String, LocalResource> calculateHopsLocalResources(Map<String, String> hopsLocalResources, YarnConfiguration yarnConfig) throws IOException {
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        for (String key : hopsLocalResources.keySet()) {
            org.apache.hadoop.fs.Path remoteJarPath = new org.apache.hadoop.fs.Path(hopsLocalResources.get(key));
            org.apache.hadoop.fs.FileSystem fs = remoteJarPath.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig);
            localResources.put(key, Utils.registerLocalResource(fs, remoteJarPath));
        }
        return localResources;
    }

    static ContainerLaunchContext createTaskExecutorContext(Configuration flinkConfig, YarnConfiguration yarnConfig, Map<String, String> env, ContaineredTaskManagerParameters tmParams, String taskManagerDynamicProperties, String workingDirectory, Class<?> taskManagerMainClass, Logger log) throws Exception {
        org.apache.hadoop.fs.FileSystem fs;
        String classPathString;
        String remoteFlinkJarPath = env.get("_FLINK_JAR_PATH");
        Utils.require(remoteFlinkJarPath != null, "Environment variable %s not set", "_FLINK_JAR_PATH");
        String appId = env.get("_APP_ID");
        Utils.require(appId != null, "Environment variable %s not set", "_APP_ID");
        String clientHomeDir = env.get("_CLIENT_HOME_DIR");
        Utils.require(clientHomeDir != null, "Environment variable %s not set", "_CLIENT_HOME_DIR");
        String shipListString = env.get("_CLIENT_SHIP_FILES");
        Utils.require(shipListString != null, "Environment variable %s not set", "_CLIENT_SHIP_FILES");
        String yarnClientUsername = env.get("HADOOP_USER_NAME");
        Utils.require(yarnClientUsername != null, "Environment variable %s not set", "HADOOP_USER_NAME");
        String remoteKeytabPath = env.get("_KEYTAB_PATH");
        String remoteKeytabPrincipal = env.get("_KEYTAB_PRINCIPAL");
        String remoteYarnConfPath = env.get("_YARN_SITE_XML_PATH");
        String remoteKrb5Path = env.get("_KRB5_PATH");
        if (log.isDebugEnabled()) {
            log.debug("TM:remote keytab path obtained {}", (Object)remoteKeytabPath);
            log.debug("TM:remote keytab principal obtained {}", (Object)remoteKeytabPrincipal);
            log.debug("TM:remote yarn conf path obtained {}", (Object)remoteYarnConfPath);
            log.debug("TM:remote krb5 path obtained {}", (Object)remoteKrb5Path);
        }
        Utils.require((classPathString = env.get("_FLINK_CLASSPATH")) != null, "Environment variable %s not set", "_FLINK_CLASSPATH");
        LocalResource keytabResource = null;
        if (remoteKeytabPath != null) {
            log.info("Adding keytab {} to the AM container local resource bucket", (Object)remoteKeytabPath);
            org.apache.hadoop.fs.Path keytabPath = new org.apache.hadoop.fs.Path(remoteKeytabPath);
            org.apache.hadoop.fs.FileSystem fs2 = keytabPath.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig);
            keytabResource = Utils.registerLocalResource(fs2, keytabPath);
        }
        LocalResource yarnConfResource = null;
        LocalResource krb5ConfResource = null;
        boolean hasKrb5 = false;
        if (remoteYarnConfPath != null) {
            log.info("TM:Adding remoteYarnConfPath {} to the container local resource bucket", (Object)remoteYarnConfPath);
            org.apache.hadoop.fs.Path yarnConfPath = new org.apache.hadoop.fs.Path(remoteYarnConfPath);
            fs = yarnConfPath.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig);
            yarnConfResource = Utils.registerLocalResource(fs, yarnConfPath);
        }
        if (remoteKrb5Path != null) {
            log.info("TM:Adding remoteKrb5Path {} to the container local resource bucket", (Object)remoteKrb5Path);
            org.apache.hadoop.fs.Path krb5ConfPath = new org.apache.hadoop.fs.Path(remoteKrb5Path);
            fs = krb5ConfPath.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig);
            krb5ConfResource = Utils.registerLocalResource(fs, krb5ConfPath);
            hasKrb5 = true;
        }
        org.apache.hadoop.fs.Path remoteJarPath = new org.apache.hadoop.fs.Path(remoteFlinkJarPath);
        String[] fs3 = remoteJarPath.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig);
        LocalResource flinkJar = Utils.registerLocalResource((org.apache.hadoop.fs.FileSystem)fs3, remoteJarPath);
        HashMap<String, LocalResource> taskManagerLocalResources = new HashMap<String, LocalResource>();
        taskManagerLocalResources.put("flink.jar", flinkJar);
        if (yarnConfResource != null) {
            taskManagerLocalResources.put(YARN_SITE_FILE_NAME, yarnConfResource);
        }
        if (krb5ConfResource != null) {
            taskManagerLocalResources.put(KRB5_FILE_NAME, krb5ConfResource);
        }
        if (keytabResource != null) {
            taskManagerLocalResources.put(KEYTAB_FILE_NAME, keytabResource);
        }
        for (String pathStr : shipListString.split(",")) {
            if (pathStr.isEmpty()) continue;
            String[] keyAndPath = pathStr.split("=");
            Utils.require(keyAndPath.length == 2, "Invalid entry in ship file list: %s", pathStr);
            org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(keyAndPath[1]);
            LocalResource resource = Utils.registerLocalResource(path.getFileSystem((org.apache.hadoop.conf.Configuration)yarnConfig), path);
            taskManagerLocalResources.put(keyAndPath[0], resource);
        }
        log.info("Creating container launch context for TaskManagers");
        boolean hasLogback = new File(workingDirectory, "logback.xml").exists();
        boolean hasLog4j = new File(workingDirectory, "log4j.properties").exists();
        String launchCommand = BootstrapTools.getTaskManagerShellCommand((Configuration)flinkConfig, (ContaineredTaskManagerParameters)tmParams, (String)".", (String)"<LOG_DIR>", (boolean)hasLogback, (boolean)hasLog4j, (boolean)hasKrb5, taskManagerMainClass, (String)taskManagerDynamicProperties);
        if (log.isDebugEnabled()) {
            log.debug("Starting TaskManagers with command: " + launchCommand);
        } else {
            log.info("Starting TaskManagers");
        }
        ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        ctx.setCommands(Collections.singletonList(launchCommand));
        ctx.setLocalResources(taskManagerLocalResources);
        HashMap<String, String> containerEnv = new HashMap<String, String>();
        containerEnv.putAll(tmParams.taskManagerEnv());
        containerEnv.put("_FLINK_CLASSPATH", classPathString);
        Utils.setupYarnClassPath((org.apache.hadoop.conf.Configuration)yarnConfig, containerEnv);
        containerEnv.put("HADOOP_USER_NAME", UserGroupInformation.getCurrentUser().getUserName());
        if (remoteKeytabPath != null && remoteKeytabPrincipal != null) {
            containerEnv.put("_KEYTAB_PATH", remoteKeytabPath);
            containerEnv.put("_KEYTAB_PRINCIPAL", remoteKeytabPrincipal);
        }
        ctx.setEnvironment(containerEnv);
        String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (fileLocation != null) {
            log.debug("Adding security tokens to TaskExecutor's container launch context.");
            try (DataOutputBuffer dob = new DataOutputBuffer();){
                Method readTokenStorageFileMethod = Credentials.class.getMethod("readTokenStorageFile", File.class, org.apache.hadoop.conf.Configuration.class);
                Credentials cred = (Credentials)readTokenStorageFileMethod.invoke(null, new File(fileLocation), HadoopUtils.getHadoopConfiguration((Configuration)flinkConfig));
                Credentials taskManagerCred = new Credentials();
                Collection userTokens = cred.getAllTokens();
                for (Token token : userTokens) {
                    if (token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
                    Text id = new Text(token.getIdentifier());
                    taskManagerCred.addToken(id, token);
                }
                taskManagerCred.writeTokenStorageToStream((DataOutputStream)dob);
                ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
                ctx.setTokens(securityTokens);
            }
            catch (Throwable t) {
                log.error("Failed to add Hadoop's security tokens.", t);
            }
        } else {
            log.info("Could not set security tokens because Hadoop's token file location is unknown.");
        }
        return ctx;
    }

    static void require(boolean condition, String message, Object ... values) {
        if (!condition) {
            throw new RuntimeException(String.format(message, values));
        }
    }

    static String getDynamicProperties(Configuration baseConfig, Configuration targetConfig) {
        CharSequence[] newAddedConfigs = (String[])targetConfig.keySet().stream().flatMap(key -> {
            String baseValue = baseConfig.getString(ConfigOptions.key((String)key).noDefaultValue());
            String targetValue = targetConfig.getString(ConfigOptions.key((String)key).noDefaultValue());
            if (!baseConfig.keySet().contains(key) || !baseValue.equals(targetValue)) {
                return Stream.of("-" + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getOpt() + key + CommandLineOptions.DYNAMIC_PROPERTY_OPTION.getValueSeparator() + targetValue);
            }
            return Stream.empty();
        }).toArray(String[]::new);
        return String.join((CharSequence)" ", newAddedConfigs);
    }
}

