/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class HadoopArchiveLogsRunner
implements Tool {
    private static final Log LOG = LogFactory.getLog(HadoopArchiveLogsRunner.class);
    private static final String APP_ID_OPTION = "appId";
    private static final String USER_OPTION = "user";
    private static final String WORKING_DIR_OPTION = "workingDir";
    private static final String REMOTE_ROOT_LOG_DIR_OPTION = "remoteRootLogDir";
    private static final String SUFFIX_OPTION = "suffix";
    private static final String NO_PROXY_OPTION = "noProxy";
    private String appId;
    private String user;
    private String workingDir;
    private String remoteLogDir;
    private String suffix;
    private boolean proxy;
    private JobConf conf;
    private static final FsPermission HAR_DIR_PERM = new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.NONE);
    private static final FsPermission HAR_INNER_FILES_PERM = new FsPermission(FsAction.READ_WRITE, FsAction.READ, FsAction.NONE);

    public HadoopArchiveLogsRunner(Configuration conf) {
        this.setConf(conf);
    }

    public static void main(String[] args) {
        JobConf job = new JobConf(HadoopArchiveLogsRunner.class);
        HadoopArchiveLogsRunner halr = new HadoopArchiveLogsRunner((Configuration)job);
        int ret = 0;
        try {
            ret = ToolRunner.run((Tool)halr, (String[])args);
        }
        catch (Exception e) {
            LOG.debug((Object)"Exception", (Throwable)e);
            System.err.println(e.getClass().getSimpleName());
            String s = e.getLocalizedMessage();
            if (s != null) {
                System.err.println(s);
            } else {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        System.exit(ret);
    }

    public int run(String[] args) throws Exception {
        this.handleOpts(args);
        Integer exitCode = 1;
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        if (!this.proxy || loginUser.getShortUserName().equals(this.user)) {
            LOG.info((Object)("Running as " + this.user));
            exitCode = this.runInternal();
        } else {
            LOG.info((Object)("Running as " + loginUser.getShortUserName() + " but will impersonate " + this.user));
            UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)loginUser);
            exitCode = (Integer)proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Integer>(){

                @Override
                public Integer run() throws Exception {
                    return HadoopArchiveLogsRunner.this.runInternal();
                }
            });
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runInternal() throws Exception {
        String remoteAppLogDir = this.remoteLogDir + File.separator + this.user + File.separator + this.suffix + File.separator + this.appId;
        this.conf.set("mapreduce.framework.name", "local");
        this.conf.set("fs.permissions.umask-mode", "027");
        HadoopArchives ha = new HadoopArchives((Configuration)this.conf);
        String[] haArgs = new String[]{"-archiveName", this.appId + ".har", "-p", remoteAppLogDir, "*", this.workingDir};
        StringBuilder sb = new StringBuilder("Executing 'hadoop archives'");
        for (String haArg : haArgs) {
            sb.append("\n\t").append(haArg);
        }
        LOG.info((Object)sb.toString());
        ha.run(haArgs);
        try (FileSystem fs = null;){
            fs = FileSystem.get((Configuration)this.conf);
            Path harDest = new Path(remoteAppLogDir, this.appId + ".har");
            LOG.info((Object)"Moving har to original location");
            fs.rename(new Path(this.workingDir, this.appId + ".har"), harDest);
            LOG.info((Object)"Deleting original logs");
            for (FileStatus original : fs.listStatus(new Path(remoteAppLogDir), new PathFilter(){

                public boolean accept(Path path) {
                    return !path.getName().endsWith(".har");
                }
            })) {
                fs.delete(original.getPath(), false);
            }
        }
        return 0;
    }

    private void handleOpts(String[] args) throws ParseException {
        Options opts = new Options();
        Option appIdOpt = new Option(APP_ID_OPTION, true, "Application ID");
        appIdOpt.setRequired(true);
        Option userOpt = new Option(USER_OPTION, true, "User");
        userOpt.setRequired(true);
        Option workingDirOpt = new Option(WORKING_DIR_OPTION, true, "Working Directory");
        workingDirOpt.setRequired(true);
        Option remoteLogDirOpt = new Option(REMOTE_ROOT_LOG_DIR_OPTION, true, "Remote Root Log Directory");
        remoteLogDirOpt.setRequired(true);
        Option suffixOpt = new Option(SUFFIX_OPTION, true, "Suffix");
        suffixOpt.setRequired(true);
        Option useProxyOpt = new Option(NO_PROXY_OPTION, false, "Use Proxy");
        opts.addOption(appIdOpt);
        opts.addOption(userOpt);
        opts.addOption(workingDirOpt);
        opts.addOption(remoteLogDirOpt);
        opts.addOption(suffixOpt);
        opts.addOption(useProxyOpt);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(opts, args);
        this.appId = commandLine.getOptionValue(APP_ID_OPTION);
        this.user = commandLine.getOptionValue(USER_OPTION);
        this.workingDir = commandLine.getOptionValue(WORKING_DIR_OPTION);
        this.remoteLogDir = commandLine.getOptionValue(REMOTE_ROOT_LOG_DIR_OPTION);
        this.suffix = commandLine.getOptionValue(SUFFIX_OPTION);
        this.proxy = true;
        if (commandLine.hasOption(NO_PROXY_OPTION)) {
            this.proxy = false;
        }
    }

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf, HadoopArchiveLogsRunner.class);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

