/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKerberosName {
    @Before
    public void setUp() throws Exception {
        System.setProperty("java.security.krb5.realm", KerberosTestUtils.getRealm());
        System.setProperty("java.security.krb5.kdc", "localhost:88");
        String rules = "RULE:[1:$1@$0](.*@YAHOO\\.COM)s/@.*//\nRULE:[2:$1](johndoe)s/^.*$/guest/\nRULE:[2:$1;$2](^.*;admin$)s/;admin$//\nRULE:[2:$2](root)\nDEFAULT";
        KerberosName.setRules((String)rules);
        KerberosName.printRules();
    }

    private void checkTranslation(String from, String to) throws Exception {
        System.out.println("Translate " + from);
        KerberosName nm = new KerberosName(from);
        String simple = nm.getShortName();
        System.out.println("to " + simple);
        Assert.assertEquals((String)"short name incorrect", (Object)to, (Object)simple);
    }

    @Test
    public void testRules() throws Exception {
        this.checkTranslation("omalley@" + KerberosTestUtils.getRealm(), "omalley");
        this.checkTranslation("hdfs/10.0.0.1@" + KerberosTestUtils.getRealm(), "hdfs");
        this.checkTranslation("oom@YAHOO.COM", "oom");
        this.checkTranslation("johndoe/zoo@FOO.COM", "guest");
        this.checkTranslation("joe/admin@FOO.COM", "joe");
        this.checkTranslation("joe/root@FOO.COM", "root");
    }

    private void checkBadName(String name) {
        System.out.println("Checking " + name + " to ensure it is bad.");
        try {
            new KerberosName(name);
            Assert.fail((String)("didn't get exception for " + name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAntiPatterns() throws Exception {
        this.checkBadName("owen/owen/owen@FOO.COM");
        this.checkBadName("owen@foo/bar.com");
        this.checkTranslation("foo@ACME.COM", "foo@ACME.COM");
        this.checkTranslation("root/joe@FOO.COM", "root/joe@FOO.COM");
    }

    @Test
    public void testParsing() throws Exception {
        String principalNameFull = "HTTP/abc.com@EXAMPLE.COM";
        String principalNameWoRealm = "HTTP/abc.com";
        String principalNameWoHost = "HTTP@EXAMPLE.COM";
        KerberosName kerbNameFull = new KerberosName("HTTP/abc.com@EXAMPLE.COM");
        Assert.assertEquals((Object)"HTTP", (Object)kerbNameFull.getServiceName());
        Assert.assertEquals((Object)"abc.com", (Object)kerbNameFull.getHostName());
        Assert.assertEquals((Object)"EXAMPLE.COM", (Object)kerbNameFull.getRealm());
        KerberosName kerbNamewoRealm = new KerberosName("HTTP/abc.com");
        Assert.assertEquals((Object)"HTTP", (Object)kerbNamewoRealm.getServiceName());
        Assert.assertEquals((Object)"abc.com", (Object)kerbNamewoRealm.getHostName());
        Assert.assertEquals(null, (Object)kerbNamewoRealm.getRealm());
        KerberosName kerbNameWoHost = new KerberosName("HTTP@EXAMPLE.COM");
        Assert.assertEquals((Object)"HTTP", (Object)kerbNameWoHost.getServiceName());
        Assert.assertEquals(null, (Object)kerbNameWoHost.getHostName());
        Assert.assertEquals((Object)"EXAMPLE.COM", (Object)kerbNameWoHost.getRealm());
    }

    @Test
    public void testToLowerCase() throws Exception {
        String rules = "RULE:[1:$1]/L\nRULE:[2:$1]/L\nRULE:[2:$1;$2](^.*;admin$)s/;admin$///L\nRULE:[2:$1;$2](^.*;guest$)s/;guest$//g/L\nDEFAULT";
        KerberosName.setRules((String)rules);
        KerberosName.printRules();
        this.checkTranslation("Joe@FOO.COM", "joe");
        this.checkTranslation("Joe/root@FOO.COM", "joe");
        this.checkTranslation("Joe/admin@FOO.COM", "joe");
        this.checkTranslation("Joe/guestguest@FOO.COM", "joe");
    }

    @After
    public void clear() {
        System.clearProperty("java.security.krb5.realm");
        System.clearProperty("java.security.krb5.kdc");
    }
}

