/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.security.authentication.util.FileSignerSecretProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestFileSignerSecretProvider {
    @Test
    public void testGetSecrets() throws Exception {
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        String secretValue = "hadoop";
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write(secretValue);
        ((Writer)writer).close();
        FileSignerSecretProvider secretProvider = new FileSignerSecretProvider();
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret.file", secretFile.getAbsolutePath());
        secretProvider.init(secretProviderProps, null, -1L);
        Assert.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])secretProvider.getCurrentSecret());
        byte[][] allSecrets = secretProvider.getAllSecrets();
        Assert.assertEquals((long)1L, (long)allSecrets.length);
        Assert.assertArrayEquals((byte[])secretValue.getBytes(), (byte[])allSecrets[0]);
    }
}

