/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingThreadPoolExecutorService
extends ForwardingListeningExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingThreadPoolExecutorService.class);
    private Semaphore queueingPermits;
    private ListeningExecutorService executorDelegatee;
    private static final AtomicInteger POOLNUMBER = new AtomicInteger(1);

    public static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNum = BlockingThreadPoolExecutorService.access$000().getAndIncrement();
            private final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-pool" + this.poolNum + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }

    private static ThreadFactory newDaemonThreadFactory(String prefix) {
        final ThreadFactory namedFactory = BlockingThreadPoolExecutorService.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    public BlockingThreadPoolExecutorService(int activeTasks, int waitingTasks, long keepAliveTime, TimeUnit unit, String prefixName) {
        this.queueingPermits = new Semaphore(waitingTasks + activeTasks, false);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(waitingTasks + activeTasks);
        ThreadPoolExecutor eventProcessingExecutor = new ThreadPoolExecutor(activeTasks, activeTasks, keepAliveTime, unit, workQueue, BlockingThreadPoolExecutorService.newDaemonThreadFactory(prefixName), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                LOG.error("Could not submit task to executor {}", (Object)executor.toString());
            }
        });
        eventProcessingExecutor.allowCoreThreadTimeOut(true);
        this.executorDelegatee = MoreExecutors.listeningDecorator((ExecutorService)eventProcessingExecutor);
    }

    protected ListeningExecutorService delegate() {
        return this.executorDelegatee;
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task), result);
    }

    public ListenableFuture<?> submit(Runnable task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedCheckedFuture((Exception)e);
        }
        return super.submit((Runnable)new RunnableWithPermitRelease(task));
    }

    public void execute(Runnable command) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute((Runnable)new RunnableWithPermitRelease(command));
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new RuntimeException("Not implemented");
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("Not implemented");
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("Not implemented");
    }

    static /* synthetic */ AtomicInteger access$000() {
        return POOLNUMBER;
    }

    class CallableWithPermitRelease<T>
    implements Callable<T> {
        private Callable<T> delegatee;

        public CallableWithPermitRelease(Callable<T> delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public T call() throws Exception {
            try {
                T t = this.delegatee.call();
                return t;
            }
            finally {
                BlockingThreadPoolExecutorService.this.queueingPermits.release();
            }
        }
    }

    class RunnableWithPermitRelease
    implements Runnable {
        private Runnable delegatee;

        public RunnableWithPermitRelease(Runnable delegatee) {
            this.delegatee = delegatee;
        }

        @Override
        public void run() {
            try {
                this.delegatee.run();
            }
            finally {
                BlockingThreadPoolExecutorService.this.queueingPermits.release();
            }
        }
    }
}

