/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.s3a.ProgressableProgressListener;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AOutputStream
extends OutputStream {
    private OutputStream backupStream;
    private File backupFile;
    private boolean closed;
    private String key;
    private Progressable progress;
    private long partSize;
    private long partSizeThreshold;
    private S3AFileSystem fs;
    private LocalDirAllocator lDirAlloc;
    public static final Logger LOG = S3AFileSystem.LOG;

    public S3AOutputStream(Configuration conf, S3AFileSystem fs, String key, Progressable progress) throws IOException {
        this.key = key;
        this.progress = progress;
        this.fs = fs;
        this.partSize = fs.getPartitionSize();
        this.partSizeThreshold = fs.getMultiPartThreshold();
        this.lDirAlloc = conf.get("fs.s3a.buffer.dir", null) != null ? new LocalDirAllocator("fs.s3a.buffer.dir") : new LocalDirAllocator("${hadoop.tmp.dir}/s3a");
        this.backupFile = this.lDirAlloc.createTmpFileForWrite("output-", -1L, conf);
        this.closed = false;
        LOG.debug("OutputStream for key '{}' writing to tempfile: {}", (Object)key, (Object)this.backupFile);
        this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
    }

    @Override
    public void flush() throws IOException {
        this.backupStream.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.backupStream.close();
        LOG.debug("OutputStream for key '{}' closed. Now beginning upload", (Object)this.key);
        LOG.debug("Minimum upload part size: {} threshold {}", (Object)this.partSize, (Object)this.partSizeThreshold);
        try {
            ObjectMetadata om = this.fs.newObjectMetadata();
            Upload upload = this.fs.putObject(this.fs.newPutObjectRequest(this.key, om, this.backupFile));
            ProgressableProgressListener listener = new ProgressableProgressListener(this.fs, this.key, upload, this.progress);
            upload.addProgressListener((ProgressListener)listener);
            upload.waitForUploadResult();
            listener.uploadCompleted();
            this.fs.finishedWrite(this.key);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException("saving output", this.key, e);
        }
        finally {
            if (!this.backupFile.delete()) {
                LOG.warn("Could not delete temporary s3a file: {}", (Object)this.backupFile);
            }
            super.close();
            this.closed = true;
        }
        LOG.debug("OutputStream for key '{}' upload complete", (Object)this.key);
    }

    @Override
    public void write(int b) throws IOException {
        this.backupStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.backupStream.write(b, off, len);
    }
}

