/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.fs.s3a.Statistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3AStorageStatistics
extends StorageStatistics
implements Iterable<StorageStatistics.LongStatistic> {
    private static final Logger LOG = LoggerFactory.getLogger(S3AStorageStatistics.class);
    public static final String NAME = "S3AStorageStatistics";
    private final Map<Statistic, AtomicLong> opsCount = new EnumMap<Statistic, AtomicLong>(Statistic.class);

    public S3AStorageStatistics() {
        super(NAME);
        for (Statistic opType : Statistic.values()) {
            this.opsCount.put(opType, new AtomicLong(0L));
        }
    }

    public long incrementCounter(Statistic op, long count) {
        long updated = this.opsCount.get((Object)op).addAndGet(count);
        LOG.debug("{} += {}  ->  {}", new Object[]{op, count, updated});
        return updated;
    }

    public String getScheme() {
        return "s3a";
    }

    public Iterator<StorageStatistics.LongStatistic> getLongStatistics() {
        return new LongIterator();
    }

    @Override
    public Iterator<StorageStatistics.LongStatistic> iterator() {
        return this.getLongStatistics();
    }

    public Long getLong(String key) {
        Statistic type = Statistic.fromSymbol(key);
        return type == null ? null : Long.valueOf(this.opsCount.get((Object)type).get());
    }

    public boolean isTracked(String key) {
        return Statistic.fromSymbol(key) != null;
    }

    public void reset() {
        for (AtomicLong value : this.opsCount.values()) {
            value.set(0L);
        }
    }

    private class LongIterator
    implements Iterator<StorageStatistics.LongStatistic> {
        private Iterator<Map.Entry<Statistic, AtomicLong>> iterator;

        private LongIterator() {
            this.iterator = Collections.unmodifiableSet(S3AStorageStatistics.this.opsCount.entrySet()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public StorageStatistics.LongStatistic next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<Statistic, AtomicLong> entry = this.iterator.next();
            return new StorageStatistics.LongStatistic(entry.getKey().getSymbol(), entry.getValue().get());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

