/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.adl.AdlFileSystem;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestAdlSdkConfiguration {
    @Test
    public void testDefaultTimeout() throws IOException {
        AdlFileSystem fs = null;
        Configuration conf = null;
        conf = AdlStorageConfiguration.getConfiguration();
        conf.setInt("adl.http.timeout", -1);
        try {
            fs = (AdlFileSystem)AdlStorageConfiguration.createStorageConnector(conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        Assume.assumeNotNull((Object[])new Object[]{fs});
        int effectiveTimeout = fs.getAdlClient().getDefaultTimeout();
        Assert.assertFalse((String)"A negative timeout is not supposed to take effect", (effectiveTimeout < 0 ? 1 : 0) != 0);
        conf = AdlStorageConfiguration.getConfiguration();
        conf.setInt("adl.http.timeout", 17);
        try {
            fs = (AdlFileSystem)AdlStorageConfiguration.createStorageConnector(conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can not initialize ADL FileSystem. Please check test.fs.adl.name property.", e);
        }
        effectiveTimeout = fs.getAdlClient().getDefaultTimeout();
        Assert.assertEquals((String)"Timeout is getting set", (long)effectiveTimeout, (long)17L);
    }
}

