/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.adl.live;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.adl.common.Parallelized;
import org.apache.hadoop.fs.adl.live.AdlStorageConfiguration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parallelized.class)
public class TestAdlInternalCreateNonRecursive {
    private Path inputFileName;
    private FsPermission inputPermission;
    private boolean inputOverride;
    private boolean inputFileAlreadyExist;
    private boolean inputParentAlreadyExist;
    private Class<IOException> expectedExceptionType;
    private FileSystem adlStore;

    public TestAdlInternalCreateNonRecursive(String testScenario, String fileName, FsPermission permission, boolean override, boolean fileAlreadyExist, boolean parentAlreadyExist, Class<IOException> exceptionType) {
        this.inputFileName = new Path("/test/createNonRecursive/" + UUID.randomUUID().toString(), fileName);
        this.inputPermission = permission;
        this.inputFileAlreadyExist = fileAlreadyExist;
        this.inputOverride = override;
        this.inputParentAlreadyExist = parentAlreadyExist;
        this.expectedExceptionType = exceptionType;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection adlCreateNonRecursiveTestData() throws UnsupportedEncodingException {
        return Arrays.asList({"CNR - When file do not exist.", UUID.randomUUID().toString(), FsPermission.getFileDefault(), false, false, true, null}, {"CNR - When file exist. Override false", UUID.randomUUID().toString(), FsPermission.getFileDefault(), false, true, true, FileAlreadyExistsException.class}, {"CNR - When file exist. Override true", UUID.randomUUID().toString(), FsPermission.getFileDefault(), true, true, true, null});
    }

    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)AdlStorageConfiguration.isContractTestEnabled());
        this.adlStore = AdlStorageConfiguration.createStorageConnector();
    }

    @Test
    public void testCreateNonRecursiveFunctionality() throws IOException {
        if (this.inputFileAlreadyExist) {
            FileSystem.create((FileSystem)this.adlStore, (Path)this.inputFileName, (FsPermission)this.inputPermission);
        }
        if (this.inputParentAlreadyExist) {
            this.adlStore.mkdirs(this.inputFileName.getParent());
        } else {
            this.adlStore.delete(this.inputFileName.getParent(), true);
        }
        try {
            this.adlStore.createNonRecursive(this.inputFileName, this.inputPermission, this.inputOverride, 4096, this.adlStore.getDefaultReplication(this.inputFileName), this.adlStore.getDefaultBlockSize(this.inputFileName), null);
        }
        catch (IOException e) {
            if (this.expectedExceptionType == null) {
                throw e;
            }
            Assert.assertEquals(this.expectedExceptionType, e.getClass());
            return;
        }
        if (this.expectedExceptionType != null) {
            Assert.fail((String)("CreateNonRecursive should have failed with exception " + this.expectedExceptionType.getName()));
        }
    }
}

