/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.ResponseReceivedEvent;
import com.microsoft.azure.storage.SendingRequestEvent;
import com.microsoft.azure.storage.StorageEvent;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.BlobOperationDescriptor;
import org.junit.Test;

public class TestBlobOperationDescriptor
extends AbstractWasbTestBase {
    private BlobOperationDescriptor.OperationType lastOperationTypeReceived;
    private BlobOperationDescriptor.OperationType lastOperationTypeSent;
    private long lastContentLengthReceived;

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }

    @Test
    public void testAppendBlockOperations() throws Exception {
        CloudBlobContainer container = this.getTestAccount().getRealContainer();
        OperationContext context = new OperationContext();
        context.getResponseReceivedEventHandler().addListener((StorageEvent)new ResponseReceivedEventHandler());
        context.getSendingRequestEventHandler().addListener((StorageEvent)new SendingRequestEventHandler());
        CloudAppendBlob appendBlob = container.getAppendBlobReference("testAppendBlockOperations");
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
        try (BlobOutputStream output = appendBlob.openWriteNew(null, null, context);){
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.CreateBlob, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
            String message = "this is a test";
            output.write(message.getBytes("UTF-8"));
            output.flush();
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.AppendBlock, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.AppendBlock, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)message.length(), (long)this.lastContentLengthReceived);
        }
    }

    @Test
    public void testPutBlockOperations() throws Exception {
        CloudBlobContainer container = this.getTestAccount().getRealContainer();
        OperationContext context = new OperationContext();
        context.getResponseReceivedEventHandler().addListener((StorageEvent)new ResponseReceivedEventHandler());
        context.getSendingRequestEventHandler().addListener((StorageEvent)new SendingRequestEventHandler());
        CloudBlockBlob blockBlob = container.getBlockBlobReference("testPutBlockOperations");
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
        try (BlobOutputStream output = blockBlob.openOutputStream(null, null, context);){
            TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
            String message = "this is a test";
            output.write(message.getBytes("UTF-8"));
            output.flush();
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlock, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlock, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)message.length(), (long)this.lastContentLengthReceived);
        }
        TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlockList, (Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlockList, (Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
    }

    @Test
    public void testPutPageOperations() throws Exception {
        CloudBlobContainer container = this.getTestAccount().getRealContainer();
        OperationContext context = new OperationContext();
        context.getResponseReceivedEventHandler().addListener((StorageEvent)new ResponseReceivedEventHandler());
        context.getSendingRequestEventHandler().addListener((StorageEvent)new SendingRequestEventHandler());
        CloudPageBlob pageBlob = container.getPageBlobReference("testPutPageOperations");
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
        try (BlobOutputStream output = pageBlob.openWriteNew(1024L, null, null, context);){
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.CreateBlob, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
            int pageSize = 512;
            byte[] buffer = new byte[512];
            output.write(buffer);
            output.flush();
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutPage, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutPage, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)buffer.length, (long)this.lastContentLengthReceived);
        }
    }

    @Test
    public void testGetBlobOperations() throws Exception {
        CloudBlobContainer container = this.getTestAccount().getRealContainer();
        OperationContext context = new OperationContext();
        context.getResponseReceivedEventHandler().addListener((StorageEvent)new ResponseReceivedEventHandler());
        context.getSendingRequestEventHandler().addListener((StorageEvent)new SendingRequestEventHandler());
        CloudBlockBlob blockBlob = container.getBlockBlobReference("testGetBlobOperations");
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
        String message = "this is a test";
        try (BlobOutputStream output = blockBlob.openOutputStream(null, null, context);){
            TestBlobOperationDescriptor.assertNull((Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
            output.write(message.getBytes("UTF-8"));
            output.flush();
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlock, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlock, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)message.length(), (long)this.lastContentLengthReceived);
        }
        TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlockList, (Object)this.lastOperationTypeSent);
        TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.PutBlockList, (Object)this.lastOperationTypeReceived);
        TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
        var6_6 = null;
        try (BlobInputStream input = blockBlob.openInputStream(null, null, context);){
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.GetProperties, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.GetProperties, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)0L, (long)this.lastContentLengthReceived);
            byte[] buffer = new byte[1024];
            int numBytesRead = input.read(buffer);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.GetBlob, (Object)this.lastOperationTypeSent);
            TestBlobOperationDescriptor.assertEquals((Object)BlobOperationDescriptor.OperationType.GetBlob, (Object)this.lastOperationTypeReceived);
            TestBlobOperationDescriptor.assertEquals((long)message.length(), (long)this.lastContentLengthReceived);
            TestBlobOperationDescriptor.assertEquals((long)numBytesRead, (long)this.lastContentLengthReceived);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    private void responseReceived(ResponseReceivedEvent event) {
        BlobOperationDescriptor.OperationType operationType;
        HttpURLConnection conn = (HttpURLConnection)event.getConnectionObject();
        this.lastOperationTypeReceived = operationType = BlobOperationDescriptor.getOperationType((HttpURLConnection)conn);
        switch (operationType) {
            case AppendBlock: 
            case PutBlock: 
            case PutPage: {
                this.lastContentLengthReceived = BlobOperationDescriptor.getContentLengthIfKnown((HttpURLConnection)conn, (BlobOperationDescriptor.OperationType)operationType);
                break;
            }
            case GetBlob: {
                this.lastContentLengthReceived = BlobOperationDescriptor.getContentLengthIfKnown((HttpURLConnection)conn, (BlobOperationDescriptor.OperationType)operationType);
                break;
            }
            default: {
                this.lastContentLengthReceived = 0L;
            }
        }
    }

    private void sendingRequest(SendingRequestEvent event) {
        this.lastOperationTypeSent = BlobOperationDescriptor.getOperationType((HttpURLConnection)((HttpURLConnection)event.getConnectionObject()));
    }

    @InterfaceAudience.Private
    class SendingRequestEventHandler
    extends StorageEvent<SendingRequestEvent> {
        SendingRequestEventHandler() {
        }

        public void eventOccurred(SendingRequestEvent event) {
            TestBlobOperationDescriptor.this.sendingRequest(event);
        }
    }

    @InterfaceAudience.Private
    class ResponseReceivedEventHandler
    extends StorageEvent<ResponseReceivedEvent> {
        ResponseReceivedEventHandler() {
        }

        public void eventOccurred(ResponseReceivedEvent event) {
            TestBlobOperationDescriptor.this.responseReceived(event);
        }
    }
}

