/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public class ITestAzureBlobFileSystemDelete
extends AbstractAbfsIntegrationTest {
    @Test
    public void testDeleteRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("/testFolder0"));
        fs.mkdirs(new Path("/testFolder1"));
        fs.mkdirs(new Path("/testFolder2"));
        this.touch(new Path("/testFolder1/testfile"));
        this.touch(new Path("/testFolder1/testfile2"));
        this.touch(new Path("/testFolder1/testfile3"));
        Path root = new Path("/");
        FileStatus[] ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((long)3L, (long)ls.length);
        fs.delete(root, true);
        ls = fs.listStatus(root);
        ITestAzureBlobFileSystemDelete.assertEquals((String)"listing size", (long)0L, (long)ls.length);
    }

    @Test
    public void testOpenFileAfterDelete() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = new Path("/testFile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.open(testfile));
    }

    @Test
    public void testEnsureFileIsDeleted() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testfile = new Path("testfile");
        this.touch(testfile);
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)testfile, (boolean)false);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)testfile);
    }

    @Test
    public void testDeleteDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path dir = new Path("testfile");
        fs.mkdirs(dir);
        fs.mkdirs(new Path("testfile/test1"));
        fs.mkdirs(new Path("testfile/test1/test2"));
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }

    @Test
    public void testDeleteFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path("/test/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemDelete.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        Path dir = new Path("/test");
        LambdaTestUtils.intercept(FileAlreadyExistsException.class, () -> fs.delete(dir, false));
        ContractTestUtils.assertDeleted((FileSystem)fs, (Path)dir, (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"deleted", (Path)dir);
    }
}

