/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;

public class AbfsUriQueryBuilder {
    private Map<String, String> parameters = new HashMap<String, String>();

    public void addQuery(String name, String value) {
        if (value != null && !value.isEmpty()) {
            this.parameters.put(name, value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (first) {
                sb.append("?");
                first = false;
            } else {
                sb.append("&");
            }
            try {
                sb.append(entry.getKey()).append("=").append(AbfsClient.urlEncode(entry.getValue()));
            }
            catch (AzureBlobFileSystemException ex) {
                throw new IllegalArgumentException("Query string param is not encode-able: " + entry.getKey() + "=" + entry.getValue());
            }
        }
        return sb.toString();
    }
}

