/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public class ITestAzureBlobFileSystemListStatus
extends AbstractAbfsIntegrationTest {
    private static final int TEST_FILES_NUMBER = 6000;

    @Test
    public void testListPath() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 6000; ++i) {
            final Path path = new Path("/test" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemListStatus.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        FileStatus[] files = fs.listStatus(new Path("/"));
        ITestAzureBlobFileSystemListStatus.assertEquals((long)6000L, (long)files.length);
    }

    @Test
    public void testListFileVsListDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path path = new Path("/testFile");
        try (FSDataOutputStream ignored = fs.create(path);){
            FileStatus[] testFiles = fs.listStatus(path);
            ITestAzureBlobFileSystemListStatus.assertEquals((String)"length of test files", (long)1L, (long)testFiles.length);
            FileStatus status = testFiles[0];
            this.assertIsFileReference(status);
        }
    }

    @Test
    public void testListFileVsListDir2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("/testFolder"));
        fs.mkdirs(new Path("/testFolder/testFolder2"));
        fs.mkdirs(new Path("/testFolder/testFolder2/testFolder3"));
        Path testFile0Path = new Path("/testFolder/testFolder2/testFolder3/testFile");
        ContractTestUtils.touch((FileSystem)fs, (Path)testFile0Path);
        FileStatus[] testFiles = fs.listStatus(testFile0Path);
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Wrong listing size of file " + testFile0Path), (long)1L, (long)testFiles.length);
        FileStatus file0 = testFiles[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Wrong path for " + file0), (Object)new Path(this.getTestUrl(), "/testFolder/testFolder2/testFolder3/testFile"), (Object)file0.getPath());
        this.assertIsFileReference(file0);
    }

    @Test(expected=FileNotFoundException.class)
    public void testListNonExistentDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.listStatus(new Path("/testFile/"));
    }

    @Test
    public void testListFiles() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testDir = new Path("/test");
        fs.mkdirs(testDir);
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
        ITestAzureBlobFileSystemListStatus.assertEquals((long)1L, (long)fileStatuses.length);
        fs.mkdirs(new Path("/test/sub"));
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)1L, (long)fileStatuses.length);
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)fileStatuses[0].getPath().getName());
        this.assertIsDirectoryReference(fileStatuses[0]);
        Path childF = fs.makeQualified(new Path("/test/f"));
        this.touch(childF);
        fileStatuses = fs.listStatus(testDir);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)2L, (long)fileStatuses.length);
        FileStatus childStatus = fileStatuses[0];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)childF, (Object)childStatus.getPath());
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"f", (Object)childStatus.getPath().getName());
        this.assertIsFileReference(childStatus);
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)childStatus.getLen());
        FileStatus status1 = fileStatuses[1];
        ITestAzureBlobFileSystemListStatus.assertEquals((Object)"sub", (Object)status1.getPath().getName());
        this.assertIsDirectoryReference(status1);
        LocatedFileStatus locatedChildStatus = (LocatedFileStatus)fs.listFiles(childF, false).next();
        this.assertIsFileReference((FileStatus)locatedChildStatus);
        fs.delete(testDir, true);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> (LocatedFileStatus)fs.listFiles(childF, false).next());
        ITestAzureBlobFileSystemListStatus.assertEquals((String)("Path mismatch of " + locatedChildStatus), (Object)childF, (Object)locatedChildStatus.getPath());
        ITestAzureBlobFileSystemListStatus.assertEquals((String)"locatedstatus.equals(status)", (Object)locatedChildStatus, (Object)childStatus);
        ITestAzureBlobFileSystemListStatus.assertEquals((String)"status.equals(locatedstatus)", (Object)childStatus, (Object)locatedChildStatus);
    }

    private void assertIsDirectoryReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertTrue((String)("Not a directory: " + status), (boolean)status.isDirectory());
        ITestAzureBlobFileSystemListStatus.assertFalse((String)("Not a directory: " + status), (boolean)status.isFile());
        ITestAzureBlobFileSystemListStatus.assertEquals((long)0L, (long)status.getLen());
    }

    private void assertIsFileReference(FileStatus status) {
        ITestAzureBlobFileSystemListStatus.assertFalse((String)("Not a file: " + status), (boolean)status.isDirectory());
        ITestAzureBlobFileSystemListStatus.assertTrue((String)("Not a file: " + status), (boolean)status.isFile());
    }
}

