/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystemStore;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsInputStream;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Assume;
import org.junit.Test;

public class ITestAzureBlobFileSystemOauth
extends AbstractAbfsIntegrationTest {
    private static final Path FILE_PATH = new Path("/testFile");
    private static final Path EXISTED_FILE_PATH = new Path("/existedFile");
    private static final Path EXISTED_FOLDER_PATH = new Path("/existedFolder");

    public ITestAzureBlobFileSystemOauth() throws Exception {
        Assume.assumeTrue((this.getAuthType() == AuthType.OAuth ? 1 : 0) != 0);
    }

    @Test
    public void testBlobDataContributor() throws Exception {
        String clientId = this.getConfiguration().get("fs.azure.account.oauth2.contributor.client.id");
        Assume.assumeTrue((String)"Contributor client id not provided", (clientId != null ? 1 : 0) != 0);
        String secret = this.getConfiguration().get("fs.azure.account.oauth2.contributor.client.secret");
        Assume.assumeTrue((String)"Contributor client secret not provided", (secret != null ? 1 : 0) != 0);
        this.prepareFiles();
        AzureBlobFileSystem fs = this.getBlobConributor();
        try (FSDataOutputStream stream = fs.create(FILE_PATH);){
            stream.write(0);
        }
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.exists(FILE_PATH));
        FileStatus fileStatus = fs.getFileStatus(FILE_PATH);
        ITestAzureBlobFileSystemOauth.assertEquals((long)1L, (long)fileStatus.getLen());
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.delete(FILE_PATH, true));
        ITestAzureBlobFileSystemOauth.assertFalse((boolean)fs.exists(FILE_PATH));
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.exists(EXISTED_FOLDER_PATH));
        fs.delete(EXISTED_FOLDER_PATH, true);
        ITestAzureBlobFileSystemOauth.assertFalse((boolean)fs.exists(EXISTED_FOLDER_PATH));
        try (FSDataInputStream stream = fs.open(EXISTED_FILE_PATH);){
            ITestAzureBlobFileSystemOauth.assertTrue((stream.read() != 0 ? 1 : 0) != 0);
        }
        ITestAzureBlobFileSystemOauth.assertEquals((long)0L, (long)fs.getFileStatus(EXISTED_FILE_PATH).getLen());
        stream = fs.append(EXISTED_FILE_PATH);
        var6_8 = null;
        try {
            stream.write(0);
        }
        catch (Throwable throwable) {
            var6_8 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var6_8 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var6_8.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
        ITestAzureBlobFileSystemOauth.assertEquals((long)1L, (long)fs.getFileStatus(EXISTED_FILE_PATH).getLen());
        fs.delete(EXISTED_FILE_PATH, true);
        ITestAzureBlobFileSystemOauth.assertFalse((boolean)fs.exists(EXISTED_FILE_PATH));
    }

    @Test
    public void testBlobDataReader() throws Exception {
        String clientId = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.id");
        Assume.assumeTrue((String)"Reader client id not provided", (clientId != null ? 1 : 0) != 0);
        String secret = this.getConfiguration().get("fs.azure.account.oauth2.reader.client.secret");
        Assume.assumeTrue((String)"Reader client secret not provided", (secret != null ? 1 : 0) != 0);
        this.prepareFiles();
        AzureBlobFileSystem fs = this.getBlobReader();
        AzureBlobFileSystemStore abfsStore = fs.getAbfsStore();
        Hashtable properties = abfsStore.getFilesystemProperties();
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.exists(EXISTED_FOLDER_PATH));
        try {
            abfsStore.delete(EXISTED_FOLDER_PATH, true);
        }
        catch (AbfsRestOperationException e) {
            ITestAzureBlobFileSystemOauth.assertEquals((Object)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH, (Object)e.getErrorCode());
        }
        try (AbfsInputStream inputStream = abfsStore.openFileForRead(EXISTED_FILE_PATH, null);){
            ITestAzureBlobFileSystemOauth.assertTrue((inputStream.read() != 0 ? 1 : 0) != 0);
        }
        try {
            abfsStore.openFileForWrite(EXISTED_FILE_PATH, true);
        }
        catch (AbfsRestOperationException e) {
            ITestAzureBlobFileSystemOauth.assertEquals((Object)AzureServiceErrorCode.AUTHORIZATION_PERMISSION_MISS_MATCH, (Object)e.getErrorCode());
        }
    }

    private void prepareFiles() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.create(EXISTED_FILE_PATH);
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.exists(EXISTED_FILE_PATH));
        fs.mkdirs(EXISTED_FOLDER_PATH);
        ITestAzureBlobFileSystemOauth.assertTrue((boolean)fs.exists(EXISTED_FOLDER_PATH));
    }

    private AzureBlobFileSystem getBlobConributor() throws Exception {
        AbfsConfiguration abfsConfig = this.getConfiguration();
        abfsConfig.set("fs.azure.account.oauth2.client.id." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.contributor.client.id"));
        abfsConfig.set("fs.azure.account.oauth2.client.secret." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.contributor.client.secret"));
        Configuration rawConfig = abfsConfig.getRawConfiguration();
        return this.getFileSystem(rawConfig);
    }

    private AzureBlobFileSystem getBlobReader() throws Exception {
        AbfsConfiguration abfsConfig = this.getConfiguration();
        abfsConfig.set("fs.azure.account.oauth2.client.id." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.reader.client.id"));
        abfsConfig.set("fs.azure.account.oauth2.client.secret." + this.getAccountName(), abfsConfig.get("fs.azure.account.oauth2.reader.client.secret"));
        Configuration rawConfig = abfsConfig.getRawConfiguration();
        return this.getFileSystem(rawConfig);
    }
}

