/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.SecureAzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Test;

public class ITestFileSystemInitialization
extends AbstractAbfsIntegrationTest {
    @Test
    public void ensureAzureBlobFileSystemIsInitialized() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        String scheme = this.getAuthType() == AuthType.SharedKey ? "abfs" : "abfss";
        ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI(scheme, filesystem + "@" + accountName, null, null, null));
        ITestFileSystemInitialization.assertNotNull((String)"working directory", (Object)fs.getWorkingDirectory());
    }

    @Test
    public void ensureSecureAzureBlobFileSystemIsInitialized() throws Exception {
        String accountName = this.getAccountName();
        String filesystem = this.getFileSystemName();
        URI defaultUri = new URI("abfss", filesystem + "@" + accountName, null, null, null);
        Configuration rawConfig = this.getRawConfiguration();
        rawConfig.set("fs.defaultFS", defaultUri.toString());
        try (SecureAzureBlobFileSystem fs = (SecureAzureBlobFileSystem)FileSystem.newInstance((Configuration)rawConfig);){
            ITestFileSystemInitialization.assertEquals((Object)fs.getUri(), (Object)new URI("abfss", filesystem + "@" + accountName, null, null, null));
            ITestFileSystemInitialization.assertNotNull((String)"working directory", (Object)fs.getWorkingDirectory());
        }
    }
}

