/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidAclOperationException;
import org.apache.hadoop.fs.permission.FsAction;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class AbfsAclHelper {
    private AbfsAclHelper() {
    }

    public static Map<String, String> deserializeAclSpec(String aclSpecString) {
        String[] aclArray;
        HashMap<String, String> aclEntries = new HashMap<String, String>();
        for (String acl : aclArray = aclSpecString.split(",")) {
            int idx = acl.lastIndexOf(":");
            aclEntries.put(acl.substring(0, idx), acl.substring(idx + 1));
        }
        return aclEntries;
    }

    public static String serializeAclSpec(Map<String, String> aclEntries) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
            sb.append(aclEntry.getKey() + ":" + aclEntry.getValue() + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String processAclString(String aclSpecString) {
        List<String> aclEntries = Arrays.asList(aclSpecString.split(","));
        StringBuilder sb = new StringBuilder();
        boolean containsMask = false;
        for (int i = aclEntries.size() - 1; i >= 0; --i) {
            String ace = aclEntries.get(i);
            if (ace.startsWith("other:") || ace.startsWith("user::")) continue;
            if (ace.startsWith("mask:")) {
                containsMask = true;
                continue;
            }
            if (ace.startsWith("group::") && !containsMask) continue;
            sb.insert(0, ace + ",");
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    public static void removeAclEntriesInternal(Map<String, String> aclEntries, Map<String, String> toRemoveEntries) throws AzureBlobFileSystemException {
        boolean accessAclTouched = false;
        boolean defaultAclTouched = false;
        HashSet<String> removeIndicationSet = new HashSet<String>();
        for (String entryKey : toRemoveEntries.keySet()) {
            boolean isDefaultAcl;
            if (!AbfsAclHelper.removeNamedAceAndUpdateSet(entryKey, isDefaultAcl = AbfsAclHelper.isDefaultAce(entryKey), removeIndicationSet, aclEntries)) continue;
            if (isDefaultAcl) {
                defaultAclTouched = true;
                continue;
            }
            accessAclTouched = true;
        }
        if (accessAclTouched) {
            if (removeIndicationSet.contains("mask:")) {
                aclEntries.remove("mask:");
            }
            AbfsAclHelper.recalculateMask(aclEntries, false);
        }
        if (defaultAclTouched) {
            if (removeIndicationSet.contains("default:mask:")) {
                aclEntries.remove("default:mask:");
            }
            if (removeIndicationSet.contains("default:user:")) {
                aclEntries.put("default:user:", aclEntries.get("user:"));
            }
            if (removeIndicationSet.contains("default:group:")) {
                aclEntries.put("default:group:", aclEntries.get("group:"));
            }
            if (removeIndicationSet.contains("default:other:")) {
                aclEntries.put("default:other:", aclEntries.get("other:"));
            }
            AbfsAclHelper.recalculateMask(aclEntries, true);
        }
    }

    private static boolean removeNamedAceAndUpdateSet(String entry, boolean isDefaultAcl, Set<String> removeIndicationSet, Map<String, String> aclEntries) throws AzureBlobFileSystemException {
        String tag;
        int startIndex = isDefaultAcl ? 1 : 0;
        String[] entryParts = entry.split(":");
        String string = tag = isDefaultAcl ? "default:" + entryParts[startIndex] + ":" : entryParts[startIndex] + ":";
        if ((entry.equals("user:") || entry.equals("group:") || entry.equals("other:")) && !AbfsAclHelper.isNamedAce(entry)) {
            throw new InvalidAclOperationException("Cannot remove user, group or other entry from access ACL.");
        }
        boolean touched = false;
        if (!AbfsAclHelper.isNamedAce(entry)) {
            removeIndicationSet.add(tag);
            touched = true;
        } else if (aclEntries.remove(entry) != null) {
            touched = true;
        }
        return touched;
    }

    private static void recalculateMask(Map<String, String> aclEntries, boolean isDefaultMask) {
        FsAction umask = FsAction.NONE;
        if (!AbfsAclHelper.isExtendAcl(aclEntries, isDefaultMask)) {
            return;
        }
        for (Map.Entry<String, String> aclEntry : aclEntries.entrySet()) {
            if (isDefaultMask) {
                if ((!AbfsAclHelper.isDefaultAce(aclEntry.getKey()) || !AbfsAclHelper.isNamedAce(aclEntry.getKey())) && !aclEntry.getKey().equals("default:group:")) continue;
                umask = umask.or(FsAction.getFsAction((String)aclEntry.getValue()));
                continue;
            }
            if ((AbfsAclHelper.isDefaultAce(aclEntry.getKey()) || !AbfsAclHelper.isNamedAce(aclEntry.getKey())) && !aclEntry.getKey().equals("group:")) continue;
            umask = umask.or(FsAction.getFsAction((String)aclEntry.getValue()));
        }
        aclEntries.put(isDefaultMask ? "default:mask:" : "mask:", umask.SYMBOL);
    }

    private static boolean isExtendAcl(Map<String, String> aclEntries, boolean checkDefault) {
        for (String entryKey : aclEntries.keySet()) {
            if (checkDefault && !entryKey.equals("default:user:") && !entryKey.equals("default:group:") && !entryKey.equals("default:other:") && AbfsAclHelper.isDefaultAce(entryKey)) {
                return true;
            }
            if (checkDefault || entryKey.equals("user:") || entryKey.equals("group:") || entryKey.equals("other:") || AbfsAclHelper.isDefaultAce(entryKey)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultAce(String entry) {
        return entry.startsWith("default:");
    }

    private static boolean isNamedAce(String entry) {
        return entry.charAt(entry.length() - 1) != ":".charAt(0);
    }
}

