/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.FileNotFoundException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestBase;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.ExceptionHandlingTestHelper;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.Test;

public class ITestFileSystemOperationExceptionHandling
extends AbstractWasbTestBase {
    private FSDataInputStream inputStream = null;
    private Path testPath;
    private Path testFolderPath;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testPath = this.path("testfile.dat");
        this.testFolderPath = this.path("testfolder");
    }

    private void setupInputStreamToTest(AzureBlobStorageTestAccount testAccount) throws Exception {
        NativeAzureFileSystem fs = testAccount.getFileSystem();
        Path base = this.methodPath();
        Path testFilePath1 = new Path(base, "test1.dat");
        Path testFilePath2 = new Path(base, "test2.dat");
        FSDataOutputStream outputStream = fs.create(testFilePath1);
        String testString = "This is a test string";
        outputStream.write(testString.getBytes());
        outputStream.close();
        this.inputStream = fs.open(testFilePath1);
        fs.rename(testFilePath1, testFilePath2);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.setupInputStreamToTest(testAccount);
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = ExceptionHandlingTestHelper.getPageBlobTestStorageAccount();
        this.setupInputStreamToTest(testAccount);
        this.inputStream.seek(5L);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadBlockBlobSeekScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.setupInputStreamToTest(testAccount);
        this.inputStream.seek(5L);
        this.inputStream.read();
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingledThreadBlockBlobReadScenario() throws Throwable {
        AzureBlobStorageTestAccount testAccount = this.createTestAccount();
        this.setupInputStreamToTest(testAccount);
        byte[] readBuffer = new byte[512];
        this.inputStream.read(readBuffer);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSetPermissionScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.fs.setOwner(this.testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.fs.setOwner(this.testPath, "testowner", "testgroup");
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobSetOwnerScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.fs.setPermission(this.testPath, new FsPermission(FsAction.EXECUTE, FsAction.READ, FsAction.READ));
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(this.createTestAccount(), this.testFolderPath);
        this.fs.delete(this.testFolderPath, true);
        this.fs.listStatus(this.testFolderPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobListStatusScenario() throws Throwable {
        ExceptionHandlingTestHelper.createTestFolder(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testFolderPath);
        this.fs.delete(this.testFolderPath, true);
        this.fs.listStatus(this.testFolderPath);
    }

    @Test
    public void testSingleThreadedBlockBlobRenameScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        Path dstPath = new Path("dstFile.dat");
        this.fs.delete(this.testPath, true);
        boolean renameResult = this.fs.rename(this.testPath, dstPath);
        ITestFileSystemOperationExceptionHandling.assertFalse((boolean)renameResult);
    }

    @Test
    public void testSingleThreadedPageBlobRenameScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        Path dstPath = new Path("dstFile.dat");
        this.fs.delete(this.testPath, true);
        boolean renameResult = this.fs.rename(this.testPath, dstPath);
        ITestFileSystemOperationExceptionHandling.assertFalse((boolean)renameResult);
    }

    @Test
    public void testSingleThreadedBlockBlobDeleteScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        boolean deleteResult = this.fs.delete(this.testPath, true);
        ITestFileSystemOperationExceptionHandling.assertFalse((boolean)deleteResult);
    }

    @Test
    public void testSingleThreadedPageBlobDeleteScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        boolean deleteResult = this.fs.delete(this.testPath, true);
        ITestFileSystemOperationExceptionHandling.assertFalse((boolean)deleteResult);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedBlockBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(this.createTestAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.inputStream = this.fs.open(this.testPath);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSingleThreadedPageBlobOpenScenario() throws Throwable {
        ExceptionHandlingTestHelper.createEmptyFile(ExceptionHandlingTestHelper.getPageBlobTestStorageAccount(), this.testPath);
        this.fs.delete(this.testPath, true);
        this.inputStream = this.fs.open(this.testPath);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        ContractTestUtils.rm((FileSystem)this.fs, (Path)this.testPath, (boolean)true, (boolean)true);
        super.tearDown();
    }

    @Override
    protected AzureBlobStorageTestAccount createTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create();
    }
}

