/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.FileNotFoundException;
import java.util.EnumSet;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Test;

public class ITestAzureBlobFileSystemCreate
extends AbstractAbfsIntegrationTest {
    private static final Path TEST_FILE_PATH = new Path("testfile");
    private static final Path TEST_FOLDER_PATH = new Path("testFolder");
    private static final String TEST_CHILD_FILE = "childFile";

    @Test
    public void testEnsureFileCreatedImmediately() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(TEST_FILE_PATH);){
            ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
        }
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)TEST_FILE_PATH);
    }

    @Test
    public void testCreateNonRecursive() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(TEST_FOLDER_PATH);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive1() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(TEST_FOLDER_PATH);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }

    @Test
    public void testCreateNonRecursive2() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFile = new Path(TEST_FOLDER_PATH, TEST_CHILD_FILE);
        try {
            fs.createNonRecursive(testFile, FsPermission.getDefault(), false, 1024, (short)1, 1024L, null);
            ITestAzureBlobFileSystemCreate.fail((String)"Should've thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        fs.mkdirs(TEST_FOLDER_PATH);
        fs.createNonRecursive(testFile, true, 1024, (short)1, 1024L, null).close();
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)testFile);
    }
}

