/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Ignore;
import org.junit.Test;

public class ITestAzureBlobFileSystemFileStatus
extends AbstractAbfsIntegrationTest {
    private static final String DEFAULT_FILE_PERMISSION_VALUE = "640";
    private static final String DEFAULT_DIR_PERMISSION_VALUE = "750";
    private static final String DEFAULT_UMASK_VALUE = "027";
    private static final Path TEST_FILE = new Path("testFile");
    private static final Path TEST_FOLDER = new Path("testDir");

    @Test
    public void testEnsureStatusWorksForRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        FileStatus[] rootls = fs.listStatus(root);
        ITestAzureBlobFileSystemFileStatus.assertEquals((String)"root listing", (long)0L, (long)rootls.length);
    }

    @Ignore(value="When running against live abfs with Oauth account, this test will fail. Need to check the tenant.")
    @Test
    public void testFileStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        this.touch(TEST_FILE);
        this.validateStatus(fs, TEST_FILE, false);
    }

    private FileStatus validateStatus(AzureBlobFileSystem fs, Path name, boolean isDir) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(name);
        String errorInStatus = "error in " + fileStatus + " from " + fs;
        if (this.getAuthType() != AuthType.OAuth && !fs.isSecureScheme()) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": owner"), (Object)fs.getOwnerUser(), (Object)fileStatus.getOwner());
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": group"), (Object)fs.getOwnerUserPrimaryGroup(), (Object)fileStatus.getGroup());
        } else if (isDir) {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_DIR_PERMISSION_VALUE), (Object)fileStatus.getPermission());
        } else {
            ITestAzureBlobFileSystemFileStatus.assertEquals((String)(errorInStatus + ": permission"), (Object)new FsPermission(DEFAULT_FILE_PERMISSION_VALUE), (Object)fileStatus.getPermission());
        }
        return fileStatus;
    }

    @Ignore(value="When running against live abfs with Oauth account, this test will fail. Need to check the tenant.")
    @Test
    public void testFolderStatusPermissionsAndOwnerAndGroup() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.getConf().set("fs.permissions.umask-mode", DEFAULT_UMASK_VALUE);
        fs.mkdirs(TEST_FOLDER);
        this.validateStatus(fs, TEST_FOLDER, true);
    }

    @Test
    public void testAbfsPathWithHost() throws IOException {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path pathWithHost1 = new Path("abfs://mycluster/abfs/file1.txt");
        Path pathwithouthost1 = new Path("/abfs/file1.txt");
        Path pathWithHost2 = new Path("abfs://mycluster/abfs/file2.txt");
        Path pathwithouthost2 = new Path("/abfs/file2.txt");
        fs.create(pathWithHost1);
        ITestAzureBlobFileSystemFileStatus.assertTrue((boolean)fs.exists(pathwithouthost1));
        fs.create(pathwithouthost2);
        ITestAzureBlobFileSystemFileStatus.assertTrue((boolean)fs.exists(pathWithHost2));
        FileStatus fileStatus1 = fs.getFileStatus(pathWithHost1);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathwithouthost1.getName(), (Object)fileStatus1.getPath().getName());
        FileStatus fileStatus2 = fs.getFileStatus(pathwithouthost2);
        ITestAzureBlobFileSystemFileStatus.assertEquals((Object)pathWithHost2.getName(), (Object)fileStatus2.getPath().getName());
    }
}

