/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.extensions;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.extensions.AbfsAuthorizationException;
import org.apache.hadoop.fs.azurebfs.extensions.AbfsAuthorizer;
import org.apache.hadoop.fs.permission.FsAction;

public class MockAbfsAuthorizer
implements AbfsAuthorizer {
    public static final String TEST_READ_ONLY_FILE_0 = "readOnlyFile0";
    public static final String TEST_READ_ONLY_FILE_1 = "readOnlyFile1";
    public static final String TEST_READ_ONLY_FOLDER = "readOnlyFolder";
    public static final String TEST_WRITE_ONLY_FILE_0 = "writeOnlyFile0";
    public static final String TEST_WRITE_ONLY_FILE_1 = "writeOnlyFile1";
    public static final String TEST_WRITE_ONLY_FOLDER = "writeOnlyFolder";
    public static final String TEST_READ_WRITE_FILE_0 = "readWriteFile0";
    public static final String TEST_READ_WRITE_FILE_1 = "readWriteFile1";
    public static final String TEST_WRITE_THEN_READ_ONLY = "writeThenReadOnlyFile";
    private Configuration conf;
    private Set<Path> readOnlyPaths = new HashSet<Path>();
    private Set<Path> writeOnlyPaths = new HashSet<Path>();
    private Set<Path> readWritePaths = new HashSet<Path>();
    private int writeThenReadOnly = 0;

    public MockAbfsAuthorizer(Configuration conf) {
        this.conf = conf;
    }

    public void init() throws AbfsAuthorizationException, IOException {
        this.readOnlyPaths.add(new Path(TEST_READ_ONLY_FILE_0));
        this.readOnlyPaths.add(new Path(TEST_READ_ONLY_FILE_1));
        this.readOnlyPaths.add(new Path(TEST_READ_ONLY_FOLDER));
        this.writeOnlyPaths.add(new Path(TEST_WRITE_ONLY_FILE_0));
        this.writeOnlyPaths.add(new Path(TEST_WRITE_ONLY_FILE_1));
        this.writeOnlyPaths.add(new Path(TEST_WRITE_ONLY_FOLDER));
        this.readWritePaths.add(new Path(TEST_READ_WRITE_FILE_0));
        this.readWritePaths.add(new Path(TEST_READ_WRITE_FILE_1));
    }

    public boolean isAuthorized(FsAction action, Path ... absolutePaths) throws AbfsAuthorizationException, IOException {
        HashSet<Path> paths = new HashSet<Path>();
        for (Path path : absolutePaths) {
            paths.add(new Path(path.getName()));
        }
        if (action.equals((Object)FsAction.READ) && Stream.concat(this.readOnlyPaths.stream(), this.readWritePaths.stream()).collect(Collectors.toSet()).containsAll(paths)) {
            return true;
        }
        if (action.equals((Object)FsAction.READ) && paths.contains(new Path(TEST_WRITE_THEN_READ_ONLY)) && this.writeThenReadOnly == 1) {
            return true;
        }
        if (action.equals((Object)FsAction.WRITE) && Stream.concat(this.writeOnlyPaths.stream(), this.readWritePaths.stream()).collect(Collectors.toSet()).containsAll(paths)) {
            return true;
        }
        if (action.equals((Object)FsAction.WRITE) && paths.contains(new Path(TEST_WRITE_THEN_READ_ONLY)) && this.writeThenReadOnly == 0) {
            this.writeThenReadOnly = 1;
            return true;
        }
        return action.equals((Object)FsAction.READ_WRITE) && this.readWritePaths.containsAll(paths);
    }
}

