/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingAnalyzer;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestAbfsClientThrottlingAnalyzer {
    private static final int ANALYSIS_PERIOD = 1000;
    private static final int ANALYSIS_PERIOD_PLUS_10_PERCENT = 1100;
    private static final long MEGABYTE = 0x100000L;
    private static final int MAX_ACCEPTABLE_PERCENT_DIFFERENCE = 20;

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void fuzzyValidate(long expected, long actual, double percentage) {
        double lowerBound = Math.max((double)expected - percentage / 100.0 * (double)expected, 0.0);
        double upperBound = (double)expected + percentage / 100.0 * (double)expected;
        Assert.assertTrue((String)String.format("The actual value %1$d is not within the expected range: [%2$.2f, %3$.2f].", actual, lowerBound, upperBound), ((double)actual >= lowerBound && (double)actual <= upperBound ? 1 : 0) != 0);
    }

    private void validate(long expected, long actual) {
        Assert.assertEquals((String)String.format("The actual value %1$d is not the expected value %2$d.", actual, expected), (long)expected, (long)actual);
    }

    private void validateLessThanOrEqual(long maxExpected, long actual) {
        Assert.assertTrue((String)String.format("The actual value %1$d is not less than or equal to the maximum expected value %2$d.", actual, maxExpected), (actual < maxExpected ? 1 : 0) != 0);
    }

    @Test
    public void testNoMetricUpdatesThenNoWaiting() {
        AbfsClientThrottlingAnalyzer analyzer = new AbfsClientThrottlingAnalyzer("test", 1000);
        this.validate(0L, analyzer.getSleepDuration());
        this.sleep(1100L);
        this.validate(0L, analyzer.getSleepDuration());
    }

    @Test
    public void testOnlySuccessThenNoWaiting() {
        AbfsClientThrottlingAnalyzer analyzer = new AbfsClientThrottlingAnalyzer("test", 1000);
        analyzer.addBytesTransferred(0x800000L, false);
        this.validate(0L, analyzer.getSleepDuration());
        this.sleep(1100L);
        this.validate(0L, analyzer.getSleepDuration());
    }

    @Test
    public void testOnlyErrorsAndWaiting() {
        AbfsClientThrottlingAnalyzer analyzer = new AbfsClientThrottlingAnalyzer("test", 1000);
        this.validate(0L, analyzer.getSleepDuration());
        analyzer.addBytesTransferred(0x400000L, true);
        this.sleep(1100L);
        int expectedSleepDuration1 = 1100;
        this.validateLessThanOrEqual(1100L, analyzer.getSleepDuration());
        this.sleep(10000L);
        int expectedSleepDuration2 = 900;
        this.validateLessThanOrEqual(900L, analyzer.getSleepDuration());
    }

    @Test
    public void testSuccessAndErrorsAndWaiting() {
        AbfsClientThrottlingAnalyzer analyzer = new AbfsClientThrottlingAnalyzer("test", 1000);
        this.validate(0L, analyzer.getSleepDuration());
        analyzer.addBytesTransferred(0x800000L, false);
        analyzer.addBytesTransferred(0x200000L, true);
        this.sleep(1100L);
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        analyzer.suspendIfNecessary();
        int expectedElapsedTime = 126;
        this.fuzzyValidate(126L, timer.elapsedTimeMs(), 20.0);
        this.sleep(10000L);
        int expectedSleepDuration = 110;
        this.validateLessThanOrEqual(110L, analyzer.getSleepDuration());
    }

    @Test
    public void testManySuccessAndErrorsAndWaiting() {
        AbfsClientThrottlingAnalyzer analyzer = new AbfsClientThrottlingAnalyzer("test", 1000);
        this.validate(0L, analyzer.getSleepDuration());
        int numberOfRequests = 20;
        for (int i = 0; i < 20; ++i) {
            analyzer.addBytesTransferred(0x800000L, false);
            analyzer.addBytesTransferred(0x200000L, true);
        }
        this.sleep(1100L);
        ContractTestUtils.NanoTimer timer = new ContractTestUtils.NanoTimer();
        analyzer.suspendIfNecessary();
        this.fuzzyValidate(7L, timer.elapsedTimeMs(), 20.0);
        this.sleep(10000L);
        this.validate(0L, analyzer.getSleepDuration());
    }
}

