/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.net.URL;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.utils.SSLSocketFactoryEx;
import org.junit.Assert;
import org.junit.Test;

public final class TestAbfsClient {
    private final String accountName = "bogusAccountName";

    private void validateUserAgent(String expectedPattern, URL baseUrl, AbfsConfiguration config, boolean includeSSLProvider) {
        AbfsClient client = new AbfsClient(baseUrl, null, config, null, null);
        String sslProviderName = null;
        if (includeSSLProvider) {
            sslProviderName = SSLSocketFactoryEx.getDefaultFactory().getProviderName();
        }
        String userAgent = client.initializeUserAgent(config, sslProviderName);
        Pattern pattern = Pattern.compile(expectedPattern);
        Assert.assertTrue((boolean)pattern.matcher(userAgent).matches());
    }

    @Test
    public void verifyUnknownUserAgent() throws Exception {
        String expectedUserAgentPattern = "Azure Blob FS\\/1.0 \\(JavaJRE ([^\\)]+)\\)";
        Configuration configuration = new Configuration();
        configuration.unset("fs.azure.user.agent.prefix");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "bogusAccountName");
        this.validateUserAgent(expectedUserAgentPattern, new URL("http://azure.com"), abfsConfiguration, false);
    }

    @Test
    public void verifyUserAgent() throws Exception {
        String expectedUserAgentPattern = "Azure Blob FS\\/1.0 \\(JavaJRE ([^\\)]+)\\) Partner Service";
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.user.agent.prefix", "Partner Service");
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "bogusAccountName");
        this.validateUserAgent(expectedUserAgentPattern, new URL("http://azure.com"), abfsConfiguration, false);
    }

    @Test
    public void verifyUserAgentWithSSLProvider() throws Exception {
        String expectedUserAgentPattern = "Azure Blob FS\\/1.0 \\(JavaJRE ([^\\)]+) SunJSSE-1.8\\) Partner Service";
        Configuration configuration = new Configuration();
        configuration.set("fs.azure.user.agent.prefix", "Partner Service");
        configuration.set("fs.azure.ssl.channel.mode", SSLSocketFactoryEx.SSLChannelMode.Default_JSSE.name());
        AbfsConfiguration abfsConfiguration = new AbfsConfiguration(configuration, "bogusAccountName");
        this.validateUserAgent(expectedUserAgentPattern, new URL("https://azure.com"), abfsConfiguration, true);
    }
}

