/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import org.apache.hadoop.fs.azurebfs.utils.UriUtils;
import org.junit.Assert;
import org.junit.Test;

public final class TestUriUtils {
    @Test
    public void testIfUriContainsAbfs() throws Exception {
        Assert.assertTrue((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.core.windows.net"));
        Assert.assertTrue((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.preprod.core.windows.net"));
        Assert.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.cores.windows.net"));
        Assert.assertFalse((boolean)UriUtils.containsAbfsUrl((String)""));
        Assert.assertFalse((boolean)UriUtils.containsAbfsUrl(null));
        Assert.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"abfs.dfs.cores.windows.net"));
        Assert.assertFalse((boolean)UriUtils.containsAbfsUrl((String)"xhdfs.blob.core.windows.net"));
    }

    @Test
    public void testExtractRawAccountName() throws Exception {
        Assert.assertEquals((Object)"abfs", (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.core.windows.net"));
        Assert.assertEquals((Object)"abfs", (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.preprod.core.windows.net"));
        Assert.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.cores.windows.net"));
        Assert.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)""));
        Assert.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName(null));
        Assert.assertEquals(null, (Object)UriUtils.extractAccountNameFromHostName((String)"abfs.dfs.cores.windows.net"));
    }
}

