/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ITestAzureBlobFileSystemRename
extends AbstractAbfsIntegrationTest {
    @Test
    public void testEnsureFileIsRenamed() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path src = this.path("testEnsureFileIsRenamed-src");
        this.touch(src);
        Path dest = this.path("testEnsureFileIsRenamed-dest");
        fs.delete(dest, true);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)src, (Path)dest, (boolean)true);
        ContractTestUtils.assertIsFile((FileSystem)fs, (Path)dest);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"expected renamed", (Path)src);
    }

    @Test
    public void testRenameFileUnderDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path sourceDir = new Path("/testSrc");
        ContractTestUtils.assertMkdirs((FileSystem)fs, (Path)sourceDir);
        String filename = "file1";
        Path file1 = new Path(sourceDir, filename);
        this.touch(file1);
        Path destDir = new Path("/testDst");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)sourceDir, (Path)destDir, (boolean)true);
        FileStatus[] fileStatus = fs.listStatus(destDir);
        ITestAzureBlobFileSystemRename.assertNotNull((String)"Null file status", (Object)fileStatus);
        FileStatus status = fileStatus[0];
        ITestAzureBlobFileSystemRename.assertEquals((String)("Wrong filename in " + status), (Object)filename, (Object)status.getPath().getName());
    }

    @Test
    public void testRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("testDir"));
        Path test1 = new Path("testDir/test1");
        fs.mkdirs(test1);
        fs.mkdirs(new Path("testDir/test1/test2"));
        fs.mkdirs(new Path("testDir/test1/test2/test3"));
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)test1, (Path)new Path("testDir/test10"), (boolean)true);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)test1);
    }

    @Test
    public void testRenameFirstLevelDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ArrayList<Future<Void>> tasks = new ArrayList<Future<Void>>();
        ExecutorService es = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; ++i) {
            final Path path = new Path("/test/" + i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ITestAzureBlobFileSystemRename.this.touch(path);
                    return null;
                }
            };
            tasks.add(es.submit(callable));
        }
        for (Future future : tasks) {
            future.get();
        }
        es.shutdownNow();
        Path source = new Path("/test");
        Path path = new Path("/renamedDir");
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)source, (Path)path, (boolean)true);
        FileStatus[] files = fs.listStatus(path);
        ITestAzureBlobFileSystemRename.assertEquals((String)"Wrong number of files in listing", (long)1000L, (long)files.length);
        ContractTestUtils.assertPathDoesNotExist((FileSystem)fs, (String)"rename source dir", (Path)source);
    }

    @Test
    public void testRenameRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path("/"), (Path)new Path("/testRenameRoot"), (boolean)false);
        ContractTestUtils.assertRenameOutcome((FileSystem)fs, (Path)new Path(fs.getUri().toString() + "/"), (Path)new Path(fs.getUri().toString() + "/s"), (boolean)false);
    }

    @Test
    public void testPosixRenameDirectory() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path("testDir2/test1/test2/test3"));
        fs.mkdirs(new Path("testDir2/test4"));
        Assert.assertTrue((boolean)fs.rename(new Path("testDir2/test1/test2/test3"), new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test1/test2")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4")));
        ITestAzureBlobFileSystemRename.assertTrue((boolean)fs.exists(new Path("testDir2/test4/test3")));
        ITestAzureBlobFileSystemRename.assertFalse((boolean)fs.exists(new Path("testDir2/test1/test2/test3")));
    }
}

