/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.microsoft.azure.storage.blob.BlobOutputStream;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.FileNotFoundException;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AbstractWasbTestWithTimeout;
import org.apache.hadoop.fs.azure.AzureBlobStorageTestAccount;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azure.NativeAzureFileSystem;
import org.apache.hadoop.fs.azure.integration.AzureTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ITestContainerChecks
extends AbstractWasbTestWithTimeout {
    private AzureBlobStorageTestAccount testAccount;
    private boolean runningInSASMode = false;

    @After
    public void tearDown() throws Exception {
        this.testAccount = AzureTestUtils.cleanup(this.testAccount);
    }

    @Before
    public void setMode() {
        this.runningInSASMode = AzureBlobStorageTestAccount.createTestConfiguration().getBoolean("fs.azure.secure.mode", false);
    }

    @Test
    public void testContainerExistAfterDoesNotExist() throws Exception {
        this.testAccount = this.blobStorageTestAccount();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        ITestContainerChecks.assertFalse((boolean)container.exists());
        try {
            fs.listStatus(new Path("/"));
            ITestContainerChecks.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            ITestContainerChecks.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("is not found"));
        }
        ITestContainerChecks.assertFalse((boolean)container.exists());
        container.create();
        CloudBlockBlob blob = this.testAccount.getBlobReference("foo");
        BlobOutputStream outputStream = blob.openOutputStream();
        outputStream.write(new byte[10]);
        outputStream.close();
        ITestContainerChecks.assertTrue((boolean)fs.exists(new Path("/foo")));
        ITestContainerChecks.assertTrue((boolean)container.exists());
    }

    protected AzureBlobStorageTestAccount blobStorageTestAccount() throws Exception {
        return AzureBlobStorageTestAccount.create("", EnumSet.noneOf(AzureBlobStorageTestAccount.CreateOptions.class));
    }

    @Test
    public void testContainerCreateAfterDoesNotExist() throws Exception {
        this.testAccount = this.blobStorageTestAccount();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        ITestContainerChecks.assertFalse((boolean)container.exists());
        try {
            ITestContainerChecks.assertNull((Object)fs.listStatus(new Path("/")));
            ITestContainerChecks.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            ITestContainerChecks.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("is not found"));
        }
        ITestContainerChecks.assertFalse((boolean)container.exists());
        container.create();
        ITestContainerChecks.assertTrue((boolean)fs.createNewFile(new Path("/foo")));
        ITestContainerChecks.assertTrue((boolean)container.exists());
    }

    @Test
    public void testContainerCreateOnWrite() throws Exception {
        this.testAccount = this.blobStorageTestAccount();
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        ITestContainerChecks.assertFalse((boolean)container.exists());
        try {
            fs.listStatus(new Path("/"));
            ITestContainerChecks.assertTrue((String)"Should've thrown.", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            ITestContainerChecks.assertTrue((String)("Unexpected exception: " + ex), (boolean)ex.getMessage().contains("is not found"));
        }
        ITestContainerChecks.assertFalse((boolean)container.exists());
        Path foo = new Path("/testContainerCreateOnWrite-foo");
        Path bar = new Path("/testContainerCreateOnWrite-bar");
        LambdaTestUtils.intercept(FileNotFoundException.class, (Callable)new Callable<String>((FileSystem)fs, foo){
            final /* synthetic */ FileSystem val$fs;
            final /* synthetic */ Path val$foo;
            {
                this.val$fs = fileSystem;
                this.val$foo = path;
            }

            @Override
            public String call() throws Exception {
                this.val$fs.open(this.val$foo).close();
                return "Stream to " + this.val$foo;
            }
        });
        ITestContainerChecks.assertFalse((boolean)container.exists());
        ITestContainerChecks.assertFalse((boolean)fs.rename(foo, bar));
        ITestContainerChecks.assertFalse((boolean)container.exists());
        container.create();
        ITestContainerChecks.assertTrue((boolean)fs.createNewFile(foo));
        ITestContainerChecks.assertTrue((boolean)container.exists());
    }

    @Test
    public void testContainerChecksWithSas() throws Exception {
        Assume.assumeFalse((boolean)this.runningInSASMode);
        this.testAccount = AzureBlobStorageTestAccount.create("", EnumSet.of(AzureBlobStorageTestAccount.CreateOptions.UseSas));
        Assume.assumeNotNull((Object[])new Object[]{this.testAccount});
        CloudBlobContainer container = this.testAccount.getRealContainer();
        NativeAzureFileSystem fs = this.testAccount.getFileSystem();
        ITestContainerChecks.assertFalse((boolean)container.exists());
        try {
            fs.createNewFile(new Path("/testContainerChecksWithSas-foo"));
            ITestContainerChecks.assertFalse((String)"Should've thrown.", (boolean)true);
        }
        catch (AzureException azureException) {
            // empty catch block
        }
        ITestContainerChecks.assertFalse((boolean)container.exists());
    }
}

