/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.junit.Test;

public class ITestAzureBlobFileSystemE2E
extends AbstractAbfsIntegrationTest {
    private static final int TEST_BYTE = 100;
    private static final int TEST_OFFSET = 100;
    private static final int TEST_DEFAULT_BUFFER_SIZE = 0x400000;
    private static final int TEST_DEFAULT_READ_BUFFER_SIZE = 1023900;

    public ITestAzureBlobFileSystemE2E() throws Exception {
        AbfsConfiguration configuration = this.getConfiguration();
        configuration.set("fs.azure.readaheadqueue.depth", "0");
    }

    @Test
    public void testWriteOneByteToFile() throws Exception {
        Path testFilePath = new Path(this.methodName.getMethodName());
        this.testWriteOneByteToFile(testFilePath);
    }

    @Test
    public void testReadWriteBytesToFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = new Path(this.methodName.getMethodName());
        this.testWriteOneByteToFile(testFilePath);
        try (FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);){
            ITestAzureBlobFileSystemE2E.assertEquals((long)100L, (long)inputStream.read());
        }
    }

    @Test(expected=IOException.class)
    public void testOOBWrites() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        int readBufferSize = fs.getAbfsStore().getAbfsConfiguration().getReadBufferSize();
        byte[] bytesToRead = new byte[readBufferSize];
        byte[] b = new byte[2 * readBufferSize];
        new Random().nextBytes(b);
        Path testFilePath = new Path(this.methodName.getMethodName());
        try (FSDataOutputStream writeStream = fs.create(testFilePath);){
            writeStream.write(b);
            writeStream.flush();
        }
        var7_7 = null;
        try (FSDataInputStream readStream = fs.open(testFilePath);){
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
            try (FSDataOutputStream writeStream = fs.create(testFilePath);){
                writeStream.write(b);
                writeStream.flush();
            }
            ITestAzureBlobFileSystemE2E.assertEquals((long)readBufferSize, (long)readStream.read(bytesToRead, 0, readBufferSize));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testWriteWithBufferOffset() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = new Path(this.methodName.getMethodName());
        byte[] b = new byte[1024000];
        new Random().nextBytes(b);
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            stream.write(b, 100, b.length - 100);
        }
        byte[] r = new byte[1023900];
        FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);
        int result = inputStream.read(r);
        ITestAzureBlobFileSystemE2E.assertNotEquals((long)-1L, (long)result);
        ITestAzureBlobFileSystemE2E.assertArrayEquals((byte[])r, (byte[])Arrays.copyOfRange(b, 100, b.length));
        inputStream.close();
    }

    @Test
    public void testReadWriteHeavyBytesToFileWithSmallerChunks() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Path testFilePath = new Path(this.methodName.getMethodName());
        byte[] writeBuffer = new byte[5120000];
        new Random().nextBytes(writeBuffer);
        this.write(testFilePath, writeBuffer);
        byte[] readBuffer = new byte[5120000];
        FSDataInputStream inputStream = fs.open(testFilePath, 0x400000);
        int offset = 0;
        while (inputStream.read(readBuffer, offset, 100) > 0) {
            offset += 100;
        }
        ITestAzureBlobFileSystemE2E.assertArrayEquals((byte[])readBuffer, (byte[])writeBuffer);
        inputStream.close();
    }

    private void testWriteOneByteToFile(Path testFilePath) throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        try (FSDataOutputStream stream = fs.create(testFilePath);){
            stream.write(100);
        }
        FileStatus fileStatus = fs.getFileStatus(testFilePath);
        ITestAzureBlobFileSystemE2E.assertEquals((long)1L, (long)fileStatus.getLen());
    }
}

