/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.apache.hadoop.fs.azurebfs.utils.AclTestHelpers;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class ITestAzureBlobFilesystemAcl
extends AbstractAbfsIntegrationTest {
    private static final FsAction ALL = FsAction.ALL;
    private static final FsAction NONE = FsAction.NONE;
    private static final FsAction READ = FsAction.READ;
    private static final FsAction READ_EXECUTE = FsAction.READ_EXECUTE;
    private static final FsAction READ_WRITE = FsAction.READ_WRITE;
    private static final short RW = 384;
    private static final short RWX = 448;
    private static final short RWX_R = 480;
    private static final short RWX_RW = 496;
    private static final short RWX_RWX = 504;
    private static final short RWX_RX = 488;
    private static final short RWX_RX_RX = 493;
    private static final short RW_R = 416;
    private static final short RW_RW = 432;
    private static final short RW_RWX = 440;
    private static final short RW_R_R = 420;
    private static final short STICKY_RWX_RWX = 1016;
    private static Path testRoot = new Path("/test");
    private Path path;

    @Test
    public void testModifyAclEntries() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.mkdirs(this.path, FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testModifyAclEntriesOnlyAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testModifyAclEntriesOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testModifyAclEntriesMinimal() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_WRITE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)432);
    }

    @Test
    public void testModifyAclEntriesMinimalDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testModifyAclEntriesCustomMask() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, NONE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)384);
    }

    @Test
    public void testModifyAclEntriesStickyBit() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)1000);
    }

    @Test(expected=FileNotFoundException.class)
    public void testModifyAclEntriesPathNotFound() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
    }

    @Test(expected=Exception.class)
    public void testModifyAclEntriesDefaultOnFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntries() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveAclEntriesOnlyAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_WRITE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)496);
    }

    @Test
    public void testRemoveAclEntriesOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", READ_EXECUTE)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bar", READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveAclEntriesMinimal() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)496));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK)});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)496);
    }

    @Test
    public void testRemoveAclEntriesMinimalDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK)});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveAclEntriesStickyBit() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo"), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo")});
        fs.removeAclEntries(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)1000);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclEntriesPathNotFound() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo")});
        fs.removeAclEntries(this.path, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAcl() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeDefaultAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)504);
    }

    @Test
    public void testRemoveDefaultAclOnlyAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeDefaultAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)504);
    }

    @Test
    public void testRemoveDefaultAclOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeDefaultAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveDefaultAclMinimal() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        fs.removeDefaultAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveDefaultAclStickyBit() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeDefaultAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)1016);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveDefaultAclPathNotFound() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.removeDefaultAcl(this.path);
    }

    @Test
    public void testRemoveAcl() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testRemoveAclMinimalAcl() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        fs.removeAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)416);
    }

    @Test
    public void testRemoveAclStickyBit() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)1000);
    }

    @Test
    public void testRemoveAclOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.removeAcl(this.path);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test(expected=FileNotFoundException.class)
    public void testRemoveAclPathNotFound() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.removeAcl(this.path);
    }

    @Test
    public void testSetAcl() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)504);
    }

    @Test
    public void testSetAclOnlyAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)416);
    }

    @Test
    public void testSetAclOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testSetAclMinimal() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)420));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)416);
    }

    @Test
    public void testSetAclMinimalDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)488);
    }

    @Test
    public void testSetAclCustomMask() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)440);
    }

    @Test
    public void testSetAclStickyBit() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)1000));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)1016);
    }

    @Test(expected=FileNotFoundException.class)
    public void testSetAclPathNotFound() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
    }

    @Test(expected=Exception.class)
    public void testSetAclDefaultOnFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
    }

    @Test
    public void testSetPermission() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.setPermission(this.path, FsPermission.createImmutable((short)448));
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)448);
    }

    @Test
    public void testSetPermissionOnlyAccess() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        fs.create(this.path).close();
        fs.setPermission(this.path, FsPermission.createImmutable((short)416));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.setPermission(this.path, FsPermission.createImmutable((short)384));
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)384);
    }

    @Test
    public void testSetPermissionOnlyDefault() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        fs.setPermission(this.path, FsPermission.createImmutable((short)448));
        AclStatus s = fs.getAclStatus(this.path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, (short)448);
    }

    @Test
    public void testDefaultAclNewFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        Path filePath = new Path(this.path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, filePath, (short)416);
    }

    @Test
    @Ignore
    public void testOnlyAccessAclNewFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        Path filePath = new Path(this.path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, filePath, (short)420);
    }

    @Test
    @Ignore
    public void testDefaultMinimalAclNewFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        Path filePath = new Path(this.path, "file1");
        fs.create(filePath).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, filePath, (short)416);
    }

    @Test
    public void testDefaultAclNewDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        Path dirPath = new Path(this.path, "dir1");
        fs.mkdirs(dirPath);
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, dirPath, (short)504);
    }

    @Test
    @Ignore
    public void testOnlyAccessAclNewDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL)});
        fs.modifyAclEntries(this.path, (List)aclSpec);
        Path dirPath = new Path(this.path, "dir1");
        fs.mkdirs(dirPath);
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        this.assertPermission((FileSystem)fs, dirPath, (short)493);
    }

    @Test
    @Ignore
    public void testDefaultMinimalAclNewDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)});
        fs.setAcl(this.path, (List)aclSpec);
        Path dirPath = new Path(this.path, "dir1");
        fs.mkdirs(dirPath);
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, NONE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, dirPath, (short)488);
    }

    @Test
    public void testDefaultAclNewFileWithMode() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        Path filePath = new Path(this.path, "file1");
        int bufferSize = 0x400000;
        fs.create(filePath, new FsPermission(480), false, bufferSize, fs.getDefaultReplication(filePath), fs.getDefaultBlockSize(this.path), null).close();
        AclStatus s = fs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, filePath, (short)480);
    }

    @Test
    public void testDefaultAclNewDirWithMode() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        FileSystem.mkdirs((FileSystem)fs, (Path)this.path, (FsPermission)FsPermission.createImmutable((short)493));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(this.path, (List)aclSpec);
        Path dirPath = new Path(this.path, "dir1");
        fs.mkdirs(dirPath, new FsPermission(480));
        AclStatus s = fs.getAclStatus(dirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, READ_EXECUTE)}, (Object[])returned);
        this.assertPermission((FileSystem)fs, dirPath, (short)480);
    }

    @Test
    public void testDefaultAclRenamedFile() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        Path dirPath = new Path(this.path, "dir");
        FileSystem.mkdirs((FileSystem)fs, (Path)dirPath, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(dirPath, (List)aclSpec);
        Path filePath = new Path(this.path, "file1");
        fs.create(filePath).close();
        fs.setPermission(filePath, FsPermission.createImmutable((short)416));
        Path renamedFilePath = new Path(dirPath, "file1");
        fs.rename(filePath, renamedFilePath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = fs.getAclStatus(renamedFilePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission((FileSystem)fs, renamedFilePath, (short)416);
    }

    @Test
    public void testDefaultAclRenamedDir() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        this.path = new Path(testRoot, UUID.randomUUID().toString());
        Path dirPath = new Path(this.path, "dir");
        FileSystem.mkdirs((FileSystem)fs, (Path)dirPath, (FsPermission)FsPermission.createImmutable((short)488));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL)});
        fs.setAcl(dirPath, (List)aclSpec);
        Path subdirPath = new Path(this.path, "subdir");
        FileSystem.mkdirs((FileSystem)fs, (Path)subdirPath, (FsPermission)FsPermission.createImmutable((short)488));
        Path renamedSubdirPath = new Path(dirPath, "subdir");
        fs.rename(subdirPath, renamedSubdirPath);
        Object[] expected = new AclEntry[]{};
        AclStatus s = fs.getAclStatus(renamedSubdirPath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        ITestAzureBlobFilesystemAcl.assertArrayEquals((Object[])expected, (Object[])returned);
        this.assertPermission((FileSystem)fs, renamedSubdirPath, (short)488);
    }

    @Test
    public void testEnsureAclOperationWorksForRoot() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((boolean)fs.getIsNamespaceEnabled());
        Path rootPath = new Path("/");
        ArrayList aclSpec1 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", ALL)});
        fs.setAcl(rootPath, (List)aclSpec1);
        fs.getAclStatus(rootPath);
        fs.setOwner(rootPath, "", "testgroup");
        fs.setPermission(rootPath, new FsPermission("777"));
        ArrayList aclSpec2 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", ALL)});
        fs.modifyAclEntries(rootPath, (List)aclSpec2);
        fs.removeAclEntries(rootPath, (List)aclSpec2);
        fs.removeDefaultAcl(rootPath);
        fs.removeAcl(rootPath);
    }

    @Test
    public void testSetOwnerForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        ITestAzureBlobFilesystemAcl.assertTrue((boolean)fs.exists(filePath));
        FileStatus oldFileStatus = fs.getFileStatus(filePath);
        fs.setOwner(filePath, "Alice", "testGroup");
        FileStatus newFileStatus = fs.getFileStatus(filePath);
        ITestAzureBlobFilesystemAcl.assertEquals((Object)oldFileStatus.getOwner(), (Object)newFileStatus.getOwner());
        ITestAzureBlobFilesystemAcl.assertEquals((Object)oldFileStatus.getGroup(), (Object)newFileStatus.getGroup());
    }

    @Test
    public void testSetPermissionForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        ITestAzureBlobFilesystemAcl.assertTrue((boolean)fs.exists(filePath));
        FsPermission oldPermission = fs.getFileStatus(filePath).getPermission();
        FsPermission newPermission = new FsPermission("557");
        ITestAzureBlobFilesystemAcl.assertNotEquals((Object)oldPermission, (Object)newPermission);
        fs.setPermission(filePath, newPermission);
        FsPermission updatedPermission = fs.getFileStatus(filePath).getPermission();
        ITestAzureBlobFilesystemAcl.assertEquals((Object)oldPermission, (Object)updatedPermission);
    }

    @Test
    public void testModifyAclEntriesForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", ALL)});
            fs.modifyAclEntries(filePath, (List)aclSpec);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAclEntriesEntriesForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", ALL)});
            fs.removeAclEntries(filePath, (List)aclSpec);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveDefaultAclForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            fs.removeDefaultAcl(filePath);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveAclForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            fs.removeAcl(filePath);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAclForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, "foo", ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "bar", ALL)});
            fs.setAcl(filePath, (List)aclSpec);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAclStatusForNonNamespaceEnabledAccount() throws Exception {
        AzureBlobFileSystem fs = this.getFileSystem();
        Assume.assumeTrue((!fs.getIsNamespaceEnabled() ? 1 : 0) != 0);
        Path filePath = new Path(this.methodName.getMethodName());
        fs.create(filePath);
        try {
            AclStatus aclSpec = fs.getAclStatus(filePath);
            ITestAzureBlobFilesystemAcl.assertFalse((String)"UnsupportedOperationException is expected", (boolean)false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void assertPermission(FileSystem fs, short perm) throws Exception {
        this.assertPermission(fs, this.path, perm);
    }

    private void assertPermission(FileSystem fs, Path pathToCheck, short perm) throws Exception {
        AclTestHelpers.assertPermission(fs, pathToCheck, perm);
    }
}

