/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs;

import java.lang.reflect.Field;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.AbstractAbfsIntegrationTest;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AuthType;
import org.junit.Assume;
import org.junit.Test;

public class ITestOauthOverAbfsScheme
extends AbstractAbfsIntegrationTest {
    public ITestOauthOverAbfsScheme() throws Exception {
        Assume.assumeTrue((String)"ITestOauthOverAbfsScheme is skipped because auth type is not OAuth", (this.getAuthType() == AuthType.OAuth ? 1 : 0) != 0);
    }

    @Test
    public void testOauthOverSchemeAbfs() throws Exception {
        String[] urlWithoutScheme = this.getTestUrl().split(":");
        String fsUrl = "abfs:" + urlWithoutScheme[1];
        Configuration config = this.getRawConfiguration();
        config.set("fs.defaultFS", fsUrl.toString());
        AbfsClient client = this.getFileSystem(config).getAbfsClient();
        Field baseUrlField = AbfsClient.class.getDeclaredField("baseUrl");
        baseUrlField.setAccessible(true);
        String url = ((URL)baseUrlField.get(client)).toString();
        Assume.assumeTrue((String)"OAuth authentication over scheme abfs must use HTTPS", (boolean)url.startsWith("https"));
    }
}

