/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.hops.hadoop.shaded.com.google.protobuf.RpcController;
import io.hops.hadoop.shaded.com.google.protobuf.ServiceException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.leader_election.proto.ActiveNodeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;

public class DatanodeProtocolServerSideTranslatorPB
implements DatanodeProtocolPB {
    private final DatanodeProtocol impl;
    private static final DatanodeProtocolProtos.ErrorReportResponseProto VOID_ERROR_REPORT_RESPONSE_PROTO = DatanodeProtocolProtos.ErrorReportResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto VOID_BLOCK_RECEIVED_AND_DELETE_RESPONSE = DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.ReportBadBlocksResponseProto VOID_REPORT_BAD_BLOCK_RESPONSE = DatanodeProtocolProtos.ReportBadBlocksResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto VOID_COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO = DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto.newBuilder().build();

    public DatanodeProtocolServerSideTranslatorPB(DatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public DatanodeProtocolProtos.RegisterDatanodeResponseProto registerDatanode(RpcController controller, DatanodeProtocolProtos.RegisterDatanodeRequestProto request) throws ServiceException {
        DatanodeRegistration registrationResp;
        DatanodeRegistration registration = PBHelper.convert(request.getRegistration());
        try {
            registrationResp = this.impl.registerDatanode(registration);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return DatanodeProtocolProtos.RegisterDatanodeResponseProto.newBuilder().setRegistration(PBHelper.convert(registrationResp)).build();
    }

    @Override
    public DatanodeProtocolProtos.HeartbeatResponseProto sendHeartbeat(RpcController controller, DatanodeProtocolProtos.HeartbeatRequestProto request) throws ServiceException {
        RollingUpgradeStatus rollingUpdateStatus;
        HeartbeatResponse response;
        try {
            StorageReport[] report = PBHelper.convertStorageReports(request.getReportsList());
            VolumeFailureSummary volumeFailureSummary = request.hasVolumeFailureSummary() ? PBHelper.convertVolumeFailureSummary(request.getVolumeFailureSummary()) : null;
            response = this.impl.sendHeartbeat(PBHelper.convert(request.getRegistration()), report, request.getCacheCapacity(), request.getCacheUsed(), request.getXmitsInProgress(), request.getXceiverCount(), request.getFailedVolumes(), volumeFailureSummary);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.HeartbeatResponseProto.Builder builder = DatanodeProtocolProtos.HeartbeatResponseProto.newBuilder();
        DatanodeCommand[] cmds = response.getCommands();
        if (cmds != null) {
            for (DatanodeCommand cmd : cmds) {
                if (cmd == null) continue;
                builder.addCmds(PBHelper.convert(cmd));
            }
        }
        if ((rollingUpdateStatus = response.getRollingUpdateStatus()) != null) {
            builder.setRollingUpgradeStatus(PBHelper.convertRollingUpgradeStatus(rollingUpdateStatus));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReportResponseProto blockReport(RpcController controller, DatanodeProtocolProtos.BlockReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        StorageBlockReport[] storageBlockReports = new StorageBlockReport[request.getReportsCount()];
        int index = 0;
        for (DatanodeProtocolProtos.StorageBlockReportProto s : request.getReportsList()) {
            DatanodeProtocolProtos.BlockReportProto report = s.getReport();
            storageBlockReports[index++] = new StorageBlockReport(PBHelper.convert(s.getStorage()), PBHelper.convert(report));
        }
        try {
            cmd = this.impl.blockReport(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), storageBlockReports, request.hasContext() ? PBHelper.convert(request.getContext()) : null);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.BlockReportResponseProto.Builder builder = DatanodeProtocolProtos.BlockReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReportResponseProto reportHashes(RpcController controller, DatanodeProtocolProtos.BlockReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        StorageBlockReport[] storageBlockReports = new StorageBlockReport[request.getReportsCount()];
        int index = 0;
        for (DatanodeProtocolProtos.StorageBlockReportProto s : request.getReportsList()) {
            DatanodeProtocolProtos.BlockReportProto report = s.getReport();
            storageBlockReports[index++] = new StorageBlockReport(PBHelper.convert(s.getStorage()), PBHelper.convert(report));
        }
        try {
            cmd = this.impl.reportHashes(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), storageBlockReports);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.BlockReportResponseProto.Builder builder = DatanodeProtocolProtos.BlockReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.CacheReportResponseProto cacheReport(RpcController controller, DatanodeProtocolProtos.CacheReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        try {
            cmd = this.impl.cacheReport(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), request.getBlocksList(), request.getCacheCapacity(), request.getCacheUsed());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.CacheReportResponseProto.Builder builder = DatanodeProtocolProtos.CacheReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto blockReceivedAndDeleted(RpcController controller, DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto request) throws ServiceException {
        List<DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto> sBlocks = request.getBlocksList();
        StorageReceivedDeletedBlocks[] info = new StorageReceivedDeletedBlocks[sBlocks.size()];
        ArrayList<Long> blockIds = new ArrayList<Long>();
        for (int i = 0; i < sBlocks.size(); ++i) {
            DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto sBlock = sBlocks.get(i);
            List<DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto> list = sBlock.getBlocksList();
            ReceivedDeletedBlockInfo[] rdBlocks = new ReceivedDeletedBlockInfo[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                rdBlocks[j] = PBHelper.convert(list.get(j));
                blockIds.add(rdBlocks[j].getBlock().getBlockId());
            }
            info[i] = sBlock.hasStorage() ? new StorageReceivedDeletedBlocks(PBHelper.convert(sBlock.getStorage()), rdBlocks) : new StorageReceivedDeletedBlocks(sBlock.getStorageUuid(), rdBlocks);
        }
        try {
            this.impl.blockReceivedAndDeleted(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), info);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_BLOCK_RECEIVED_AND_DELETE_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.ErrorReportResponseProto errorReport(RpcController controller, DatanodeProtocolProtos.ErrorReportRequestProto request) throws ServiceException {
        try {
            this.impl.errorReport(PBHelper.convert(request.getRegistartion()), request.getErrorCode(), request.getMsg());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_ERROR_REPORT_RESPONSE_PROTO;
    }

    @Override
    public HdfsProtos.VersionResponseProto versionRequest(RpcController controller, HdfsProtos.VersionRequestProto request) throws ServiceException {
        NamespaceInfo info;
        try {
            info = this.impl.versionRequest();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return HdfsProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert(info)).build();
    }

    @Override
    public DatanodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, DatanodeProtocolProtos.ReportBadBlocksRequestProto request) throws ServiceException {
        List<HdfsProtos.LocatedBlockProto> lbps = request.getBlocksList();
        LocatedBlock[] blocks = new LocatedBlock[lbps.size()];
        for (int i = 0; i < lbps.size(); ++i) {
            blocks[i] = PBHelper.convert(lbps.get(i));
        }
        try {
            this.impl.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REPORT_BAD_BLOCK_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto commitBlockSynchronization(RpcController controller, DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto request) throws ServiceException {
        List<HdfsProtos.DatanodeIDProto> dnprotos = request.getNewTargetsList();
        DatanodeID[] dns = new DatanodeID[dnprotos.size()];
        for (int i = 0; i < dnprotos.size(); ++i) {
            dns[i] = PBHelper.convert(dnprotos.get(i));
        }
        List<String> sidprotos = request.getNewTargetStoragesList();
        String[] storageIDs = sidprotos.toArray(new String[sidprotos.size()]);
        try {
            this.impl.commitBlockSynchronization(PBHelper.convert(request.getBlock()), request.getNewGenStamp(), request.getNewLength(), request.getCloseFile(), request.getDeleteBlock(), dns, storageIDs);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO;
    }

    @Override
    public DatanodeProtocolProtos.ActiveNamenodeListResponseProto getActiveNamenodes(RpcController controller, DatanodeProtocolProtos.ActiveNamenodeListRequestProto request) throws ServiceException {
        try {
            SortedActiveNodeList anl = this.impl.getActiveNamenodes();
            DatanodeProtocolProtos.ActiveNamenodeListResponseProto response = PBHelper.convert(anl);
            return response;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ActiveNodeProtos.ActiveNodeProto getNextNamenodeToSendBlockReport(RpcController controller, DatanodeProtocolProtos.NameNodeAddressRequestForBlockReportingProto request) throws ServiceException {
        try {
            ActiveNode response = this.impl.getNextNamenodeToSendBlockReport(request.getNoOfBlks(), PBHelper.convert(request.getRegistration()));
            ActiveNodeProtos.ActiveNodeProto responseProto = PBHelper.convert(response);
            return responseProto;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public DatanodeProtocolProtos.BlockReportCompletedResponseProto blockReportCompleted(RpcController controller, DatanodeProtocolProtos.BlockReportCompletedRequestProto request) throws ServiceException {
        try {
            DatanodeStorage[] storages = new DatanodeStorage[request.getStoragesCount()];
            int i = 0;
            for (HdfsProtos.DatanodeStorageProto storage : request.getStoragesList()) {
                storages[i++] = PBHelper.convert(storage);
            }
            this.impl.blockReportCompleted(PBHelper.convert(request.getRegistration()), storages, request.getSuccess());
            DatanodeProtocolProtos.BlockReportCompletedResponseProto.Builder response = DatanodeProtocolProtos.BlockReportCompletedResponseProto.newBuilder();
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public DatanodeProtocolProtos.SmallFileDataResponseProto getSmallFileData(RpcController controller, DatanodeProtocolProtos.GetSmallFileDataProto request) throws ServiceException {
        try {
            byte[] data = this.impl.getSmallFileData(request.getId());
            return PBHelper.convert(data);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

