/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaUpdateException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;

class FSDirDeleteOp {
    public static final Log LOG = LogFactory.getLog(FSDirDeleteOp.class);
    public static long BIGGEST_DELETABLE_DIR;

    FSDirDeleteOp() {
    }

    static long delete(FSDirectory fsd, INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + iip.getPath());
        }
        long filesRemoved = !FSDirDeleteOp.deleteAllowed(iip, iip.getPath()) ? -1L : FSDirDeleteOp.unprotectedDelete(fsd, iip, collectedBlocks, removedINodes, mtime);
        return filesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean delete(FSNamesystem fsn, String srcArg, boolean recursive) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        String src = fsd.resolvePath(fsd.getPermissionChecker(), srcArg, pathComponents);
        if (!recursive) {
            return FSDirDeleteOp.deleteTransaction(fsn, src, recursive);
        }
        PathInformation pathInfo = fsn.getPathExistingINodesFromDB(src, false, null, FsAction.WRITE, null, null);
        INode pathInode = pathInfo.getINodesInPath().getLastINode();
        if (pathInode == null) {
            NameNode.stateChangeLog.debug("Failed to remove " + src + " because it does not exist");
            return false;
        }
        if (pathInode.isRoot()) {
            NameNode.stateChangeLog.warn("Failed to remove " + src + " because the root is not allowed to be deleted");
            return false;
        }
        INodeIdentifier subtreeRoot = null;
        if (pathInode.isFile() || pathInode.isSymlink()) {
            return FSDirDeleteOp.deleteTransaction(fsn, src, false);
        }
        RetryCacheEntry cacheEntry = LightWeightCacheDistributed.getTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            if (!fsn.isLeader()) {
                throw new QuotaUpdateException("Unable to delete the file " + src + " because Quota is enabled and I am not the leader");
            }
            try {
                subtreeRoot = fsn.lockSubtreeAndCheckOwnerAndParentPermission(src, false, FsAction.WRITE, SubTreeOperation.Type.DELETE_STO);
                List<AclEntry> nearestDefaultsForSubtree = fsn.calculateNearestDefaultAclForSubtree(pathInfo);
                AbstractFileTree.FileTree fileTree = new AbstractFileTree.FileTree(fsn, subtreeRoot, FsAction.ALL, true, nearestDefaultsForSubtree, subtreeRoot.getStoragePolicy());
                fileTree.buildUp(fsd.getBlockStoragePolicySuite());
                fsn.delayAfterBbuildingTree("Built tree for " + srcArg + " for delete op");
                if (fsd.isQuotaEnabled()) {
                    Iterator<Long> idIterator;
                    Iterator<Long> iterator = idIterator = fileTree.getAllINodesIds().iterator();
                    synchronized (iterator) {
                        fsn.getQuotaUpdateManager().addPrioritizedUpdates(idIterator);
                        try {
                            idIterator.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IOException("Operation failed due to an Interrupt");
                        }
                    }
                }
                for (int i = fileTree.getHeight(); i > 0; --i) {
                    if (FSDirDeleteOp.deleteTreeLevel(fsn, src, fileTree.getSubtreeRoot().getId(), fileTree, i)) continue;
                    boolean bl = ret = false;
                    return bl;
                }
            }
            finally {
                if (subtreeRoot != null) {
                    fsn.unlockSubtree(src, subtreeRoot.getInodeId());
                }
            }
            boolean bl = ret = true;
            return bl;
        }
        finally {
            LightWeightCacheDistributed.putTransactional(ret);
        }
    }

    private static boolean deleteTreeLevel(FSNamesystem fsn, String subtreeRootPath, long subTreeRootID, AbstractFileTree.FileTree fileTree, int level) throws TransactionContextException, IOException {
        ArrayList<Future> barrier = new ArrayList<Future>();
        ArrayList<ProjectedINode> emptyDirs = new ArrayList<ProjectedINode>();
        for (ProjectedINode dir : fileTree.getDirsByLevel(level)) {
            if ((long)fileTree.countChildren(dir.getId()) <= BIGGEST_DELETABLE_DIR) {
                String path = fileTree.createAbsolutePath(subtreeRootPath, dir);
                Future f = FSDirDeleteOp.multiTransactionDeleteInternal(fsn, path, subTreeRootID);
                barrier.add(f);
                continue;
            }
            for (ProjectedINode inode : fileTree.getChildren(dir.getId())) {
                if (inode.isDirectory()) continue;
                String path = fileTree.createAbsolutePath(subtreeRootPath, inode);
                Future f = FSDirDeleteOp.multiTransactionDeleteInternal(fsn, path, subTreeRootID);
                barrier.add(f);
            }
            emptyDirs.add(dir);
        }
        boolean success = FSDirDeleteOp.processResponses(barrier);
        if (!success) {
            return false;
        }
        for (ProjectedINode dir : emptyDirs) {
            String path = fileTree.createAbsolutePath(subtreeRootPath, dir);
            Future f = FSDirDeleteOp.multiTransactionDeleteInternal(fsn, path, subTreeRootID);
            barrier.add(f);
        }
        return FSDirDeleteOp.processResponses(barrier);
    }

    private static boolean processResponses(ArrayList<Future> barrier) throws IOException {
        boolean result = true;
        for (Future f : barrier) {
            try {
                if (((Boolean)f.get()).booleanValue()) continue;
                result = false;
            }
            catch (ExecutionException e) {
                result = false;
                LOG.error((Object)"Exception was thrown during partial delete", (Throwable)e);
                Throwable throwable = e.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static Future multiTransactionDeleteInternal(final FSNamesystem fsn, final String src, final long subTreeRootId) throws StorageException, TransactionContextException, IOException {
        final FSDirectory fsd = fsn.getFSDirectory();
        return fsn.getFSOperationsExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                HopsTransactionalRequestHandler deleteHandler = new HopsTransactionalRequestHandler(HDFSOperationType.SUBTREE_DELETE){

                    public void acquireLock(TransactionLocks locks) throws IOException {
                        LockFactory lf = LockFactory.getInstance();
                        INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY, src).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled()).setIgnoredSTOInodes(subTreeRootId);
                        locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, fsn.getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV, LockFactory.BLK.ER));
                        locks.add(lf.getAllUsedHashBucketsLock());
                        if (fsd.isQuotaEnabled()) {
                            locks.add(lf.getQuotaUpdateLock(true, src));
                        }
                        if (fsn.isErasureCodingEnabled()) {
                            locks.add(lf.getEncodingStatusLock(true, TransactionLockTypes.LockType.WRITE, src));
                        }
                        locks.add(lf.getEZLock());
                    }

                    public Object performTask() throws IOException {
                        INodesInPath iip = fsd.getINodesInPath4Write(src);
                        if (!FSDirDeleteOp.deleteInternal(fsn, src, iip)) {
                            throw new RetriableException("Unable to Delete path: " + src + ". Possible subtree quiesce failure");
                        }
                        return true;
                    }
                };
                return (Boolean)deleteHandler.handle(this);
            }
        });
    }

    static boolean deleteTransaction(final FSNamesystem fsn, String srcArg, final boolean recursive) throws IOException {
        final FSDirectory fsd = fsn.getFSDirectory();
        final FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(pc, srcArg, pathComponents);
        HopsTransactionalRequestHandler deleteHandler = new HopsTransactionalRequestHandler(HDFSOperationType.DELETE, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN, src).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il).add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, fsn.getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED)).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.PE, LockFactory.BLK.IV, LockFactory.BLK.ER));
                if (fsn.isRetryCacheEnabled()) {
                    locks.add(lf.getRetryCacheEntryLock(Server.getClientId(), Server.getCallId(), Server.getRpcEpoch()));
                }
                locks.add(lf.getAllUsedHashBucketsLock());
                if (fsd.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src));
                }
                if (fsn.isErasureCodingEnabled()) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, src));
                }
                locks.add(lf.getEZLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                RetryCacheEntry cacheEntry = LightWeightCacheDistributed.get();
                if (cacheEntry != null && cacheEntry.isSuccess()) {
                    return true;
                }
                boolean ret = false;
                try {
                    INodesInPath iip = fsd.getINodesInPath4Write(src, false);
                    if (!recursive && fsd.isNonEmptyDirectory(iip)) {
                        throw new PathIsNotEmptyDirectoryException(src + " is non empty");
                    }
                    if (fsd.isPermissionEnabled()) {
                        fsd.checkPermission(pc, iip, false, null, FsAction.WRITE, null, FsAction.ALL, true);
                    }
                    ret = FSDirDeleteOp.deleteInternal(fsn, src, iip);
                    Boolean bl = ret;
                    return bl;
                }
                finally {
                    LightWeightCacheDistributed.put(null, ret);
                }
            }
        };
        return (Boolean)deleteHandler.handle();
    }

    static boolean deleteInternal(FSNamesystem fsn, String src, INodesInPath iip) throws IOException {
        long mtime;
        ChunkedArrayList<INode> removedINodes;
        INode.BlocksMapUpdateInfo collectedBlocks;
        FSDirectory fsd;
        long filesRemoved;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.delete: " + src);
        }
        if ((filesRemoved = FSDirDeleteOp.delete(fsd = fsn.getFSDirectory(), iip, collectedBlocks = new INode.BlocksMapUpdateInfo(), removedINodes = new ChunkedArrayList<INode>(), mtime = Time.now())) < 0L) {
            return false;
        }
        FSDirDeleteOp.incrDeletedFileCount(filesRemoved);
        fsn.removeLeasesAndINodes(src, removedINodes);
        fsn.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* Namesystem.delete: " + src + " is removed");
        }
        return true;
    }

    static void incrDeletedFileCount(long count) {
        NameNode.getNameNodeMetrics().incrFilesDeleted(count);
    }

    private static boolean deleteAllowed(INodesInPath iip, String src) {
        if (iip.length() < 1 || iip.getLastINode() == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist");
            }
            return false;
        }
        if (iip.length() == 1) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted");
            return false;
        }
        return true;
    }

    private static long unprotectedDelete(FSDirectory fsd, INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws IOException {
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return -1L;
        }
        if (iip.length() == 1) {
            return -1L;
        }
        FSDirDeleteOp.addMetaDataLogForDirDeletion(targetNode, fsd.getFSNamesystem().getNamenodeId());
        long removed = fsd.removeLastINode(iip);
        if (removed == -1L) {
            return -1L;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime);
        if (removed == 0L) {
            return 0L;
        }
        targetNode.destroyAndCollectBlocks(fsd.getBlockStoragePolicySuite(), collectedBlocks, removedINodes);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + iip.getPath() + " is removed");
        }
        return removed;
    }

    private static void addMetaDataLogForDirDeletion(INode targetNode, long namenodeId) throws IOException {
        if (targetNode.isDirectory()) {
            List<INode> children = ((INodeDirectory)targetNode).getChildrenList();
            for (INode child : children) {
                if (child.isDirectory()) {
                    FSDirDeleteOp.addMetaDataLogForDirDeletion(child, namenodeId);
                    continue;
                }
                child.logMetadataEvent(INodeMetadataLogEntry.Operation.Delete);
                child.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.delete());
            }
        }
        targetNode.logMetadataEvent(INodeMetadataLogEntry.Operation.Delete);
        targetNode.logProvenanceEvent(namenodeId, FileProvenanceEntry.Operation.delete());
    }
}

