/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;

public class NormalUserCertLocServiceHopsSSLCheck
extends AbstractHopsSSLCheck {
    public NormalUserCertLocServiceHopsSSLCheck() {
        super(105);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperUsers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        String username = ugi.getUserName();
        if ((username.matches("\\w*__\\w*") || !proxySuperUsers.contains(username)) && certificateLocalization != null) {
            try {
                X509SecurityMaterial material = certificateLocalization.getX509MaterialLocation(username, ugi.getApplicationId());
                return new HopsSSLCryptoMaterial(material.getKeyStoreLocation().toString(), material.getKeyStorePass(), material.getKeyStorePass(), material.getTrustStoreLocation().toString(), material.getTrustStorePass(), material.getPasswdLocation().toString(), true);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
        return null;
    }
}

