/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import io.hops.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnException;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class RPCUtil {
    public static YarnException getRemoteException(Throwable t) {
        return new YarnException(t);
    }

    public static YarnException getRemoteException(String message) {
        return new YarnException(message);
    }

    private static <T extends Throwable> T instantiateException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        try {
            Constructor<T> cn = cls.getConstructor(String.class);
            cn.setAccessible(true);
            Throwable ex = (Throwable)cn.newInstance(re.getMessage());
            ex.initCause(re);
            return (T)ex;
        }
        catch (NoSuchMethodException e) {
            throw re;
        }
        catch (IllegalArgumentException e) {
            throw re;
        }
        catch (SecurityException e) {
            throw re;
        }
        catch (InstantiationException e) {
            throw re;
        }
        catch (IllegalAccessException e) {
            throw re;
        }
        catch (InvocationTargetException e) {
            throw re;
        }
    }

    private static <T extends YarnException> T instantiateYarnException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((YarnException)RPCUtil.instantiateException(cls, re));
    }

    private static <T extends IOException> T instantiateIOException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((IOException)RPCUtil.instantiateException(cls, re));
    }

    private static <T extends RuntimeException> T instantiateRuntimeException(Class<? extends T> cls, RemoteException re) throws RemoteException {
        return (T)((RuntimeException)RPCUtil.instantiateException(cls, re));
    }

    public static Void unwrapAndThrowException(ServiceException se) throws IOException, YarnException {
        Throwable cause = se.getCause();
        if (cause == null) {
            throw new IOException(se);
        }
        if (cause instanceof RemoteException) {
            RemoteException re = (RemoteException)cause;
            Class<?> realClass = null;
            try {
                realClass = Class.forName(re.getClassName());
            }
            catch (ClassNotFoundException cnf) {
                throw RPCUtil.instantiateYarnException(YarnException.class, re);
            }
            if (YarnException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateYarnException(realClass.asSubclass(YarnException.class), re);
            }
            if (IOException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateIOException(realClass.asSubclass(IOException.class), re);
            }
            if (RuntimeException.class.isAssignableFrom(realClass)) {
                throw RPCUtil.instantiateRuntimeException(realClass.asSubclass(RuntimeException.class), re);
            }
            throw re;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IOException(se);
    }
}

