/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeResolver;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.SubtreeLockHelper;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.ipc.RetriableException;

public class INodeLock
extends BaseINodeLock {
    private final TransactionLockTypes.INodeLockType lockType;
    private final TransactionLockTypes.INodeResolveType resolveType;
    private boolean resolveLink;
    protected final String[] paths;
    protected final long inodeId;
    private Collection<Long> ignoredSTOInodes;
    protected boolean skipReadingQuotaAttr;
    protected long namenodeId;
    protected Collection<ActiveNode> activeNamenodes;

    INodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, String ... paths) {
        this.lockType = lockType;
        this.resolveType = resolveType;
        this.resolveLink = false;
        this.activeNamenodes = null;
        this.ignoredSTOInodes = new ArrayList<Long>();
        this.namenodeId = -1L;
        this.paths = paths;
        this.inodeId = -1L;
        this.skipReadingQuotaAttr = false;
    }

    INodeLock(TransactionLockTypes.INodeLockType lockType, TransactionLockTypes.INodeResolveType resolveType, long inodeId) {
        this.lockType = lockType;
        this.resolveType = resolveType;
        this.resolveLink = false;
        this.activeNamenodes = null;
        this.ignoredSTOInodes = new ArrayList<Long>();
        this.namenodeId = -1L;
        this.paths = null;
        this.inodeId = inodeId;
        this.skipReadingQuotaAttr = false;
    }

    public INodeLock setIgnoredSTOInodes(long inodeID) {
        this.ignoredSTOInodes.add(inodeID);
        return this;
    }

    public INodeLock setNameNodeID(long nnID) {
        this.namenodeId = nnID;
        return this;
    }

    public INodeLock setActiveNameNodes(Collection<ActiveNode> activeNamenodes) {
        this.activeNamenodes = activeNamenodes;
        return this;
    }

    public INodeLock skipReadingQuotaAttr(boolean val) {
        this.skipReadingQuotaAttr = val;
        return this;
    }

    public INodeLock resolveSymLink(boolean resolveLink) {
        this.resolveLink = resolveLink;
        return this;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        if (this.paths != null) {
            Arrays.sort(this.paths);
            this.acquirePathsINodeLocks();
        } else {
            this.acquireInodeIdInodeLock();
        }
        if (!this.skipReadingQuotaAttr) {
            this.acquireINodeAttributes();
        }
    }

    protected void acquireInodeIdInodeLock() throws IOException {
        if (!(this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY))) {
            throw new IllegalArgumentException("Unknown type " + this.resolveType.name());
        }
        List<INode> resolvedINodes = this.resolveUsingCache(this.lockType, this.inodeId);
        String path = INodeUtil.constructPath(resolvedINodes);
        this.addPathINodesAndUpdateResolvingCache(path, resolvedINodes);
        if (resolvedINodes != null && resolvedINodes.size() > 0) {
            INode lastINode = resolvedINodes.get(resolvedINodes.size() - 1);
            if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) {
                List<INode> children = this.findImmediateChildren(lastINode);
                this.addChildINodes(path, children);
            } else if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY) {
                List<INode> children = this.findChildrenRecursively(lastINode);
                this.addChildINodes(path, children);
            }
        }
    }

    protected void acquirePathsINodeLocks() throws IOException {
        if (!(this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) || this.resolveType.equals((Object)TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY))) {
            throw new IllegalArgumentException("Unknown type " + this.resolveType.name());
        }
        for (String path : this.paths) {
            List<INode> children;
            List<INode> resolvedINodes = null;
            if (this.getDefaultInodeLockType() == TransactionLockTypes.INodeLockType.READ_COMMITTED) {
                resolvedINodes = this.resolveUsingCache(path);
            }
            if (resolvedINodes == null) {
                if (setRandomParitionKeyEnabled) {
                    this.setPartitioningKey(rand.nextLong());
                }
                resolvedINodes = this.acquireINodeLockByPath(path);
                this.addPathINodesAndUpdateResolvingCache(path, resolvedINodes);
            }
            if (resolvedINodes.size() <= 0) continue;
            INode lastINode = resolvedINodes.get(resolvedINodes.size() - 1);
            if (this.resolveType == TransactionLockTypes.INodeResolveType.PATH_AND_IMMEDIATE_CHILDREN) {
                children = this.findImmediateChildren(lastINode);
                this.addChildINodes(path, children);
                continue;
            }
            if (this.resolveType != TransactionLockTypes.INodeResolveType.PATH_AND_ALL_CHILDREN_RECURSIVELY) continue;
            children = this.findChildrenRecursively(lastINode);
            this.addChildINodes(path, children);
        }
    }

    private List<INode> resolveUsingCache(String path) throws IOException {
        BaseINodeLock.CacheResolver cacheResolver = this.getCacheResolver();
        if (cacheResolver == null) {
            return null;
        }
        List<INode> resolvedINodes = cacheResolver.fetchINodes(this.lockType, path, this.resolveLink);
        if (resolvedINodes != null) {
            for (INode iNode : resolvedINodes) {
                if (iNode == null) continue;
                this.checkSubtreeLock(iNode);
            }
            this.handleLockUpgrade(resolvedINodes, INode.getPathComponents(path), path);
        }
        return resolvedINodes;
    }

    private List<INode> acquireINodeLockByPath(String path) throws UnresolvedPathException, StorageException, RetriableException, TransactionContextException {
        ArrayList<INode> resolvedINodes = new ArrayList<INode>();
        byte[][] components = INode.getPathComponents(path);
        if (this.isRootTarget(components)) {
            resolvedINodes.add(this.acquireLockOnRoot(this.lockType));
            return resolvedINodes;
        }
        INode currentINode = this.isRootParent(components) && TransactionLockTypes.impliesParentWriteLock((TransactionLockTypes.INodeLockType)this.lockType) ? this.acquireLockOnRoot(this.lockType) : this.acquireLockOnRoot(this.getDefaultInodeLockType());
        resolvedINodes.add(currentINode);
        INodeResolver resolver = new INodeResolver(components, currentINode, this.resolveLink, true);
        while (resolver.hasNext()) {
            TransactionLockTypes.INodeLockType currentINodeLock = this.identifyLockType(this.lockType, resolver.getCount() + 1, components);
            this.setINodeLockType(currentINodeLock);
            currentINode = resolver.next();
            if (currentINode == null) continue;
            this.addLockedINodes(currentINode, currentINodeLock);
            this.checkSubtreeLock(currentINode);
            resolvedINodes.add(currentINode);
        }
        this.handleLockUpgrade(resolvedINodes, components, path);
        return resolvedINodes;
    }

    private boolean isRootTarget(byte[][] components) {
        return this.isTarget(0, components);
    }

    private boolean isRootParent(byte[][] components) {
        return this.isParent(0, components);
    }

    private void checkSubtreeLock(INode iNode) throws RetriableException {
        if (SubtreeLockHelper.isSTOLocked(iNode.isSTOLocked(), iNode.getSTOLockOwner(), this.activeNamenodes)) {
            if (!this.ignoredSTOInodes.contains(iNode.getId())) {
                throw new RetriableException("The subtree " + iNode.getLocalName() + " is locked by Namenode Id: " + iNode.getSTOLockOwner() + ". Active Namenodes are: " + this.activeNamenodes);
            }
            LOG.trace((Object)("Ignoring subtree lock for inode id: " + iNode.getId()));
        }
    }

    private void handleLockUpgrade(List<INode> resolvedINodes, byte[][] components, String path) throws StorageException, UnresolvedPathException, TransactionContextException {
        if (resolvedINodes.size() != components.length) {
            INode inodeToReread = null;
            if (this.lockType == TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT) {
                if (resolvedINodes.size() <= components.length - 2) {
                    inodeToReread = resolvedINodes.get(resolvedINodes.size() - 1);
                }
            } else if (this.lockType == TransactionLockTypes.INodeLockType.WRITE) {
                inodeToReread = resolvedINodes.get(resolvedINodes.size() - 1);
            }
            if (inodeToReread != null) {
                long partitionIdOfINodeToBeReRead = INode.calculatePartitionId(inodeToReread.getParentId(), inodeToReread.getLocalName(), inodeToReread.myDepth());
                INode inode = this.find(this.lockType, inodeToReread.getLocalName(), inodeToReread.getParentId(), partitionIdOfINodeToBeReRead);
                if (inode != null) {
                    this.addLockedINodes(inode, this.lockType);
                    String existingPath = this.buildPath(path, resolvedINodes.size());
                    List<INode> rest = this.acquireLockOnRestOfPath(this.lockType, inode, path, existingPath, false);
                    resolvedINodes.addAll(rest);
                }
            }
        }
    }

    private List<INode> acquireLockOnRestOfPath(TransactionLockTypes.INodeLockType lock, INode baseInode, String fullPath, String prefix, boolean resolveLink) throws StorageException, UnresolvedPathException, TransactionContextException {
        ArrayList<INode> resolved = new ArrayList<INode>();
        byte[][] fullComps = INode.getPathComponents(fullPath);
        byte[][] prefixComps = INode.getPathComponents(prefix);
        INodeResolver resolver = new INodeResolver(fullComps, baseInode, resolveLink, true, prefixComps.length - 1);
        while (resolver.hasNext()) {
            this.setINodeLockType(lock);
            INode current = resolver.next();
            if (current == null) continue;
            this.addLockedINodes(current, lock);
            resolved.add(current);
        }
        return resolved;
    }

    private List<INode> findImmediateChildren(INode lastINode) throws StorageException, TransactionContextException {
        ArrayList<INode> children = new ArrayList<INode>();
        if (lastINode != null && lastINode instanceof INodeDirectory) {
            this.setINodeLockType(TransactionLockTypes.INodeLockType.READ_COMMITTED);
            children.addAll(((INodeDirectory)lastINode).getChildrenList());
        }
        return children;
    }

    private List<INode> findChildrenRecursively(INode lastINode) throws StorageException, TransactionContextException {
        LinkedList<INode> children = new LinkedList<INode>();
        LinkedList<INode> unCheckedDirs = new LinkedList<INode>();
        if (lastINode != null && lastINode instanceof INodeDirectory) {
            unCheckedDirs.add(lastINode);
        }
        while (!unCheckedDirs.isEmpty()) {
            INode next = (INode)unCheckedDirs.poll();
            if (!(next instanceof INodeDirectory)) continue;
            this.setINodeLockType(TransactionLockTypes.INodeLockType.READ_COMMITTED);
            List<INode> clist = ((INodeDirectory)next).getChildrenList();
            unCheckedDirs.addAll(clist);
            children.addAll(clist);
        }
        LOG.trace((Object)("Added " + children.size() + " children."));
        return children;
    }

    private INode acquireLockOnRoot(TransactionLockTypes.INodeLockType lock) throws StorageException, TransactionContextException {
        LOG.trace((Object)("Acquiring " + lock + " on the root node"));
        return this.find(lock, "", 0L, INodeDirectory.getRootDirPartitionKey());
    }

    private String buildPath(String path, int size) {
        StringBuilder builder = new StringBuilder();
        byte[][] components = INode.getPathComponents(path);
        for (int i = 0; i < Math.min(components.length, size); ++i) {
            if (i == 0) {
                builder.append("/");
                continue;
            }
            if (i != 1) {
                builder.append("/");
            }
            builder.append(DFSUtil.bytes2String(components[i]));
        }
        return builder.toString();
    }

    protected INode find(String name, long parentId, long partitionId) throws StorageException, TransactionContextException {
        return this.find(this.lockType, name, parentId, partitionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("INodeLock {");
        if (this.paths != null && this.paths.length > 0) {
            sb.append("paths=");
            sb.append(Arrays.toString(this.paths));
            sb.append(", ");
        }
        if (this.inodeId != -1L) {
            sb.append("INodeID: ");
            sb.append(this.inodeId);
            sb.append(",");
        }
        if (this.lockType != null) {
            sb.append("lockType=");
            sb.append(this.lockType);
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }
}

