/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.PathData;

abstract class ParallelCommandWithDestination
extends CommandWithDestination {
    protected ThreadPoolExecutor copier;
    private ConcurrentLinkedQueue<Future> activeCopiers = new ConcurrentLinkedQueue();
    List<SrcDstPair> fileToDst = new ArrayList<SrcDstPair>();
    List<PathData> sucessfull = new ArrayList<PathData>();
    boolean filesSubmitted = false;
    ThreadLocal<FileSystem> fileSystems = new ThreadLocal();

    ParallelCommandWithDestination() {
    }

    @Override
    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        if (this.getNumThreads() == 1) {
            super.processPaths(parent, items);
        } else {
            this.parallelCopy(parent, items);
        }
    }

    private void parallelCopy(PathData parent, PathData ... items) {
        ArrayList<PathData> curdirs = new ArrayList<PathData>();
        try {
            Object future;
            Future f;
            ProcessPathThread processFile;
            for (PathData item : items) {
                if (this.isPathRecursable(item)) {
                    processFile = new ProcessPathThread(item, this.dst);
                    f = this.getThreadProol().submit(processFile);
                    this.activeCopiers.add(f);
                    curdirs.add(item);
                    continue;
                }
                this.fileToDst.add(new SrcDstPair(item, this.dst));
            }
            while ((future = this.activeCopiers.poll()) != null) {
                try {
                    PathData processed = (PathData)future.get();
                    this.sucessfull.add(processed);
                }
                catch (Exception e) {
                    if (e instanceof ExecutionException) {
                        e = (Exception)e.getCause();
                    }
                    this.displayError(e);
                }
            }
            for (PathData dir : curdirs) {
                if (!this.recursive || !this.isPathRecursable(dir)) continue;
                this.recursePath(dir);
            }
            if (parent == null) {
                Future future2;
                this.filesSubmitted = true;
                long time = System.currentTimeMillis();
                Collections.shuffle(this.fileToDst);
                for (SrcDstPair srcDstPair : this.fileToDst) {
                    processFile = new ProcessPathThread(srcDstPair.src, srcDstPair.dst);
                    f = this.getThreadProol().submit(processFile);
                    this.activeCopiers.add(f);
                }
                while ((future2 = this.activeCopiers.poll()) != null) {
                    try {
                        PathData processed = (PathData)future2.get();
                        this.sucessfull.add(processed);
                    }
                    catch (Exception e) {
                        if (e instanceof ExecutionException) {
                            e = (Exception)e.getCause();
                        }
                        this.displayError(e);
                    }
                }
                for (PathData path : this.sucessfull) {
                    this.postProcessPath(path);
                }
            }
        }
        catch (IOException e) {
            this.displayError(e);
        }
    }

    protected ThreadPoolExecutor getThreadProol() {
        if (this.copier == null) {
            this.copier = new ThreadPoolExecutor(this.getNumThreads(), this.getNumThreads(), 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return this.copier;
    }

    protected PathData getTargetPath(PathData src, PathData dest) throws IOException {
        PathData target = this.getDepth() > 0 || dest.exists && dest.stat.isDirectory() ? dest.getPathDataForChild(src) : (dest.representsDirectory() ? dest.getPathDataForChild(src) : dest);
        return target;
    }

    @Override
    protected void processArgument(PathData item) throws IOException {
        super.processArgument(item);
        ThreadPoolExecutor executor = this.getThreadProol();
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            this.displayError(e);
            Thread.currentThread().interrupt();
        }
    }

    private class SrcDstPair {
        PathData src;
        PathData dst;

        public SrcDstPair(PathData src, PathData dst) {
            this.src = src;
            this.dst = dst;
        }
    }

    private class ProcessPathThread
    implements Callable {
        PathData src;
        PathData destDir;

        ProcessPathThread(PathData src, PathData destDir) {
            this.src = src;
            this.destDir = destDir;
        }

        public Object call() throws Exception {
            PathData dest = ParallelCommandWithDestination.this.getTargetPath(this.src, this.destDir);
            if (ParallelCommandWithDestination.this.isDstRemote()) {
                FileSystem dfs = ParallelCommandWithDestination.this.fileSystems.get();
                if (dfs == null) {
                    dfs = FileSystem.newInstance(dest.getURI(), ParallelCommandWithDestination.this.getConf());
                    ParallelCommandWithDestination.this.fileSystems.set(dfs);
                }
                dest.overrideFS(dfs);
            }
            ParallelCommandWithDestination.this.processPath(this.src, dest);
            return this.src;
        }
    }
}

