/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.transaction.lock.LeaseLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.NameNodeLeaseLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.Lease;

public final class LeasePathLock
extends Lock {
    private final TransactionLockTypes.LockType lockType;
    private final List<LeasePath> leasePaths;
    private final int expectedCount;
    private final String src;

    private LeasePathLock(TransactionLockTypes.LockType lockType, int expectedCount, String src) {
        this.lockType = lockType;
        this.leasePaths = new ArrayList<LeasePath>();
        this.expectedCount = expectedCount;
        this.src = src;
    }

    LeasePathLock(TransactionLockTypes.LockType lockType, int expectedCount) {
        this(lockType, expectedCount, null);
    }

    LeasePathLock(TransactionLockTypes.LockType lockType) {
        this(lockType, Integer.MAX_VALUE, null);
    }

    LeasePathLock(TransactionLockTypes.LockType lockType, String src) {
        this(lockType, Integer.MAX_VALUE, src);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        NameNodeLeaseLock nameNodeLeaseLock;
        if (locks.containsLock(Lock.Type.NameNodeLease) && (nameNodeLeaseLock = (NameNodeLeaseLock)locks.getLock(Lock.Type.NameNodeLease)).getNameNodeLease() != null) {
            this.acquireLeasePaths(nameNodeLeaseLock.getNameNodeLease());
        }
        LeaseLock leaseLock = (LeaseLock)locks.getLock(Lock.Type.Lease);
        TransactionLockTypes.LeaseHolderResolveType resolveType = leaseLock.getResolveType();
        for (Lease lease : leaseLock.getLeases()) {
            if (resolveType == TransactionLockTypes.LeaseHolderResolveType.SINGLE_PATH) {
                this.acquireLeasePath(lease, leaseLock.getSingleFileLock());
                continue;
            }
            assert (resolveType == TransactionLockTypes.LeaseHolderResolveType.ALL_PATHS);
            this.acquireLeasePaths(lease);
        }
        if (this.src != null && !this.src.equals("")) {
            this.acquireAllLeasePathsForDir(this.src);
        }
        if (this.leasePaths.size() > this.expectedCount) {
            // empty if block
        }
    }

    private void acquireLeasePaths(Lease lease) throws StorageException, TransactionContextException {
        LeasePathLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        Collection result = this.acquireLockList(this.lockType, (FinderType)LeasePath.Finder.ByHolderId, new Object[]{lease.getHolderID()});
        if (!lease.getHolder().equals("HDFS_NameNode")) {
            this.leasePaths.addAll(result);
        }
    }

    private void acquireLeasePath(Lease lease, String path) throws StorageException, TransactionContextException {
        LeasePathLock.setLockMode((TransactionLockTypes.LockType)this.lockType);
        LeasePath leasePath = (LeasePath)this.acquireLock(this.lockType, (FinderType)LeasePath.Finder.ByPath, new Object[]{path});
        if (leasePath != null) {
            this.leasePaths.add(leasePath);
        }
    }

    private void acquireAllLeasePathsForDir(String src) throws StorageException, TransactionContextException {
        Collection result = this.acquireLockList(this.lockType, (FinderType)LeasePath.Finder.ByPrefix, new Object[]{src});
        this.leasePaths.addAll(result);
    }

    protected final Lock.Type getType() {
        return Lock.Type.LeasePath;
    }

    Collection<LeasePath> getLeasePaths() {
        return this.leasePaths;
    }

    public TransactionLockTypes.LockType getLockType() {
        return this.lockType;
    }
}

