/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import io.hops.hadoop.shaded.com.google.protobuf.BlockingService;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.MetaStatus;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.security.UsersGroups;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HDFSPolicyProvider;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.BRLoadBalancingOverloadException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LightWeightCacheDistributed;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HashesMismatchCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import org.apache.hadoop.ipc.proto.RefreshCallQueueProtocolProtos;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolServerSideTranslatorPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolServerSideTranslatorPB;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminPB;
import org.apache.hadoop.tracing.TraceAdminProtocolPB;
import org.apache.hadoop.tracing.TraceAdminProtocolServerSideTranslatorPB;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.util.VersionUtil;
import org.slf4j.Logger;

class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Logger LOG = NameNode.LOG;
    private static final Logger stateChangeLog = NameNode.stateChangeLog;
    private static final Logger blockStateChangeLog = NameNode.blockStateChangeLog;
    protected FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        InetSocketAddress listenAddr;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine(conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService(clientProtocolServerTranslator);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB(this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService(refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService(refreshUserMappingXlator);
        RefreshCallQueueProtocolServerSideTranslatorPB refreshCallQueueXlator = new RefreshCallQueueProtocolServerSideTranslatorPB(this);
        BlockingService refreshCallQueueService = RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.newReflectiveBlockingService(refreshCallQueueXlator);
        GenericRefreshProtocolServerSideTranslatorPB genericRefreshXlator = new GenericRefreshProtocolServerSideTranslatorPB(this);
        BlockingService genericRefreshService = GenericRefreshProtocolProtos.GenericRefreshProtocolService.newReflectiveBlockingService(genericRefreshXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService(getUserMappingXlator);
        TraceAdminProtocolServerSideTranslatorPB traceAdminXlator = new TraceAdminProtocolServerSideTranslatorPB(this);
        BlockingService traceAdminService = TraceAdminPB.TraceAdminService.newReflectiveBlockingService(traceAdminXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort());
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.serviceRpcServer);
            listenAddr = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort());
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
        }
        listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, AclException.class, FSLimitException.PathComponentTooLongException.class, FSLimitException.MaxDirectoryItemsExceededException.class, UnresolvedPathException.class, BRLoadBalancingOverloadException.class);
    }

    @VisibleForTesting
    RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    @VisibleForTesting
    RPC.Server getServiceRpcServer() {
        return this.serviceRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlocks(datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getDelegationToken(renewer);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        this.checkNNStartup();
        return this.namesystem.renewDelegationToken(token);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.checkNNStartup();
        this.namesystem.cancelDelegationToken(token);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetBlockLocations();
        return this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getServerDefaults();
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        HdfsFileStatus stat = this.namesystem.startFile(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), clientName, clientMachine, flag.get(), createParent, replication, blockSize, supportedVersions);
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return stat;
    }

    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine);
        }
        LastBlockWithStatus info = this.namesystem.appendFile(src, clientName, clientMachine, flag.get());
        this.metrics.incrFilesAppended();
        return info;
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        this.checkNNStartup();
        return this.namesystem.setReplication(src, replication);
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.checkNNStartup();
        this.namesystem.setStoragePolicy(src, policyName);
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        return this.namesystem.getStoragePolicy(storagePolicyID);
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStoragePolicies();
    }

    @Override
    public void setMetaStatus(String src, MetaStatus metaStatus) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        this.namesystem.setMetaStatus(src, metaStatus);
    }

    @Override
    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.checkNNStartup();
        this.namesystem.setPermission(src, permissions);
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkNNStartup();
        this.namesystem.setOwner(src, username, groupname);
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes) throws IOException {
        List<String> favoredNodesList;
        LocatedBlock locatedBlock;
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*BLOCK* NameNode.addBlock: file " + src + " fileId=" + fileId + " for " + clientName);
        }
        HashSet<Node> excludedNodesSet = null;
        if (excludedNodes != null) {
            excludedNodesSet = new HashSet<Node>(excludedNodes.length);
            for (DatanodeInfo node : excludedNodes) {
                excludedNodesSet.add(node);
            }
        }
        if ((locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodesSet, favoredNodesList = favoredNodes == null ? null : Arrays.asList(favoredNodes))) != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        this.checkNNStartup();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAdditionalDatanode: src=" + src + ", fileId=" + fileId + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName);
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashSet<Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashSet<Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.add(node);
            }
        }
        return this.namesystem.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludeSet, numAdditionalNodes, clientName);
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src);
        }
        if (!this.namesystem.abandonBlock(b, fileId, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId, byte[] data) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.complete: " + src + " fileId=" + fileId + " for " + clientName);
        }
        return this.namesystem.completeFile(src, clientName, last, fileId, data);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkNNStartup();
        this.namesystem.reportBadBlocks(blocks);
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        this.checkNNStartup();
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.checkNNStartup();
        this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs);
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.checkNNStartup();
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getPreferredBlockSize(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        RetryCacheEntry cacheEntry = LightWeightCacheDistributed.getTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.namesystem.renameTo(src, dst);
        }
        finally {
            LightWeightCacheDistributed.putTransactional(ret);
        }
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.checkNNStartup();
        this.namesystem.concat(trg, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        RetryCacheEntry cacheEntry = LightWeightCacheDistributed.getTransactional();
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.renameTo(src, dst, options);
            success = true;
        }
        finally {
            LightWeightCacheDistributed.putTransactional(success);
        }
        this.metrics.incrFilesRenamed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.truncate: " + src + " to " + newLength);
        }
        String clientMachine = NameNodeRpcServer.getClientMachine();
        try {
            boolean bl = this.namesystem.truncate(src, newLength, clientName, clientMachine, Time.now());
            return bl;
        }
        finally {
            this.metrics.incrFilesTruncated();
        }
    }

    @Override
    public boolean delete(String src, boolean recursive) throws IOException {
        boolean ret;
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive);
        }
        if (ret = this.namesystem.delete(src, recursive)) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= HdfsConstants.MAX_PATH_LENGTH && srcPath.depth() <= HdfsConstants.MAX_PATH_DEPTH;
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.mkdirs: " + src);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit " + HdfsConstants.MAX_PATH_LENGTH + " characters, " + HdfsConstants.MAX_PATH_DEPTH + " levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    @Override
    public void renewLease(String clientName) throws IOException {
        this.checkNNStartup();
        this.namesystem.renewLease(clientName);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkNNStartup();
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    @Override
    public boolean isFileClosed(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.isFileClosed(src);
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    @Override
    public long[] getStats() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStats();
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        return results;
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeStorageReport[] reports = this.namesystem.getDatanodeStorageReport(type);
        return reports;
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.checkNNStartup();
        return this.namesystem.setSafeMode(action);
    }

    @Override
    public void refreshNodes() throws IOException {
        this.checkNNStartup();
        this.namesystem.refreshNodes();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.checkNNStartup();
        LOG.info("rollingUpgrade " + (Object)((Object)action));
        switch (action) {
            case QUERY: {
                return this.namesystem.queryRollingUpgrade();
            }
            case PREPARE: {
                return this.namesystem.startRollingUpgrade();
            }
            case FINALIZE: {
                return this.namesystem.finalizeRollingUpgrade();
            }
        }
        throw new UnsupportedActionException((Object)((Object)action) + " is not yet supported.");
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.checkNNStartup();
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkNNStartup();
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getContentSummary(path);
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.checkNNStartup();
        this.namesystem.setQuota(path, namespaceQuota, storagespaceQuota, type);
    }

    @Override
    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.checkNNStartup();
        this.namesystem.fsync(src, fileId, clientName, lastBlockLength);
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkNNStartup();
        this.namesystem.setTimes(src, mtime, atime);
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.checkNNStartup();
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds " + HdfsConstants.MAX_PATH_LENGTH + " character limit");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        this.namesystem.createSymlink(target, link, new PermissionStatus(ugi.getShortUserName(), null, dirPerms), createParent);
    }

    @Override
    public String getLinkTarget(String path) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink().toString();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.checkNNStartup();
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] reports, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, reports, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes, volumeFailureSummary);
    }

    @Override
    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports, BlockReportContext context) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReport: from " + nodeReg + ", reports.length=" + reports.length);
        }
        BlockManager bm = this.namesystem.getBlockManager();
        boolean noStaleStorages = false;
        for (int r = 0; r < reports.length; ++r) {
            BlockReport blocks = reports[r].getReport();
            noStaleStorages = bm.processReport(nodeReg, reports[r].getStorage(), blocks, context, r == reports.length - 1);
            this.metrics.incrStorageBlockReportOps();
        }
        if (noStaleStorages && !this.namesystem.isRollingUpgradeTX()) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public DatanodeCommand reportHashes(DatanodeRegistration nodeReg, String poolId, StorageBlockReport[] reports) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.reportHashes: from " + nodeReg + ", reports.length=" + reports.length);
        }
        HashesMismatchCommand hmc = new HashesMismatchCommand();
        BlockManager bm = this.namesystem.getBlockManager();
        for (StorageBlockReport r : reports) {
            BlockReport blocks = r.getReport();
            List<Integer> mb = bm.checkHashes(nodeReg, r.getStorage(), blocks);
            hmc.addStorageBuckets(r.getStorage().getStorageID(), mb);
        }
        return hmc;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration nodeReg, String poolId, List<Long> blockIds, long cacheCapacity, long cacheUsed) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.cacheReport: from " + nodeReg + " " + blockIds.size() + " blocks");
        }
        this.namesystem.getCacheManager().processCacheReport(nodeReg, blockIds, cacheCapacity, cacheUsed);
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        this.metrics.incrBlockReceivedAndDeletedOps();
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks.");
        }
        for (StorageReceivedDeletedBlocks r : receivedAndDeletedBlocks) {
            this.namesystem.processIncrementalBlockReport(nodeReg, r);
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        this.checkNNStartup();
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info("Error report from " + dnName + ": " + msg);
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn("Disk error on " + dnName + ": " + msg);
        } else if (errorCode == 3) {
            LOG.warn("Fatal disk error on " + dnName + ": " + msg);
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg, false);
        } else {
            LOG.info("Error report from " + dnName + ": " + msg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public byte[] getSmallFileData(int id) throws IOException {
        return this.namesystem.getSmallFileData(id);
    }

    private void verifyRequest(NodeRegistration nodeReg) throws IOException {
        String id = nodeReg.getRegistrationID();
        String expectedID = this.namesystem.getRegistrationID();
        if (!expectedID.equals(id)) {
            LOG.warn("Registration IDs mismatched: the " + nodeReg.getClass().getSimpleName() + " ID is " + id + " but the expected ID is " + expectedID);
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        this.checkNNStartup();
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        }
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName());
        Groups.getUserToGroupsMappingService().refresh();
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info("Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public void refreshCallQueue() {
        LOG.info("Refreshing call queue.");
        Configuration conf = new Configuration();
        this.clientRpcServer.refreshCallQueue(conf);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshCallQueue(conf);
        }
    }

    @Override
    public Collection<RefreshResponse> refresh(String identifier, String[] args) {
        return RefreshRegistry.defaultRegistry().dispatch(identifier, args);
    }

    @Override
    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting groups for user " + user);
        }
        return UserGroupInformation.createRemoteUser(user).getGroupNames();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsConstants.NAMENODE_LAYOUT_VERSION) {
            throw new IncorrectVersionException(HdfsConstants.NAMENODE_LAYOUT_VERSION, version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException, IOException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions(dnVersion, this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn(ive.getMessage() + " DN: " + dnReg);
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = StorageInfo.getStorageInfoFromDB().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn(ive.toString(), (Throwable)ive);
                throw ive;
            }
            LOG.info(messagePrefix + ". Note: This is normal during a rolling upgrade.");
        }
    }

    private static String getClientMachine() {
        String clientMachine = NamenodeWebHdfsMethods.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = Server.getRemoteAddress();
        }
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    @Override
    public SortedActiveNodeList getActiveNamenodes() throws IOException {
        return this.nn.getActiveNameNodes();
    }

    @Override
    public ActiveNode getNextNamenodeToSendBlockReport(long noOfBlks, DatanodeRegistration nodeReg) throws IOException {
        this.verifyRequest(nodeReg);
        return this.nn.getNextNamenodeToSendBlockReport(noOfBlks, nodeReg);
    }

    @Override
    public void blockReportCompleted(DatanodeRegistration nodeReg, DatanodeStorage[] storages, boolean success) throws IOException {
        this.namesystem.getBlockManager().blockReportCompleted(nodeReg, storages, success);
    }

    @Override
    public void ping() throws IOException {
    }

    @Override
    public SortedActiveNodeList getActiveNamenodesForClient() throws IOException {
        return this.nn.getActiveNameNodes();
    }

    @Override
    public void changeConf(List<String> props, List<String> newVals) throws IOException {
        this.namesystem.changeConf(props, newVals);
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, EncodingPolicy policy) throws IOException {
        this.checkNNStartup();
        HdfsFileStatus stat = this.create(src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions);
        if (policy != null) {
            if (!this.namesystem.isErasureCodingEnabled()) {
                throw new IOException("Requesting encoding although erasure coding was disabled");
            }
            LOG.info("Create file " + src + " with policy " + policy.toString());
            this.namesystem.addEncodingStatus(src, policy, EncodingStatus.Status.ENCODING_REQUESTED, false);
        }
        return stat;
    }

    @Override
    public EncodingStatus getEncodingStatus(String filePath) throws IOException {
        this.checkNNStartup();
        EncodingStatus status = this.namesystem.getEncodingStatus(filePath);
        if (status.getStatus() == EncodingStatus.Status.DELETED) {
            throw new IOException("Trying to read encoding status of a deleted file");
        }
        return status;
    }

    @Override
    public void encodeFile(String filePath, EncodingPolicy policy) throws IOException {
        this.checkNNStartup();
        if (!this.namesystem.isErasureCodingEnabled()) {
            throw new IOException("Requesting encoding although erasure coding was disabled");
        }
        this.namesystem.addEncodingStatus(filePath, policy, EncodingStatus.Status.COPY_ENCODING_REQUESTED, true);
    }

    @Override
    public void revokeEncoding(String filePath, short replication) throws IOException {
        this.checkNNStartup();
        if (!this.namesystem.isErasureCodingEnabled()) {
            throw new IOException("Requesting revoke although erasure coding was disabled");
        }
        this.namesystem.revokeEncoding(filePath, replication);
    }

    @Override
    public LocatedBlocks getMissingBlockLocations(String filePath) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getMissingBlockLocations(NameNodeRpcServer.getClientMachine(), filePath);
    }

    @Override
    public void addBlockChecksum(String src, int blockIndex, long checksum) throws IOException {
        this.checkNNStartup();
        this.namesystem.addBlockChecksum(src, blockIndex, checksum);
    }

    @Override
    public long getBlockChecksum(String src, int blockIndex) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getBlockChecksum(src, blockIndex);
    }

    @Override
    public LocatedBlock getRepairedBlockLocations(String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getRepairedBlockLocations(NameNodeRpcServer.getClientMachine(), sourcePath, parityPath, block, isParity);
    }

    private void checkNNStartup() throws IOException {
        if (!this.nn.isStarted()) {
            throw new IOException((Object)((Object)this.nn.getRole()) + " still not started");
        }
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkAccess(path, mode);
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.modifyAclEntries(src, aclSpec);
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAclEntries(src, aclSpec);
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeDefaultAcl(src);
    }

    @Override
    public void removeAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAcl(src);
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.setAcl(src, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getAclStatus(src);
    }

    @Override
    public LastUpdatedContentSummary getLastUpdatedContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.checkNNStartup();
        return this.namesystem.getLastUpdatedContentSummary(path);
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        return this.namesystem.addCacheDirective(path, flags);
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        this.namesystem.modifyCacheDirective(directive, flags);
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeCacheDirective(id);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.checkNNStartup();
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        return this.namesystem.listCacheDirectives(prevId, filter);
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.addCachePool(info);
    }

    @Override
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.modifyCachePool(info);
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeCachePool(cachePoolName);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listCachePools(prevKey != null ? prevKey : "");
    }

    @Override
    public void addUser(String userName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.addUser(userName);
    }

    @Override
    public void addGroup(String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.addGroup(groupName);
    }

    @Override
    public void addUserToGroup(String userName, String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.addUserToGroup(userName, groupName);
    }

    @Override
    public void removeUser(String userName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.removeUser(userName);
    }

    @Override
    public void removeGroup(String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.removeGroup(groupName);
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.removeUserFromGroup(userName, groupName);
    }

    @Override
    public void invCachesUserRemoved(String userName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.invCacheUserRemoved(userName);
    }

    @Override
    public void invCachesGroupRemoved(String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.invCacheGroupRemoved(groupName);
    }

    @Override
    public void invCachesUserRemovedFromGroup(String userName, String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.invCacheUserRemovedFromGroup(userName, groupName);
    }

    @Override
    public void invCachesUserAddedToGroup(String userName, String groupName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        UsersGroups.invCacheUserAddedToGroup(userName, groupName);
    }

    @Override
    public long getEpochMS() throws IOException {
        return System.currentTimeMillis();
    }

    @Override
    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.listSpanReceivers();
    }

    @Override
    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.addSpanReceiver(info);
    }

    @Override
    public void removeSpanReceiver(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.nn.tracerConfigurationManager.removeSpanReceiver(id);
    }

    @Override
    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.namesystem.createEncryptionZone(src, keyName);
    }

    @Override
    public EncryptionZone getEZForPath(String src) throws IOException {
        return this.namesystem.getEZForPath(src);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        return this.namesystem.listEncryptionZones(prevId);
    }

    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.namesystem.setXAttr(src, xAttr, flag);
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        return this.namesystem.getXAttrs(src, xAttrs);
    }

    @Override
    public List<XAttr> listXAttrs(String src) throws IOException {
        return this.namesystem.listXAttrs(src);
    }

    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.namesystem.removeXAttr(src, xAttr);
    }

    @VisibleForTesting
    void setFSNamesystem(FSNamesystem fsn) {
        this.namesystem = fsn;
    }
}

