/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.leaderElection.LeaderElection;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Daemon;

public class MDCleaner {
    public static final Log LOG = LogFactory.getLog(MDCleaner.class);
    private boolean run = false;
    private LeaderElection leaderElection;
    private List<LeDescriptor.FailedNodeLeDescriptor> failedNodes;
    private Daemon mdCleaner;
    private long stoTableCleanDelay = 0L;
    private FSNamesystem namesystem;

    public static MDCleaner getInstance() {
        return new MDCleaner();
    }

    private void clearLocks() throws IOException {
        LOG.debug((Object)("Cleaning STO Locks. Pending Locks: " + this.failedNodes.size()));
        Iterator<LeDescriptor.FailedNodeLeDescriptor> iterator = this.failedNodes.iterator();
        while (iterator.hasNext()) {
            LeDescriptor.FailedNodeLeDescriptor descriptor = iterator.next();
            if (System.currentTimeMillis() - descriptor.getFailTime() <= this.stoTableCleanDelay) continue;
            iterator.remove();
            Collection<SubTreeOperation> ops = this.getPaths(descriptor.getId());
            LOG.debug((Object)("Cleaning STO Lock for NN: " + descriptor + " No of stale locks: " + ops.size()));
            for (SubTreeOperation op : ops) {
                this.namesystem.unlockSubtree(op.getPath(), -1L);
            }
        }
        Collection<SubTreeOperation> ops = this.getPathsToRecoverAsync();
        for (SubTreeOperation op : ops) {
            LOG.info((Object)("Cleaning STO Lock. OP = {" + op + "}"));
            this.namesystem.unlockSubtree(op.getPath(), op.getInodeID());
        }
    }

    Collection<SubTreeOperation> getPaths(final long nnID) throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler(HDFSOperationType.MDCLEANER){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allOpsByNN(nnID);
            }
        };
        return (Collection)subTreeLockChecker.handle();
    }

    Collection<SubTreeOperation> getPathsToRecoverAsync() throws IOException {
        LightWeightRequestHandler subTreeLockChecker = new LightWeightRequestHandler(HDFSOperationType.MDCLEANER){

            public Object performTask() throws IOException {
                OngoingSubTreeOpsDataAccess da = (OngoingSubTreeOpsDataAccess)HdfsStorageFactory.getDataAccess(OngoingSubTreeOpsDataAccess.class);
                return da.allOpsToRecoverAsync();
            }
        };
        return (Collection)subTreeLockChecker.handle();
    }

    void startMDCleanerMonitor(FSNamesystem namesystem, LeaderElection leaderElection, long stoTableCleanDelay) {
        this.leaderElection = leaderElection;
        this.failedNodes = new ArrayList<LeDescriptor.FailedNodeLeDescriptor>();
        this.stoTableCleanDelay = stoTableCleanDelay;
        this.namesystem = namesystem;
        this.run = true;
        this.mdCleaner = new Daemon(new Monitor());
        this.mdCleaner.start();
    }

    void stopMDCleanerMonitor() {
        if (this.mdCleaner != null) {
            this.run = false;
            LOG.debug((Object)"Shutting down metadata cleaner ");
            try {
                this.mdCleaner.interrupt();
                this.mdCleaner.join(3000L);
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)"Encountered exception ", (Throwable)ie);
            }
            this.mdCleaner = null;
        }
    }

    class Monitor
    implements Runnable {
        Monitor() {
        }

        @Override
        public void run() {
            while (MDCleaner.this.run) {
                try {
                    if (MDCleaner.this.leaderElection.isRunning()) {
                        MDCleaner.this.failedNodes.addAll(MDCleaner.this.leaderElection.getDeadNodes());
                    }
                    MDCleaner.this.clearLocks();
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Metadata Cleaner Interrupted");
                }
                catch (IOException e) {
                    LOG.warn((Object)e, (Throwable)e);
                }
            }
        }
    }
}

