/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.tools.TableListing;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;

@InterfaceAudience.Private
public class CryptoAdmin
extends Configured
implements Tool {
    private static final int MAX_LINE_WIDTH = 80;
    private static final Command[] COMMANDS = new Command[]{new CreateZoneCommand(), new ListZonesCommand(), new HelpCommand()};

    public CryptoAdmin() {
        this(null);
    }

    public CryptoAdmin(Configuration conf) {
        super(conf);
    }

    @Override
    public int run(String[] args) throws IOException {
        if (args.length == 0) {
            CryptoAdmin.printUsage(false);
            return 1;
        }
        Command command = CryptoAdmin.determineCommand(args[0]);
        if (command == null) {
            System.err.println("Can't understand command '" + args[0] + "'");
            if (!args[0].startsWith("-")) {
                System.err.println("Command names must start with dashes.");
            }
            CryptoAdmin.printUsage(false);
            return 1;
        }
        LinkedList<String> argsList = new LinkedList<String>();
        for (int j = 1; j < args.length; ++j) {
            argsList.add(args[j]);
        }
        try {
            return command.run(this.getConf(), argsList);
        }
        catch (IllegalArgumentException e) {
            System.err.println(CryptoAdmin.prettifyException(e));
            return -1;
        }
    }

    public static void main(String[] argsArray) throws IOException {
        CryptoAdmin cryptoAdmin = new CryptoAdmin(new Configuration());
        System.exit(cryptoAdmin.run(argsArray));
    }

    private static DistributedFileSystem getDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get(conf);
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException("FileSystem " + fs.getUri() + " is not an HDFS file system");
        }
        return (DistributedFileSystem)fs;
    }

    private static String prettifyException(Exception e) {
        return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage().split("\n")[0];
    }

    private static TableListing getOptionDescriptionListing() {
        TableListing listing = new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
        return listing;
    }

    private static void printUsage(boolean longUsage) {
        System.err.println("Usage: bin/hdfs crypto [COMMAND]");
        for (Command command : COMMANDS) {
            if (longUsage) {
                System.err.print(command.getLongUsage());
                continue;
            }
            System.err.print("          " + command.getShortUsage());
        }
        System.err.println();
    }

    private static Command determineCommand(String commandName) {
        for (int i = 0; i < COMMANDS.length; ++i) {
            if (!COMMANDS[i].getName().equals(commandName)) continue;
            return COMMANDS[i];
        }
        return null;
    }

    private static class HelpCommand
    implements Command {
        private HelpCommand() {
        }

        @Override
        public String getName() {
            return "-help";
        }

        @Override
        public String getShortUsage() {
            return "[-help <command-name>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = CryptoAdmin.getOptionDescriptionListing();
            listing.addRow("<command-name>", "The command for which to get detailed help. If no command is specified, print detailed help for all commands");
            return this.getShortUsage() + "\nGet detailed help about a command.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (args.size() == 0) {
                for (Command command : COMMANDS) {
                    System.err.println(command.getLongUsage());
                }
                return 0;
            }
            if (args.size() != 1) {
                System.out.println("You must give exactly one argument to -help.");
                return 0;
            }
            String commandName = args.get(0);
            Command command = CryptoAdmin.determineCommand("-" + commandName);
            if (command == null) {
                System.err.print("Sorry, I don't know the command '" + commandName + "'.\n");
                System.err.print("Valid help command names are:\n");
                String separator = "";
                for (Command c : COMMANDS) {
                    System.err.print(separator + c.getName().substring(1));
                    separator = ", ";
                }
                System.err.print("\n");
                return 1;
            }
            System.err.print(command.getLongUsage());
            return 0;
        }
    }

    private static class ListZonesCommand
    implements Command {
        private ListZonesCommand() {
        }

        @Override
        public String getName() {
            return "-listZones";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + "]\n";
        }

        @Override
        public String getLongUsage() {
            return this.getShortUsage() + "\nList all encryption zones. Requires superuser permissions.\n\n";
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            DistributedFileSystem dfs = CryptoAdmin.getDFS(conf);
            try {
                TableListing listing = new TableListing.Builder().addField("").addField("", true).wrapWidth(80).hideHeaders().build();
                RemoteIterator<EncryptionZone> it = dfs.listEncryptionZones();
                while (it.hasNext()) {
                    EncryptionZone ez = it.next();
                    listing.addRow(ez.getPath(), ez.getKeyName());
                }
                System.out.println(listing.toString());
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    private static class CreateZoneCommand
    implements Command {
        private CreateZoneCommand() {
        }

        @Override
        public String getName() {
            return "-createZone";
        }

        @Override
        public String getShortUsage() {
            return "[" + this.getName() + " -keyName <keyName> -path <path>]\n";
        }

        @Override
        public String getLongUsage() {
            TableListing listing = CryptoAdmin.getOptionDescriptionListing();
            listing.addRow("<path>", "The path of the encryption zone to create. It must be an empty directory.");
            listing.addRow("<keyName>", "Name of the key to use for the encryption zone.");
            return this.getShortUsage() + "\nCreate a new encryption zone.\n\n" + listing.toString();
        }

        @Override
        public int run(Configuration conf, List<String> args) throws IOException {
            String path = StringUtils.popOptionWithArgument("-path", args);
            if (path == null) {
                System.err.println("You must specify a path with -path.");
                return 1;
            }
            String keyName = StringUtils.popOptionWithArgument("-keyName", args);
            if (keyName == null) {
                System.err.println("You must specify a key name with -keyName.");
                return 1;
            }
            if (!args.isEmpty()) {
                System.err.println("Can't understand argument: " + args.get(0));
                return 1;
            }
            DistributedFileSystem dfs = CryptoAdmin.getDFS(conf);
            try {
                dfs.createEncryptionZone(new Path(path), keyName);
                System.out.println("Added encryption zone " + path);
            }
            catch (IOException e) {
                System.err.println(CryptoAdmin.prettifyException(e));
                return 2;
            }
            return 0;
        }
    }

    static interface Command {
        public String getName();

        public String getShortUsage();

        public String getLongUsage();

        public int run(Configuration var1, List<String> var2) throws IOException;
    }
}

