/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.AbstractFileTree;
import org.apache.hadoop.hdfs.server.namenode.FSDirDeleteOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirXAttrOp;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.PathInformation;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.util.ChunkedArrayList;
import org.apache.hadoop.util.Time;

class FSDirRenameOp {
    public static final Log LOG = LogFactory.getLog(FSDirRenameOp.class);

    FSDirRenameOp() {
    }

    @Deprecated
    static boolean renameToInt(FSDirectory fsd, String srcArg, String dstArg) throws IOException {
        String src = srcArg;
        String dst = dstArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: " + src + " to " + dst);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        Object resultingStat = null;
        src = fsd.resolvePath(pc, src, srcComponents);
        dst = fsd.resolvePath(pc, dst, dstComponents);
        boolean status = FSDirRenameOp.renameTo(fsd, pc, src, dst);
        return status;
    }

    static void verifyQuotaForRename(FSDirectory fsd, INodesInPath src, INodesInPath dst, QuotaCounts srcCounts, QuotaCounts dstCounts) throws QuotaExceededException, StorageException, TransactionContextException {
        if (!fsd.getFSNamesystem().isImageLoaded() || !fsd.isQuotaEnabled()) {
            return;
        }
        INode commonAncestor = null;
        int i = 0;
        while (src.getINode(i).equals(dst.getINode(i))) {
            commonAncestor = src.getINode(i);
            ++i;
        }
        QuotaCounts delta = new QuotaCounts.Builder().quotaCount(srcCounts).build();
        INode dstINode = dst.getLastINode();
        if (dstINode != null) {
            delta.subtract(dstCounts);
        }
        FSDirectory.verifyQuota(dst, dst.length() - 1, delta, commonAncestor);
    }

    static void verifyFsLimitsForRename(FSDirectory fsd, INodesInPath srcIIP, INodesInPath dstIIP) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException, StorageException, TransactionContextException {
        byte[] dstChildName = dstIIP.getLastLocalName();
        String parentPath = dstIIP.getParentPath();
        fsd.verifyMaxComponentLength(dstChildName, parentPath);
        if (!srcIIP.getINode(-2).equals(dstIIP.getINode(-2))) {
            fsd.verifyMaxDirItems(dstIIP.getINode(-2).asDirectory(), parentPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static boolean renameForEditLog(FSDirectory fsd, String src, String dst, long timestamp) throws IOException {
        INodesInPath dstIIP;
        PathInformation srcInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(src, false, null, FsAction.WRITE, null, null);
        INodesInPath srcIIP = srcInfo.getINodesInPath();
        INode srcInode = srcIIP.getLastINode();
        try {
            FSDirRenameOp.validateRenameSource(srcIIP);
        }
        catch (IOException ignored) {
            return false;
        }
        PathInformation dstInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(dst, false, FsAction.WRITE, null, null, null);
        boolean updateDst = false;
        if (dstInfo.isDir()) {
            dst = dst + "/" + new Path(src).getName();
            updateDst = true;
        }
        if (dst.equals(src)) {
            return true;
        }
        try {
            FSDirRenameOp.validateDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return false;
        }
        if (updateDst) {
            dstInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(dst, false, FsAction.WRITE, null, null, null);
        }
        if ((dstIIP = dstInfo.getINodesInPath()).getLastINode() != null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists");
            return false;
        }
        INode dstParent = dstIIP.getINode(-2);
        if (dstParent == null) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist");
            return false;
        }
        INode srcDataSet = FSDirRenameOp.getMetaEnabledParent(srcInfo.getINodesInPath().getReadOnlyINodes());
        INode dstDataSet = FSDirRenameOp.getMetaEnabledParent(dstInfo.getINodesInPath().getReadOnlyINodes());
        Collection<Object> logEntries = Collections.EMPTY_LIST;
        QuotaCounts srcCounts = new QuotaCounts.Builder().quotaCount(srcInfo.getUsage()).build();
        QuotaCounts dstCounts = new QuotaCounts.Builder().quotaCount(dstInfo.getUsage()).build();
        boolean isUsingSubTreeLocks = srcInfo.isDir();
        boolean renameTransactionCommitted = false;
        INodeIdentifier srcSubTreeRoot = null;
        try {
            if (isUsingSubTreeLocks) {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " requires sub-tree locking mechanism"));
                srcSubTreeRoot = fsd.getFSNamesystem().lockSubtreeAndCheckOwnerAndParentPermission(src, false, FsAction.WRITE, SubTreeOperation.Type.RENAME_STO);
                if (srcSubTreeRoot != null) {
                    AbstractFileTree.QuotaCountingFileTree srcFileTree;
                    if (FSDirRenameOp.shouldLogSubtreeInodes(srcInfo, dstInfo, srcDataSet, dstDataSet, srcSubTreeRoot)) {
                        srcFileTree = new AbstractFileTree.LoggingQuotaCountingFileTree(fsd.getFSNamesystem(), srcSubTreeRoot, srcDataSet, dstDataSet);
                        srcFileTree.buildUp(fsd.getBlockStoragePolicySuite());
                        logEntries = ((AbstractFileTree.LoggingQuotaCountingFileTree)srcFileTree).getMetadataLogEntries();
                    } else {
                        srcFileTree = new AbstractFileTree.QuotaCountingFileTree(fsd.getFSNamesystem(), srcSubTreeRoot);
                        srcFileTree.buildUp(fsd.getBlockStoragePolicySuite());
                    }
                    srcCounts = new QuotaCounts.Builder().quotaCount(srcFileTree.getQuotaCount()).build();
                }
                fsd.getFSNamesystem().delayAfterBbuildingTree("Built tree of " + src + " for rename. ");
            } else {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " does not require sub-tree locking mechanism"));
            }
            boolean retValue = FSDirRenameOp.renameToTransaction(fsd, src, srcSubTreeRoot != null ? srcSubTreeRoot.getInodeId() : 0L, dst, srcCounts, dstCounts, isUsingSubTreeLocks, logEntries, timestamp);
            renameTransactionCommitted = true;
            boolean bl = retValue;
            return bl;
        }
        finally {
            if (!renameTransactionCommitted && srcSubTreeRoot != null) {
                fsd.getFSNamesystem().unlockSubtree(src, srcSubTreeRoot.getInodeId());
            }
        }
    }

    private static boolean renameToTransaction(final FSDirectory fsd, final String src, final long srcINodeID, final String dst, final QuotaCounts srcCounts, final QuotaCounts dstCounts, final boolean isUsingSubTreeLocks, final Collection<INodeMetadataLogEntry> logEntries, final long timestamp) throws IOException {
        HopsTransactionalRequestHandler renameToHandler = new HopsTransactionalRequestHandler(isUsingSubTreeLocks ? HDFSOperationType.SUBTREE_DEPRICATED_RENAME : HDFSOperationType.DEPRICATED_RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getLegacyRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                if (isUsingSubTreeLocks) {
                    il.setIgnoredSTOInodes(srcINodeID);
                }
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.UC, LockFactory.BLK.IV, LockFactory.BLK.CR, LockFactory.BLK.ER, LockFactory.BLK.PE, LockFactory.BLK.UR));
                if (!isUsingSubTreeLocks) {
                    locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED));
                } else {
                    locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.READ_COMMITTED, fsd.getFSNamesystem().getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED, src)).add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getSubTreeLockPathPrefix(src), false));
                }
                if (fsd.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src, dst));
                }
                locks.add(lf.getEZLock());
                locks.add(lf.getXAttrLock(FSDirXAttrOp.XATTR_ENCRYPTION_ZONE));
                locks.add(lf.getAcesLock());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                INodesInPath dstIIP = fsd.getINodesInPath(dst, false);
                INodesInPath srcIIP = fsd.getINodesInPath(src, false);
                if (!isUsingSubTreeLocks && fsd.isPermissionEnabled()) {
                    FSPermissionChecker pc = fsd.getFSNamesystem().getPermissionChecker();
                    fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
                    fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
                }
                FSDirRenameOp.removeSubTreeLocksForRenameInternal(fsd, src, isUsingSubTreeLocks);
                for (INodeMetadataLogEntry logEntry : logEntries) {
                    EntityManager.add((Object)logEntry);
                }
                AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
                fsd.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
                FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
                FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP, srcCounts, dstCounts);
                RenameOperation tx = new RenameOperation(fsd, src, dst, srcIIP, dstIIP, srcCounts, dstCounts);
                boolean added = false;
                try {
                    if (!tx.removeSrc4OldRename()) {
                        Boolean bl = false;
                        return bl;
                    }
                    added = tx.addSourceToDestination();
                    if (added) {
                        if (NameNode.stateChangeLog.isDebugEnabled()) {
                            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                        }
                        tx.updateMtimeAndLease(timestamp);
                        tx.updateQuotasInSourceTree(fsd.getBlockStoragePolicySuite());
                        tx.logMetadataEvent();
                        tx.snapshotMaintenance();
                        Boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (!added) {
                        tx.restoreSource();
                    }
                }
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
                return false;
            }
        };
        return (Boolean)renameToHandler.handle();
    }

    static Map.Entry<INode.BlocksMapUpdateInfo, HdfsFileStatus> renameToInt(FSDirectory fsd, String srcArg, String dstArg, Options.Rename ... options) throws IOException {
        String src = srcArg;
        String dst = dstArg;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.renameTo: with options - " + src + " to " + dst);
        }
        if (!DFSUtil.isValidName(dst)) {
            throw new InvalidPathException("Invalid name: " + dst);
        }
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] srcComponents = FSDirectory.getPathComponentsForReservedPath(src);
        byte[][] dstComponents = FSDirectory.getPathComponentsForReservedPath(dst);
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        src = fsd.resolvePath(pc, src, srcComponents);
        dst = fsd.resolvePath(pc, dst, dstComponents);
        HdfsFileStatus resultingStat = FSDirRenameOp.renameTo(fsd, pc, src, dst, collectedBlocks, options);
        return new AbstractMap.SimpleImmutableEntry<INode.BlocksMapUpdateInfo, HdfsFileStatus>(collectedBlocks, resultingStat);
    }

    static HdfsFileStatus renameTo(FSDirectory fsd, FSPermissionChecker pc, String src, String dst, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        long mtime = Time.now();
        RenameResult ret = FSDirRenameOp.unprotectedRenameTo(fsd, src, dst, mtime, collectedBlocks, options);
        if (ret.filesDeleted) {
            FSDirDeleteOp.incrDeletedFileCount(1L);
        }
        return ret.auditStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RenameResult unprotectedRenameTo(FSDirectory fsd, String src, String dst, long timestamp, INode.BlocksMapUpdateInfo collectedBlocks, Options.Rename ... options) throws IOException {
        INode dstParent;
        boolean overwrite = options != null && Arrays.asList(options).contains((Object)Options.Rename.OVERWRITE);
        PathInformation srcInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(src, false, null, FsAction.WRITE, null, null);
        INodesInPath srcIIP = srcInfo.getINodesInPath();
        INode srcInode = srcIIP.getLastINode();
        FSDirRenameOp.validateRenameSource(srcIIP);
        if (dst.equals(src)) {
            throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
        }
        FSDirRenameOp.validateDestination(src, dst, srcInode);
        PathInformation dstInfo = fsd.getFSNamesystem().getPathExistingINodesFromDB(dst, false, FsAction.WRITE, null, null, null);
        INodesInPath dstIIP = dstInfo.getINodesInPath();
        if (dstIIP.length() == 1) {
            String error = "rename destination cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        INode dstInode = dstIIP.getLastINode();
        if (dstInode != null) {
            FSDirRenameOp.validateOverwrite(fsd, src, dst, overwrite, srcInode, dstInode, dstInfo);
        }
        if ((dstParent = dstIIP.getINode(-2)) == null) {
            String error = "rename destination parent " + dst + " not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (!dstParent.isDirectory()) {
            String error = "rename destination parent " + dst + " is a file.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new ParentNotDirectoryException(error);
        }
        INode srcDataSet = FSDirRenameOp.getMetaEnabledParent(srcInfo.getINodesInPath().getReadOnlyINodes());
        INode dstDataSet = FSDirRenameOp.getMetaEnabledParent(dstInfo.getINodesInPath().getReadOnlyINodes());
        Collection<Object> logEntries = Collections.EMPTY_LIST;
        QuotaCounts srcCounts = new QuotaCounts.Builder().quotaCount(srcInfo.getUsage()).build();
        QuotaCounts dstCounts = new QuotaCounts.Builder().quotaCount(dstInfo.getUsage()).build();
        boolean isUsingSubTreeLocks = srcInfo.isDir();
        boolean renameTransactionCommitted = false;
        INodeIdentifier srcSubTreeRoot = null;
        try {
            if (isUsingSubTreeLocks) {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " requires sub-tree locking mechanism"));
                srcSubTreeRoot = fsd.getFSNamesystem().lockSubtreeAndCheckOwnerAndParentPermission(src, false, FsAction.WRITE, SubTreeOperation.Type.RENAME_STO);
                if (srcSubTreeRoot != null) {
                    AbstractFileTree.QuotaCountingFileTree srcFileTree;
                    if (FSDirRenameOp.shouldLogSubtreeInodes(srcInfo, dstInfo, srcDataSet, dstDataSet, srcSubTreeRoot)) {
                        srcFileTree = new AbstractFileTree.LoggingQuotaCountingFileTree(fsd.getFSNamesystem(), srcSubTreeRoot, srcDataSet, dstDataSet);
                        srcFileTree.buildUp(fsd.getBlockStoragePolicySuite());
                        logEntries = ((AbstractFileTree.LoggingQuotaCountingFileTree)srcFileTree).getMetadataLogEntries();
                    } else {
                        srcFileTree = new AbstractFileTree.QuotaCountingFileTree(fsd.getFSNamesystem(), srcSubTreeRoot);
                        srcFileTree.buildUp(fsd.getBlockStoragePolicySuite());
                    }
                    srcCounts = new QuotaCounts.Builder().quotaCount(srcFileTree.getQuotaCount()).build();
                    fsd.getFSNamesystem().delayAfterBbuildingTree("Built Tree for " + src + " for rename. ");
                } else {
                    isUsingSubTreeLocks = false;
                }
            } else {
                LOG.debug((Object)("Rename src: " + src + " dst: " + dst + " does not require sub-tree locking mechanism"));
            }
            RenameResult ret = FSDirRenameOp.renameToTransaction(fsd, src, srcSubTreeRoot != null ? srcSubTreeRoot.getInodeId() : 0L, dst, srcCounts, dstCounts, isUsingSubTreeLocks, logEntries, timestamp, options);
            renameTransactionCommitted = true;
            RenameResult renameResult = ret;
            return renameResult;
        }
        finally {
            if (!renameTransactionCommitted && srcSubTreeRoot != null) {
                fsd.getFSNamesystem().unlockSubtree(src, srcSubTreeRoot.getInodeId());
            }
        }
    }

    private static RenameResult renameToTransaction(final FSDirectory fsd, final String src, final long srcINodeID, final String dst, final QuotaCounts srcCounts, final QuotaCounts dstCounts, final boolean isUsingSubTreeLocks, final Collection<INodeMetadataLogEntry> logEntries, final long timestamp, final Options.Rename ... options) throws IOException {
        return (RenameResult)new HopsTransactionalRequestHandler(isUsingSubTreeLocks ? HDFSOperationType.SUBTREE_RENAME : HDFSOperationType.RENAME, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getRenameINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src, dst).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes());
                if (isUsingSubTreeLocks) {
                    il.setIgnoredSTOInodes(srcINodeID);
                }
                locks.add((Lock)il).add(lf.getBlockLock()).add(lf.getBlockRelated(LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV, LockFactory.BLK.PE, LockFactory.BLK.ER));
                if (fsd.isQuotaEnabled()) {
                    locks.add(lf.getQuotaUpdateLock(true, src, dst));
                }
                if (!isUsingSubTreeLocks) {
                    locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED));
                } else {
                    locks.add(lf.getLeaseLockAllPaths(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getLeaseCreationLockRows())).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE, src)).add(lf.getSubTreeOpsLock(TransactionLockTypes.LockType.WRITE, fsd.getFSNamesystem().getSubTreeLockPathPrefix(src), false));
                }
                if (fsd.getFSNamesystem().isErasureCodingEnabled()) {
                    locks.add(lf.getEncodingStatusLock(TransactionLockTypes.LockType.WRITE, dst));
                }
                locks.add(lf.getAcesLock());
                for (Options.Rename op : options) {
                    if (op != Options.Rename.OVERWRITE) continue;
                    locks.add(lf.getAllUsedHashBucketsLock());
                }
                locks.add(lf.getEZLock());
                ArrayList<XAttr> xAttrsToLock = new ArrayList<XAttr>();
                xAttrsToLock.add(FSDirXAttrOp.XATTR_FILE_ENCRYPTION_INFO);
                xAttrsToLock.add(FSDirXAttrOp.XATTR_ENCRYPTION_ZONE);
                locks.add(lf.getXAttrLock(xAttrsToLock));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                INodesInPath dstIIP = fsd.getINodesInPath(dst, false);
                INodesInPath srcIIP = fsd.getINodesInPath(src, false);
                fsd.ezManager.checkMoveValidity(srcIIP, dstIIP, src);
                if (!isUsingSubTreeLocks && fsd.isPermissionEnabled()) {
                    FSPermissionChecker pc = fsd.getFSNamesystem().getPermissionChecker();
                    fsd.checkPermission(pc, srcIIP, false, null, FsAction.WRITE, null, null, false);
                    fsd.checkPermission(pc, dstIIP, false, FsAction.WRITE, null, null, null, false);
                }
                for (Options.Rename[] logEntry : logEntries) {
                    EntityManager.add((Object)logEntry);
                }
                AbstractFileTree.LoggingQuotaCountingFileTree.updateLogicalTime(logEntries);
                BlockStoragePolicySuite bsps = fsd.getBlockStoragePolicySuite();
                for (Options.Rename op : options) {
                    if (op != Options.Rename.KEEP_ENCODING_STATUS) continue;
                    INodesInPath srcInodesInPath = fsd.getINodesInPath(src, false);
                    INodesInPath dstInodesInPath = fsd.getINodesInPath(dst, false);
                    INode srcNode = srcIIP.getLastINode();
                    INode dstNode = dstIIP.getLastINode();
                    EncodingStatus status = (EncodingStatus)EntityManager.find((FinderType)EncodingStatus.Finder.ByInodeId, (Object[])new Object[]{dstNode.getId()});
                    EncodingStatus newStatus = new EncodingStatus(status);
                    newStatus.setInodeId(Long.valueOf(srcNode.getId()), srcNode.isInTree());
                    EntityManager.add((Object)newStatus);
                    EntityManager.remove((Object)status);
                    break;
                }
                if (isUsingSubTreeLocks) {
                    FSDirRenameOp.removeSubTreeLocksForRenameInternal(fsd, src, isUsingSubTreeLocks);
                }
                FSDirRenameOp.verifyFsLimitsForRename(fsd, srcIIP, dstIIP);
                FSDirRenameOp.verifyQuotaForRename(fsd, srcIIP, dstIIP, srcCounts, dstCounts);
                RenameOperation tx = new RenameOperation(fsd, src, dst, srcIIP, dstIIP, srcCounts, dstCounts);
                boolean undoRemoveSrc = true;
                tx.removeSrc();
                boolean undoRemoveDst = false;
                long removedNum = 0L;
                try {
                    if (dstIIP.getLastINode() != null && (removedNum = tx.removeDst()) != -1L) {
                        undoRemoveDst = true;
                    }
                    if (tx.addSourceToDestination()) {
                        undoRemoveSrc = false;
                        if (NameNode.stateChangeLog.isDebugEnabled()) {
                            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst);
                        }
                        tx.updateMtimeAndLease(timestamp);
                        boolean filesDeleted = false;
                        if (undoRemoveDst) {
                            undoRemoveDst = false;
                            if (removedNum > 0L) {
                                filesDeleted = tx.cleanDst(bsps);
                            }
                        }
                        if (!undoRemoveSrc && !undoRemoveDst) {
                            tx.logMetadataEvent();
                        }
                        tx.snapshotMaintenance();
                        tx.updateQuotasInSourceTree(bsps);
                        HdfsFileStatus auditStat = fsd.getAuditFileInfo(dstIIP);
                        RenameResult renameResult = new RenameResult(filesDeleted, auditStat);
                        return renameResult;
                    }
                }
                finally {
                    if (undoRemoveSrc) {
                        tx.restoreSource();
                    }
                    if (undoRemoveDst) {
                        tx.restoreDst();
                    }
                }
                NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst);
                throw new IOException("rename from " + src + " to " + dst + " failed.");
            }
        }.handle();
    }

    @Deprecated
    private static boolean renameTo(FSDirectory fsd, FSPermissionChecker pc, String src, String dst) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.renameTo: " + src + " to " + dst);
        }
        long mtime = Time.now();
        boolean stat = false;
        stat = FSDirRenameOp.renameForEditLog(fsd, src, dst, mtime);
        return stat;
    }

    private static void validateDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateOverwrite(FSDirectory fsd, String src, String dst, boolean overwrite, INode srcInode, INode dstInode, PathInformation dstInfo) throws IOException {
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileAlreadyExistsException(error);
        }
        short depth = (short)(0 + dstInfo.getINodesInPath().length() - 1);
        boolean areChildrenRandomlyPartitioned = INode.isTreeLevelRandomPartitioned(depth);
        if (dstInode.isDirectory() && fsd.hasChildren(dstInode.getId(), areChildrenRandomlyPartitioned)) {
            String error = "rename destination directory is not empty: " + dst;
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(INodesInPath srcIIP) throws IOException {
        INode srcInode = srcIIP.getLastINode();
        if (srcInode == null) {
            String error = "rename source " + srcIIP.getPath() + " is not found.";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new FileNotFoundException(error);
        }
        if (srcIIP.length() == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedRenameTo: " + error);
            throw new IOException(error);
        }
    }

    private static INode getMetaEnabledParent(List<INode> pathComponents) {
        for (INode node : pathComponents) {
            INodeDirectory dir;
            if (node == null || !node.isDirectory() || !(dir = (INodeDirectory)node).isMetaEnabled()) continue;
            return dir;
        }
        return null;
    }

    private static boolean shouldLogSubtreeInodes(PathInformation srcInfo, PathInformation dstInfo, INode srcDataSet, INode dstDataSet, INodeIdentifier srcSubTreeRoot) {
        if (FSDirRenameOp.pathIsMetaEnabled(srcInfo.getINodesInPath().getReadOnlyINodes()) || FSDirRenameOp.pathIsMetaEnabled(dstInfo.getINodesInPath().getReadOnlyINodes())) {
            if (srcDataSet == null) {
                if (dstDataSet != null) {
                    return true;
                }
            } else {
                if (dstDataSet == null) {
                    return !srcDataSet.equalsIdentifier(srcSubTreeRoot);
                }
                return !srcDataSet.equals(dstDataSet);
            }
        }
        return false;
    }

    private static boolean pathIsMetaEnabled(List<INode> pathComponents) {
        return FSDirRenameOp.getMetaEnabledParent(pathComponents) != null;
    }

    private static void removeSubTreeLocksForRenameInternal(FSDirectory fsd, String src, boolean isUsingSubTreeLocks) throws StorageException, TransactionContextException, UnresolvedLinkException {
        if (isUsingSubTreeLocks && !src.equals("/")) {
            SubTreeOperation subTreeOp = (SubTreeOperation)EntityManager.find((FinderType)SubTreeOperation.Finder.ByPath, (Object[])new Object[]{fsd.getFSNamesystem().getSubTreeLockPathPrefix(src)});
            EntityManager.remove((Object)subTreeOp);
            INodesInPath inodesInPath = fsd.getINodesInPath(src, false);
            INode inode = inodesInPath.getLastINode();
            if (inode != null && inode.isSTOLocked()) {
                inode.setSubtreeLocked(false);
                EntityManager.update((Object)inode);
            }
        }
    }

    static class RenameResult {
        final boolean filesDeleted;
        final HdfsFileStatus auditStat;

        RenameResult(boolean filesDeleted, HdfsFileStatus auditStat) {
            this.filesDeleted = filesDeleted;
            this.auditStat = auditStat;
        }
    }

    private static class RenameOperation {
        private final FSDirectory fsd;
        private INodesInPath srcIIP;
        private final INodesInPath srcParentIIP;
        private INodesInPath dstIIP;
        private final INodesInPath dstParentIIP;
        private final String src;
        private final String dst;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final QuotaCounts srcCounts;
        private final QuotaCounts dstCounts;
        private INode srcChild;
        private INode oldDstChild;
        private INode srcClone;

        RenameOperation(FSDirectory fsd, String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP, QuotaCounts srcCounts, QuotaCounts dstCounts) throws QuotaExceededException, IOException {
            this.fsd = fsd;
            this.src = src;
            this.dst = dst;
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.srcParentIIP = srcIIP.getParentINodesInPath();
            this.dstParentIIP = dstIIP.getParentINodesInPath();
            this.srcChild = this.srcIIP.getLastINode();
            if (this.srcChild != null) {
                this.srcClone = this.srcChild.cloneInode();
            }
            this.srcChildName = this.srcChild.getLocalNameBytes();
            this.srcParent = this.srcIIP.getINode(-2).asDirectory();
            this.srcCounts = srcCounts;
            this.dstCounts = dstCounts;
        }

        long removeSrc() throws IOException {
            long removedNum = this.fsd.removeLastINode(this.srcIIP, true, this.srcCounts);
            if (removedNum == -1L) {
                String error = "Failed to rename " + this.src + " to " + this.dst + " because the source can not be removed";
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo:" + error);
                throw new IOException(error);
            }
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return removedNum;
        }

        boolean removeSrc4OldRename() throws IOException {
            long removedSrc = this.fsd.removeLastINode(this.srcIIP, true, this.srcCounts);
            if (removedSrc == -1L) {
                NameNode.stateChangeLog.warn("DIR* FSDirRenameOp.unprotectedRenameTo: failed to rename " + this.src + " to " + this.dst + " because the source can not be removed");
                return false;
            }
            this.srcIIP = INodesInPath.replace(this.srcIIP, this.srcIIP.length() - 1, null);
            return true;
        }

        long removeDst() throws IOException {
            long removedNum = this.fsd.removeLastINode(this.dstIIP, false, this.dstCounts);
            if (removedNum != -1L) {
                this.oldDstChild = this.dstIIP.getLastINode();
                this.dstIIP = INodesInPath.replace(this.dstIIP, this.dstIIP.length() - 1, null);
            }
            return removedNum;
        }

        boolean addSourceToDestination() throws IOException {
            INode dstParent = this.dstParentIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            this.srcChild.setLocalNameNoPersistance(dstChildName);
            INode toDst = this.srcChild;
            return this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, toDst, this.srcCounts) != null;
        }

        void updateMtimeAndLease(long timestamp) throws QuotaExceededException, IOException {
            this.srcParent.updateModificationTime(timestamp);
            INode dstParent = this.dstParentIIP.getLastINode();
            dstParent.updateModificationTime(timestamp);
            this.fsd.getFSNamesystem().unprotectedChangeLease(this.src, this.dst);
        }

        void restoreSource() throws QuotaExceededException, IOException {
            this.srcChild.setLocalNameNoPersistance(this.srcChildName);
            this.fsd.addLastINodeNoQuotaCheck(this.srcParentIIP, this.srcChild, this.srcCounts);
        }

        void restoreDst() throws QuotaExceededException, IOException {
            Preconditions.checkState((this.oldDstChild != null ? 1 : 0) != 0);
            this.fsd.addLastINodeNoQuotaCheck(this.dstParentIIP, this.oldDstChild, this.dstCounts);
        }

        boolean cleanDst(BlockStoragePolicySuite bsps) throws QuotaExceededException, IOException {
            Preconditions.checkState((this.oldDstChild != null ? 1 : 0) != 0);
            INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
            ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
            this.oldDstChild.destroyAndCollectBlocks(bsps, collectedBlocks, removedINodes);
            boolean filesDeleted = true;
            this.fsd.getFSNamesystem().removeLeasesAndINodes(this.src, removedINodes);
            this.fsd.getFSNamesystem().removeBlocks(collectedBlocks);
            return filesDeleted;
        }

        void updateQuotasInSourceTree(BlockStoragePolicySuite bsps) throws QuotaExceededException {
        }

        public void logMetadataEvent() throws TransactionContextException, StorageException {
            INodeDirectory srcDataset = this.srcClone.getMetaEnabledParent();
            INodeDirectory dstDataset = this.srcChild.getMetaEnabledParent();
            if (srcDataset == null) {
                if (dstDataset != null) {
                    this.srcChild.logMetadataEvent(INodeMetadataLogEntry.Operation.Add);
                }
            } else if (dstDataset == null) {
                EntityManager.add((Object)new INodeMetadataLogEntry(((INode)srcDataset).getId(), this.srcClone.getId(), this.srcClone.getPartitionId().longValue(), this.srcClone.getParentId(), this.srcClone.getLocalName(), this.srcChild.incrementLogicalTime(), INodeMetadataLogEntry.Operation.Delete));
            } else {
                long partitionId = INode.calculatePartitionId(this.srcChild.getParentId(), this.srcChild.getLocalName(), this.srcChild.myDepth());
                EntityManager.add((Object)new INodeMetadataLogEntry(((INode)dstDataset).getId(), this.srcChild.getId(), partitionId, this.srcChild.getParentId(), this.srcChild.getLocalName(), this.srcChild.incrementLogicalTime(), INodeMetadataLogEntry.Operation.Rename));
            }
        }

        public void snapshotMaintenance() throws TransactionContextException {
            EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.INodePKChanged, (Object[])new Object[]{this.srcClone, this.srcChild});
        }
    }
}

