/*
 * Decompiled with CFR 0.152.
 */
package io.hops.leaderElection.experiments;

import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.hadoop.shaded.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import io.hops.hadoop.shaded.org.kohsuke.args4j.CmdLineException;
import io.hops.hadoop.shaded.org.kohsuke.args4j.CmdLineParser;
import io.hops.hadoop.shaded.org.kohsuke.args4j.Option;
import io.hops.leaderElection.HdfsLeDescriptorFactory;
import io.hops.leaderElection.VarsRegister;
import io.hops.leaderElection.experiments.LightWeightNameNode;
import io.hops.metadata.LEStorageFactory;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.LogManager;

public class Experiment1 {
    private static final Log LOG = LogFactory.getLog(Experiment1.class);
    Configuration conf = null;
    List<LightWeightNameNode> nnList;
    @Option(name="-time_period", usage="Time Period")
    private int time_period = 2000;
    @Option(name="-time_period_increment", usage="Time period increment. stabilization factor")
    private long time_period_increment = 200L;
    @Option(name="-missed_hb_threshold", usage="Missed HB Threshold")
    private int missed_hb_threshold = 2;
    @Option(name="-ndb_jar", usage="NDB Implementation Driver JAR Path")
    private String driver_jar = "/home/salman/NetbeanProjects/hop/hops-metadata-dal-impl-ndb/target/hops-metadata-dal-impl-ndb-1.1-SNAPSHOT-jar-with-dependencies.jar";
    @Option(name="-max_processes", usage="Max number of processes")
    private int max_processes = 20;
    @Option(name="-process_join_wait_time", usage="Process join wait time. 0 for no wait, -1 for random wait between [0, time_period), and > 1 for fixed wait")
    private int process_join_wait_time = -1;
    @Option(name="-number_of_leaders_to_kill", usage="Number of Leaders to kill")
    private int number_of_leaders_to_kill = 10;
    @Option(name="-consider_stable_after", usage="If the time_period does not change for this long then the system is considered to be stable")
    private long consider_stable_after = 10000L;
    @Option(name="-max_stabilization_wait_time", usage="Maximum wait time to see if the system has stabilized. it should be > consider_stable_after")
    private long max_stabilization_wait_time = 60000L;
    @Option(name="-output_file_path", usage="Output File")
    private String output_file_path = "results.txt";
    private final String HTTP_ADDRESS = "dummy.address.com:9999";
    private final String RPC_ADDRESS = "repc.server.ip:0000";
    private final String DRIVER_CLASS = "io.hops.metadata.ndb.NdbStorageFactory";
    private final String DFS_STORAGE_DRIVER_CONFIG_FILE = "ndb-config.properties";
    private final DescriptiveStatistics stats = new DescriptiveStatistics();
    private long stable_time_period;

    public static void main(String[] argv) throws Exception {
        Experiment1 exp = new Experiment1();
        exp.runExperiment(argv);
        System.exit(0);
    }

    public void runExperiment(String[] args) throws StorageInitializtionException, StorageException, IOException, ClassNotFoundException, InterruptedException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        parser.setUsageWidth(80);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
        this.init();
        this.writeStartMessages(args);
        this.startProcesses();
        this.waitAllJoin();
        this.waitForTheSystemToStabilize();
        this.killLeaders();
        this.writeResults();
        this.tearDown();
    }

    private void init() throws StorageInitializtionException, StorageException, IOException, ClassNotFoundException {
        LogManager.getRootLogger().setLevel(org.apache.log4j.Level.INFO);
        this.nnList = new ArrayList<LightWeightNameNode>();
        LEStorageFactory.setConfiguration(this.driver_jar, "io.hops.metadata.ndb.NdbStorageFactory", "ndb-config.properties");
        LEStorageFactory.formatStorage();
        VarsRegister.registerHdfsDefaultValues();
    }

    private void tearDown() {
        LOG.info((Object)"TearDown ... ");
        for (LightWeightNameNode nn : this.nnList) {
            nn.stop();
        }
    }

    private void startProcesses() throws InterruptedException, IOException {
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < this.max_processes; ++i) {
            this.startAProcess();
            if (this.process_join_wait_time == 0) continue;
            if (this.process_join_wait_time == -1) {
                Thread.sleep(rand.nextInt(this.time_period));
                continue;
            }
            if (this.process_join_wait_time > 0) {
                Thread.sleep(this.process_join_wait_time);
                continue;
            }
            this.writeMessageToFile("Unsupported process wait time. Fix process args ");
            System.exit(-1);
        }
    }

    private void waitAllJoin() throws InterruptedException, IOException {
        long max_wait_time = 600000L;
        long start_time = System.currentTimeMillis();
        boolean all_processes_started = false;
        while (System.currentTimeMillis() - start_time < 600000L) {
            try {
                if (this.nnList.get(this.nnList.size() - 1).getActiveNameNodes().size() == this.nnList.size()) {
                    all_processes_started = true;
                    break;
                }
                LOG.info((Object)("Experiment. The last process does not have complete list of processes. Got " + this.nnList.get(this.nnList.size() - 1).getActiveNameNodes().size() + " expecting " + this.nnList.size()));
                Thread.sleep(1000L);
            }
            catch (NullPointerException e) {
                LOG.error((Object)"Null pointer error in join");
            }
        }
        if (!all_processes_started) {
            this.writeMessageToFile("Waiting for all processes to join is taking too long ...");
            System.exit(-1);
        }
    }

    private void waitForTheSystemToStabilize() throws IOException, InterruptedException {
        long start_time = System.currentTimeMillis();
        long last_time_period = -1L;
        long last_time_period_change_time = -1L;
        boolean system_stable = false;
        Random rand = new Random(System.currentTimeMillis());
        while (System.currentTimeMillis() - start_time < this.max_stabilization_wait_time) {
            long new_time_period = this.nnList.get(rand.nextInt(this.nnList.size())).getLeTimePeriod();
            if (last_time_period != new_time_period) {
                last_time_period = new_time_period;
                last_time_period_change_time = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - last_time_period_change_time > this.consider_stable_after) {
                this.writeMessageToFile("After join the system stabilized in " + (System.currentTimeMillis() - start_time) + " ms. Time period is " + last_time_period);
                this.stable_time_period = last_time_period;
                system_stable = true;
                break;
            }
            Thread.sleep(1000L);
            LOG.info((Object)("Experiment. System has not yet stabilized. TP " + last_time_period + " since " + (System.currentTimeMillis() - last_time_period_change_time)));
        }
        if (!system_stable) {
            this.writeMessageToFile("The system did not stabilize ... ");
            System.exit(-1);
        }
    }

    private void killLeaders() {
        try {
            long last_leader_kill_time = 0L;
            LightWeightNameNode leader_killed = null;
            int leadersKilled = 0;
            LOG.info((Object)"Experiment. going to start killing nodes");
            while (leadersKilled < this.number_of_leaders_to_kill) {
                LightWeightNameNode current_leader = this.getCurrentLeader();
                if (leader_killed == null || current_leader != null && current_leader.getLeCurrentId() != leader_killed.getLeCurrentId()) {
                    if (leader_killed != null) {
                        long failOverTime = System.currentTimeMillis() - last_leader_kill_time;
                        long failOverLowerBound = leader_killed.getLeTimePeriod();
                        long failOverUpperBound = leader_killed.getLeTimePeriod() * (long)(this.missed_hb_threshold + 1);
                        if (failOverTime <= failOverLowerBound || failOverTime >= failOverUpperBound) {
                            // empty if block
                        }
                        this.writeMessageToFile("New Leader Elected. Old Leader Id " + leader_killed.getLeCurrentId() + " new Leader Id " + current_leader.getLeCurrentId() + " New leader elected in " + failOverTime);
                        this.stats.addValue((double)failOverTime);
                    }
                    LOG.info((Object)"Experiment. going to start a new process");
                    this.startAProcess();
                    LOG.info((Object)"Experiment. new process started");
                    this.writeMessageToFile("Experiment. Stopping the leader process ... Id " + current_leader.getLeCurrentId());
                    long killstarttime = System.currentTimeMillis();
                    current_leader.stop();
                    while (!current_leader.getLeaderElectionInstance().isStopped()) {
                        Thread.sleep(1L);
                    }
                    last_leader_kill_time = System.currentTimeMillis();
                    LOG.info((Object)("Experiment. Stopped the leader process in " + (last_leader_kill_time - killstarttime)));
                    leader_killed = current_leader;
                    ++leadersKilled;
                }
                if (last_leader_kill_time <= 0L) continue;
                long max_wait_for_fail_over = 300000L;
                if (System.currentTimeMillis() - last_leader_kill_time <= max_wait_for_fail_over) continue;
                this.writeMessageToFile("Taking very long to elect a new leader ...");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            try {
                this.writeMessageToFile("Got an exception that is not properly handled " + e);
                e.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(Experiment1.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void writeStartMessages(String[] argv) throws IOException {
        this.writeMessageToFile("\n\n==========================================================================");
        this.writeMessageToFile("Params " + Arrays.toString(argv));
        this.writeMessageToFile("--------------------------------------------------------------------------");
    }

    private void writeResults() throws IOException {
        this.writeMessageToFile("Experiment Finished Sucessfully. Data " + this.max_processes + ", " + this.stable_time_period + ", " + this.stats.getMin() + ", " + this.stats.getMax() + ", " + this.stats.getMean() + ", " + this.stats.getVariance() + ", " + this.stats.getStandardDeviation() + ", " + this.stats.getStandardDeviation() / Math.sqrt(this.stats.getN()));
        this.writeMessageToFile("DataPoints: " + this.stable_time_period + " " + Arrays.toString(this.stats.getValues()));
    }

    private LightWeightNameNode getCurrentLeader() throws IOException {
        int leaderCount = 0;
        LightWeightNameNode leader = null;
        for (int i = this.nnList.size() - 1; i >= 0; --i) {
            if (!this.nnList.get(i).isLeader()) continue;
            ++leaderCount;
            leader = this.nnList.get(i);
        }
        if (leaderCount > 1) {
            this.writeMessageToFile("Wrong number of leaders. Found " + leaderCount);
            System.exit(-1);
        } else if (leaderCount == 0) {
            // empty if block
        }
        return leader;
    }

    public void startAProcess() throws IOException, InterruptedException {
        for (int tries = 100; tries >= 0; --tries) {
            try {
                LightWeightNameNode nn = new LightWeightNameNode(new HdfsLeDescriptorFactory(), this.time_period, this.missed_hb_threshold, this.time_period_increment, "dummy.address.com:9999", "repc.server.ip:0000");
                this.nnList.add(nn);
                return;
            }
            catch (Throwable e) {
                LOG.warn((Object)("Could not create a process. Retrying (tries left " + tries + ")... Exception was  " + e.getMessage()));
                e.printStackTrace();
                Random rand = new Random(System.currentTimeMillis());
                Thread.sleep(rand.nextInt(5000));
                continue;
            }
        }
        this.writeMessageToFile("Unable to start a process. Experiment failed ...");
        System.exit(-1);
    }

    public void writeMessageToFile(String message) throws IOException {
        LOG.info((Object)message);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.output_file_path, true)));
        out.println(message);
        out.close();
    }
}

