/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.INodeMetadataLogEntry;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.security.UsersGroups;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.SubtreeLockHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.security.AccessControlException;

@VisibleForTesting
abstract class AbstractFileTree {
    public static final Log LOG = LogFactory.getLog(AbstractFileTree.class);
    private final FSNamesystem namesystem;
    private final FSPermissionChecker fsPermissionChecker;
    private final INodeIdentifier subtreeRootId;
    private ConcurrentLinkedQueue<Future> activeCollectors = new ConcurrentLinkedQueue();
    private final FsAction subAccess;
    private final boolean ignoreEmptyDir;
    private volatile IOException exception;
    private List<AclEntry> subtreeRootDefaultEntries;
    private byte inheritedStoragePolicy;

    public INodeIdentifier getSubtreeRootId() {
        return this.subtreeRootId;
    }

    public AbstractFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, byte inheritedStoragePolicy) throws AccessControlException {
        this(namesystem, subtreeRootId, null, false, null, inheritedStoragePolicy);
    }

    public AbstractFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, FsAction subAccess, boolean ignoreEmptyDir, List<AclEntry> subtreeRootDefaultEntries, byte inheritedStoragePolicy) throws AccessControlException {
        this.namesystem = namesystem;
        this.fsPermissionChecker = namesystem.getPermissionChecker();
        this.subtreeRootId = subtreeRootId;
        this.subAccess = subAccess;
        this.ignoreEmptyDir = ignoreEmptyDir;
        this.subtreeRootDefaultEntries = subtreeRootDefaultEntries;
        this.inheritedStoragePolicy = inheritedStoragePolicy;
    }

    private void checkAccess(INode node, FsAction action, List<AclEntry> aclEntries) throws IOException {
        if (!this.fsPermissionChecker.isSuperUser() && node.isDirectory()) {
            this.fsPermissionChecker.check(node, action, aclEntries);
        }
    }

    private void checkAccess(ProjectedINode node, FsAction action, List<AclEntry> aclEntries) throws IOException {
        if (!this.fsPermissionChecker.isSuperUser() && node.isDirectory()) {
            node.setUserName(UsersGroups.getUser(node.getUserID()));
            node.setGroupName(UsersGroups.getGroup(node.getGroupID()));
            this.fsPermissionChecker.check(node, action, aclEntries);
        }
    }

    public void buildUp(BlockStoragePolicySuite bsps) throws IOException {
        INode subtreeRoot = this.readSubtreeRoot(bsps);
        if (!subtreeRoot.isDirectory()) {
            return;
        }
        this.collectChildren(AbstractFileTree.newProjectedInode(subtreeRoot, 0L), this.subtreeRootId.getDepth(), 2, this.subtreeRootDefaultEntries, bsps, this.inheritedStoragePolicy);
        try {
            Future future;
            while ((future = this.activeCollectors.poll()) != null) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"FileTree builder was interrupted");
            throw new BuildingUpFileTreeFailedException("Building the up the file tree was interrupted.");
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw new RuntimeException(e.getCause());
            }
            String message = "FileTree.buildUp received an unexpected execution exception";
            LOG.warn((Object)message, (Throwable)e);
            throw new RetriableException(message);
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    protected synchronized void setExceptionIfNull(IOException e) {
        if (this.exception == null) {
            this.exception = e;
        }
    }

    protected abstract void addSubtreeRoot(ProjectedINode var1, BlockStoragePolicySuite var2, byte var3);

    protected abstract void addChildNode(ProjectedINode var1, int var2, ProjectedINode var3, BlockStoragePolicySuite var4, byte var5);

    private INode readSubtreeRoot(final BlockStoragePolicySuite bsps) throws IOException {
        return (INode)new LightWeightRequestHandler(HDFSOperationType.GET_SUBTREE_ROOT){

            public Object performTask() throws IOException {
                List<INode> cList;
                INodeDataAccess dataAccess = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                INode subtreeRoot = null;
                subtreeRoot = (INode)dataAccess.findInodeByNameParentIdAndPartitionIdPK(AbstractFileTree.this.subtreeRootId.getName(), AbstractFileTree.this.subtreeRootId.getPid().longValue(), AbstractFileTree.this.subtreeRootId.getPartitionId().longValue());
                if (subtreeRoot == null) {
                    throw new BuildingUpFileTreeFailedException("Subtree root does not exist");
                }
                List<AclEntry> inodeOwnAclNoTransaction = INodeUtil.getInodeOwnAclNoTransaction(subtreeRoot);
                if (AbstractFileTree.this.namesystem.isPermissionEnabled() && AbstractFileTree.this.subAccess != null && subtreeRoot.isDirectory() && (!(cList = INodeUtil.getChildrenListNotTransactional(subtreeRoot.getId(), AbstractFileTree.this.subtreeRootId.getDepth().shortValue())).isEmpty() || !AbstractFileTree.this.ignoreEmptyDir)) {
                    if (inodeOwnAclNoTransaction.isEmpty()) {
                        AbstractFileTree.this.checkAccess(subtreeRoot, AbstractFileTree.this.subAccess, (List<AclEntry>)AbstractFileTree.asAccessEntries(AbstractFileTree.this.subtreeRootDefaultEntries));
                    } else {
                        AbstractFileTree.this.checkAccess(subtreeRoot, AbstractFileTree.this.subAccess, (List<AclEntry>)inodeOwnAclNoTransaction);
                    }
                }
                long size = 0L;
                if (subtreeRoot.isFile()) {
                    size = ((INodeFile)subtreeRoot).getSize();
                }
                ProjectedINode pin = AbstractFileTree.newProjectedInode(subtreeRoot, size);
                AbstractFileTree.this.addSubtreeRoot(pin, bsps, AbstractFileTree.this.inheritedStoragePolicy);
                return subtreeRoot;
            }
        }.handle((Object)this);
    }

    private void collectChildren(ProjectedINode parent, short depth, int level, List<AclEntry> inheritedDefaults, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
        this.activeCollectors.add(this.namesystem.getFSOperationsExecutor().submit(new ChildCollector(parent, depth, level, inheritedDefaults, bsps, inheritedStoragePolicy)));
    }

    @VisibleForTesting
    static CountingFileTree createCountingFileTreeFromPath(FSNamesystem namesystem, String path) throws StorageException, UnresolvedPathException, TransactionContextException, AccessControlException {
        LinkedList<INode> nodes = new LinkedList<INode>();
        INodeUtil.resolvePathWithNoTransaction(path, false, nodes);
        INodeIdentifier rootId = new INodeIdentifier(Long.valueOf(nodes.getLast().getId()), Long.valueOf(nodes.getLast().getParentId()), nodes.getLast().getLocalName(), nodes.getLast().getPartitionId());
        rootId.setDepth(Short.valueOf((short)(0 + (nodes.size() - 1))));
        return new CountingFileTree(namesystem, rootId, 0);
    }

    @VisibleForTesting
    static FileTree createFileTreeFromPath(FSNamesystem namesystem, String path) throws StorageException, UnresolvedPathException, TransactionContextException, AccessControlException {
        LinkedList<INode> nodes = new LinkedList<INode>();
        INodeUtil.resolvePathWithNoTransaction(path, false, nodes);
        INodeIdentifier rootId = new INodeIdentifier(Long.valueOf(nodes.getLast().getId()), Long.valueOf(nodes.getLast().getParentId()), nodes.getLast().getLocalName(), nodes.getLast().getPartitionId());
        rootId.setDepth(Short.valueOf((short)(0 + (nodes.size() - 1))));
        return new FileTree(namesystem, rootId);
    }

    private static List<AclEntry> asAccessEntries(List<AclEntry> defaults) {
        ArrayList<AclEntry> accessEntries = new ArrayList<AclEntry>();
        for (AclEntry defaultEntry : defaults) {
            accessEntries.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(defaultEntry.getType()).setName(defaultEntry.getName()).setPermission(defaultEntry.getPermission()).build());
        }
        return accessEntries;
    }

    private static List<AclEntry> filterAccessEntries(List<AclEntry> maybeAccess) {
        if (maybeAccess == null) {
            return new ArrayList<AclEntry>();
        }
        ArrayList<AclEntry> onlyDefaults = new ArrayList<AclEntry>();
        for (AclEntry entry : maybeAccess) {
            if (!entry.getScope().equals((Object)AclEntryScope.DEFAULT)) continue;
            onlyDefaults.add(entry);
        }
        return onlyDefaults;
    }

    private static List<AclEntry> filterDefaultEntries(List<AclEntry> maybeDefault) {
        if (maybeDefault == null) {
            return new ArrayList<AclEntry>();
        }
        ArrayList<AclEntry> onlyDefaults = new ArrayList<AclEntry>();
        for (AclEntry entry : maybeDefault) {
            if (!entry.getScope().equals((Object)AclEntryScope.ACCESS)) continue;
            onlyDefaults.add(entry);
        }
        return onlyDefaults;
    }

    private static ProjectedINode newProjectedInode(INode from, long size) {
        boolean dirWithQuota = false;
        if (from instanceof INodeDirectory && ((INodeDirectory)from).isWithQuota()) {
            dirWithQuota = true;
        }
        ProjectedINode result = new ProjectedINode(from.getId(), from.getParentId(), from.getLocalName(), from.getPartitionId().longValue(), from instanceof INodeDirectory, from.getFsPermissionShort(), from.getUserID(), from.getGroupID(), from.getHeader(), from.isSymlink(), dirWithQuota, from.isUnderConstruction(), from.isSTOLocked(), from.getSTOLockOwner(), size, from.getLogicalTime(), from.getLocalStoragePolicyID(), from.getNumAces(), from.getNumUserXAttrs(), from.getNumSysXAttrs());
        return result;
    }

    static class IdCollectingCountingFileTree
    extends CountingFileTree {
        private LinkedList<Long> ids = new LinkedList();
        private List<Long> synchronizedList = Collections.synchronizedList(this.ids);

        public IdCollectingCountingFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, byte inheritedStoragePolicy) throws AccessControlException {
            super(namesystem, subtreeRootId, inheritedStoragePolicy);
        }

        @Override
        protected void addSubtreeRoot(ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.synchronizedList.add(node.getId());
            super.addSubtreeRoot(node, bsps, inheritedStoragePolicy);
        }

        @Override
        protected void addChildNode(ProjectedINode parent, int level, ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.synchronizedList.add(node.getId());
            super.addChildNode(parent, level, node, bsps, inheritedStoragePolicy);
        }

        public LinkedList<Long> getOrderedIds() {
            return this.ids;
        }
    }

    @VisibleForTesting
    public static class FileTree
    extends AbstractFileTree {
        public static final int ROOT_LEVEL = 1;
        private final SetMultimap<Long, ProjectedINode> inodesByParent;
        private final SetMultimap<Integer, ProjectedINode> inodesByLevel;
        private final SetMultimap<Integer, ProjectedINode> dirsByLevel;
        private final ConcurrentHashMap<Long, ProjectedINode> inodesById = new ConcurrentHashMap();

        public FileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId) throws AccessControlException {
            this(namesystem, subtreeRootId, null, false, null, 0);
        }

        public FileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, FsAction subAccess, boolean ignoreEmptyDir, List<AclEntry> subtreeRootDefaultEntries, byte inheritedStoragePolicy) throws AccessControlException {
            super(namesystem, subtreeRootId, subAccess, ignoreEmptyDir, subtreeRootDefaultEntries, inheritedStoragePolicy);
            HashMultimap parentMap = HashMultimap.create();
            this.inodesByParent = Multimaps.synchronizedSetMultimap((SetMultimap)parentMap);
            HashMultimap levelMap = HashMultimap.create();
            this.inodesByLevel = Multimaps.synchronizedSetMultimap((SetMultimap)levelMap);
            HashMultimap dirsLevelMap = HashMultimap.create();
            this.dirsByLevel = Multimaps.synchronizedSetMultimap((SetMultimap)dirsLevelMap);
        }

        @Override
        protected void addSubtreeRoot(ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.inodesByLevel.put((Object)1, (Object)node);
            this.inodesById.put(node.getId(), node);
            this.dirsByLevel.put((Object)1, (Object)node);
        }

        @Override
        protected void addChildNode(ProjectedINode parent, int level, ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.inodesByParent.put((Object)parent.getId(), (Object)node);
            this.inodesByLevel.put((Object)level, (Object)node);
            this.inodesById.put(node.getId(), node);
            if (node.isDirectory()) {
                this.dirsByLevel.put((Object)level, (Object)node);
            }
        }

        public Collection<ProjectedINode> getAll() {
            return this.inodesByLevel.values();
        }

        public Set<Long> getAllINodesIds() {
            return this.inodesById.keySet();
        }

        public Collection<ProjectedINode> getAllChildren() {
            return this.inodesByParent.values();
        }

        public ProjectedINode getSubtreeRoot() {
            return (ProjectedINode)this.inodesByLevel.get((Object)1).iterator().next();
        }

        public int getHeight() {
            return this.inodesByLevel.keySet().size();
        }

        public Collection<ProjectedINode> getChildren(long inodeId) {
            return this.inodesByParent.get((Object)inodeId);
        }

        public Collection<ProjectedINode> getInodesByLevel(int level) {
            return this.inodesByLevel.get((Object)level);
        }

        public Collection<ProjectedINode> getDirsByLevel(int level) {
            return this.dirsByLevel.get((Object)level);
        }

        public int countChildren(long inodeId) {
            return this.getChildren(inodeId).size();
        }

        public ProjectedINode getInodeById(long id) {
            return this.inodesById.get(id);
        }

        public boolean isNonEmptyDirectory() {
            return this.getSubtreeRoot().isDirectory() && !this.getChildren(this.getSubtreeRoot().getId()).isEmpty();
        }

        public String createAbsolutePath(String subtreeRootPath, ProjectedINode inode) {
            StringBuilder builder = new StringBuilder();
            while (!inode.equals((Object)this.getSubtreeRoot())) {
                builder.insert(0, inode.getName());
                builder.insert(0, "/");
                inode = this.getInodeById(inode.getParentId());
            }
            builder.insert(0, subtreeRootPath);
            return builder.toString();
        }
    }

    static class LoggingQuotaCountingFileTree
    extends QuotaCountingFileTree {
        private ConcurrentLinkedQueue<INodeMetadataLogEntry> metadataLogEntries = new ConcurrentLinkedQueue();
        private final INode srcDataset;
        private final INode dstDataset;

        public LoggingQuotaCountingFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, INode srcDataset, INode dstDataset) throws AccessControlException {
            super(namesystem, subtreeRootId);
            this.srcDataset = srcDataset;
            this.dstDataset = dstDataset;
        }

        @Override
        protected void addChildNode(ProjectedINode parent, int level, ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            if (this.srcDataset == null) {
                if (this.dstDataset != null) {
                    this.metadataLogEntries.add(new INodeMetadataLogEntry(this.dstDataset.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.incrementLogicalTime(), INodeMetadataLogEntry.Operation.Add));
                }
            } else if (this.dstDataset == null) {
                this.metadataLogEntries.add(new INodeMetadataLogEntry(this.srcDataset.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.incrementLogicalTime(), INodeMetadataLogEntry.Operation.Delete));
            } else {
                this.metadataLogEntries.add(new INodeMetadataLogEntry(this.dstDataset.getId(), node.getId(), node.getPartitionId(), node.getParentId(), node.getName(), node.incrementLogicalTime(), INodeMetadataLogEntry.Operation.ChangeDataset));
            }
            super.addChildNode(parent, level, node, bsps, inheritedStoragePolicy);
        }

        public Collection<INodeMetadataLogEntry> getMetadataLogEntries() {
            return this.metadataLogEntries;
        }

        static void updateLogicalTime(final Collection<INodeMetadataLogEntry> logEntries) throws IOException {
            new LightWeightRequestHandler(HDFSOperationType.UPDATE_LOGICAL_TIME){

                public Object performTask() throws IOException {
                    INodeDataAccess dataAccess = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    dataAccess.updateLogicalTime(logEntries);
                    return null;
                }
            }.handle();
        }
    }

    @VisibleForTesting
    static class QuotaCountingFileTree
    extends AbstractFileTree {
        private final QuotaCounts quotaCounts = new QuotaCounts.Builder().build();

        public QuotaCountingFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId) throws AccessControlException {
            super(namesystem, subtreeRootId, (byte)0);
        }

        @Override
        protected void addSubtreeRoot(ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.addNode(node);
        }

        @Override
        protected void addChildNode(ProjectedINode parent, int level, ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            if (!parent.isDirWithQuota()) {
                this.addNode(node);
            }
        }

        protected void addNode(final ProjectedINode node) {
            if (node.isDirWithQuota()) {
                LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.GET_SUBTREE_ATTRIBUTES){

                    public Object performTask() throws StorageException, IOException {
                        DirectoryWithQuotaFeatureDataAccess dataAccess = (DirectoryWithQuotaFeatureDataAccess)HdfsStorageFactory.getDataAccess(DirectoryWithQuotaFeatureDataAccess.class);
                        DirectoryWithQuotaFeature feature = (DirectoryWithQuotaFeature)dataAccess.findAttributesByPk(Long.valueOf(node.getId()));
                        quotaCounts.add(feature.getSpaceConsumed());
                        return null;
                    }
                };
                try {
                    handler.handle();
                }
                catch (IOException e) {
                    this.setExceptionIfNull(e);
                }
            } else {
                this.quotaCounts.addNameSpace(1L);
                if (!node.isDirectory() && !node.isSymlink()) {
                    this.quotaCounts.addStorageSpace(node.getFileSize() * (long)INode.HeaderFormat.getReplication(node.getHeader()));
                }
            }
        }

        QuotaCounts getQuotaCount() {
            return this.quotaCounts;
        }
    }

    @VisibleForTesting
    static class CountingFileTree
    extends AbstractFileTree {
        ContentCounts counts = new ContentCounts.Builder().build();
        QuotaCounts usedCounts = new QuotaCounts.Builder().build();

        public CountingFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, byte inheritedStoragePolicy) throws AccessControlException {
            super(namesystem, subtreeRootId, inheritedStoragePolicy);
        }

        public CountingFileTree(FSNamesystem namesystem, INodeIdentifier subtreeRootId, FsAction subAccess, boolean ignoreEmptyDir, List<AclEntry> subtreeRootDefaultEntries, byte inheritedStoragePolicy) throws AccessControlException {
            super(namesystem, subtreeRootId, subAccess, ignoreEmptyDir, subtreeRootDefaultEntries, inheritedStoragePolicy);
        }

        @Override
        protected void addSubtreeRoot(ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.addNode(node, bsps, inheritedStoragePolicy);
        }

        @Override
        protected void addChildNode(ProjectedINode parent, int level, ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.addNode(node, bsps, inheritedStoragePolicy);
        }

        protected void addNode(ProjectedINode node, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            if (node.isDirectory()) {
                this.counts.addContent(Content.DIRECTORY, 1L);
                this.usedCounts.addNameSpace(1L);
            } else if (node.isSymlink()) {
                this.counts.addContent(Content.SYMLINK, 1L);
                this.usedCounts.addNameSpace(1L);
            } else {
                this.counts.addContent(Content.FILE, 1L);
                this.counts.addContent(Content.LENGTH, node.getFileSize());
                this.counts.addContent(Content.DISKSPACE, node.getFileSize() * (long)INode.HeaderFormat.getReplication(node.getHeader()));
                this.usedCounts.addStorageSpace(node.getFileSize() * (long)INode.HeaderFormat.getReplication(node.getHeader()));
                this.usedCounts.addNameSpace(1L);
                byte storagePolicy = node.getStoragePolicyID();
                if (storagePolicy == 0) {
                    storagePolicy = inheritedStoragePolicy;
                }
                if (storagePolicy != 0) {
                    BlockStoragePolicy bsp = bsps.getPolicy(storagePolicy);
                    List<StorageType> storageTypes = bsp.chooseStorageTypes(INode.HeaderFormat.getReplication(node.getHeader()));
                    for (StorageType t : storageTypes) {
                        if (!t.supportTypeQuota()) continue;
                        this.counts.addTypeSpace(t, node.getFileSize());
                        this.usedCounts.addTypeSpace(t, node.getFileSize());
                    }
                }
            }
        }

        public ContentCounts getCounts() {
            return this.counts;
        }

        public QuotaCounts getUsedCounts() {
            return this.usedCounts;
        }
    }

    private class ChildCollector
    implements Runnable {
        private final ProjectedINode parent;
        private final short depth;
        private final int level;
        private List<AclEntry> inheritedDefaultsAsAccess;
        private BlockStoragePolicySuite bsps;
        private final byte inheritedStoragePolicy;
        int batchIndex = 0;
        final int BATCHSIZE = 10000;

        private ChildCollector(ProjectedINode parent, short depth, int level, List<AclEntry> inheritedDefaultsAsAccess, BlockStoragePolicySuite bsps, byte inheritedStoragePolicy) {
            this.parent = parent;
            this.level = level;
            this.depth = depth;
            this.inheritedDefaultsAsAccess = inheritedDefaultsAsAccess;
            this.bsps = bsps;
            this.inheritedStoragePolicy = inheritedStoragePolicy;
        }

        @Override
        public void run() {
            LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.GET_CHILD_INODES){

                public Object performTask() throws StorageException, IOException {
                    INodeDataAccess dataAccess = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    List children = Collections.EMPTY_LIST;
                    children = INode.isTreeLevelRandomPartitioned(ChildCollector.this.depth) ? dataAccess.findInodesFTISTx(ChildCollector.this.parent.getId(), EntityContext.LockMode.READ_COMMITTED) : dataAccess.findInodesPPISTx(ChildCollector.this.parent.getId(), ChildCollector.this.parent.getId(), EntityContext.LockMode.READ_COMMITTED);
                    ChildCollector.this.lockInodesUsingBatchOperation(children, (INodeDataAccess<INode>)dataAccess);
                    HashMap<ProjectedINode, List<AclEntry>> acls = new HashMap<ProjectedINode, List<AclEntry>>();
                    for (ProjectedINode child : children) {
                        if (AbstractFileTree.this.namesystem.isPermissionEnabled() && AbstractFileTree.this.subAccess != null && child.isDirectory()) {
                            List<AclEntry> inodeAclNoTransaction = INodeUtil.getInodeOwnAclNoTransaction(child);
                            acls.put(child, inodeAclNoTransaction);
                            List<INode> cList = INodeUtil.getChildrenListNotTransactional(child.getId(), ChildCollector.this.depth + 1);
                            if (!cList.isEmpty() || !AbstractFileTree.this.ignoreEmptyDir) {
                                if (inodeAclNoTransaction.isEmpty()) {
                                    AbstractFileTree.this.checkAccess(child, AbstractFileTree.this.subAccess, (List<AclEntry>)AbstractFileTree.asAccessEntries(ChildCollector.this.inheritedDefaultsAsAccess));
                                } else {
                                    AbstractFileTree.this.checkAccess(child, AbstractFileTree.this.subAccess, (List<AclEntry>)inodeAclNoTransaction);
                                }
                            }
                        }
                        AbstractFileTree.this.addChildNode(ChildCollector.this.parent, ChildCollector.this.level, child, ChildCollector.this.bsps, ChildCollector.this.inheritedStoragePolicy);
                    }
                    if (AbstractFileTree.this.exception != null) {
                        return null;
                    }
                    for (ProjectedINode child : children) {
                        List<ActiveNode> activeNamenodes = AbstractFileTree.this.namesystem.getNameNode().getActiveNameNodes().getActiveNodes();
                        if (SubtreeLockHelper.isSTOLocked(child.isSubtreeLocked(), child.getSubtreeLockOwner(), activeNamenodes)) {
                            AbstractFileTree.this.exception = new RetriableException("The subtree: " + child.getName() + " is locked by Namenode: " + child.getSubtreeLockOwner() + ". Active Namenodes: " + activeNamenodes);
                            return null;
                        }
                        List newDefaults = AbstractFileTree.filterAccessEntries((List)acls.get(child));
                        if (!child.isDirectory()) continue;
                        byte storagePolicy = ChildCollector.this.inheritedStoragePolicy;
                        if (child.getStoragePolicyID() != 0) {
                            storagePolicy = child.getStoragePolicyID();
                        }
                        AbstractFileTree.this.collectChildren(child, (short)(ChildCollector.this.depth + 1), ChildCollector.this.level + 1, newDefaults.isEmpty() ? ChildCollector.this.inheritedDefaultsAsAccess : newDefaults, ChildCollector.this.bsps, storagePolicy);
                    }
                    return null;
                }
            };
            try {
                handler.handle((Object)this);
            }
            catch (IOException e) {
                AbstractFileTree.this.setExceptionIfNull(e);
            }
        }

        boolean getBatch(List<ProjectedINode> children, InodesBatch inodesBatch) {
            if (this.batchIndex >= children.size()) {
                return false;
            }
            int remaining = children.size() - this.batchIndex;
            remaining = remaining > 10000 ? 10000 : children.size() - this.batchIndex;
            inodesBatch.names = new String[remaining];
            inodesBatch.pids = new long[remaining];
            inodesBatch.partitionIDs = new long[remaining];
            for (int i = 0; i < remaining; ++i) {
                ProjectedINode inode = children.get(this.batchIndex++);
                inodesBatch.names[i] = inode.getName();
                inodesBatch.pids[i] = inode.getParentId();
                inodesBatch.partitionIDs[i] = inode.getPartitionId();
            }
            return true;
        }

        void lockInodesUsingBatchOperation(List<ProjectedINode> children, INodeDataAccess<INode> dataAccess) throws StorageException {
            InodesBatch batch = new InodesBatch();
            while (this.getBatch(children, batch)) {
                dataAccess.lockInodesUsingPkBatchTx(batch.names, batch.pids, batch.partitionIDs, EntityContext.LockMode.WRITE_LOCK);
            }
        }

        private class InodesBatch {
            long[] partitionIDs = null;
            String[] names = null;
            long[] pids = null;

            private InodesBatch() {
            }
        }
    }

    public static class BuildingUpFileTreeFailedException
    extends IOException {
        BuildingUpFileTreeFailedException(String message) {
            super(message);
        }
    }
}

