/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.hdfs.server.namenode.INode;

@InterfaceAudience.Private
public class XAttrFeature
implements INode.Feature {
    public static final ImmutableList<XAttr> EMPTY_ENTRY_LIST = ImmutableList.of();
    private static final Comparator<XAttr> XATTR_NAME_COMPARTOR = new Comparator<XAttr>(){

        @Override
        public int compare(XAttr o1, XAttr o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private final long inodeId;

    public XAttrFeature(long inodeId) {
        this.inodeId = inodeId;
    }

    public XAttrFeature(ImmutableList<XAttr> xAttrs, long inodeId) throws TransactionContextException, StorageException {
        this.inodeId = inodeId;
        for (XAttr attr : xAttrs) {
            EntityManager.add((Object)this.convertXAttrtoStored(attr));
        }
    }

    public List<XAttr> getXAttr(List<XAttr> attrs) throws StorageException, TransactionContextException {
        ArrayList storedAttrs = Lists.newArrayList();
        for (XAttr attr : attrs) {
            StoredXAttr storedXAttr = (StoredXAttr)EntityManager.find((FinderType)StoredXAttr.Finder.ByPrimaryKeyLocal, (Object[])new Object[]{XAttrFeature.getPrimaryKey(this.inodeId, attr)});
            if (storedXAttr == null) continue;
            storedAttrs.add(this.convertStoredtoXAttr(storedXAttr));
        }
        return storedAttrs;
    }

    public void addXAttr(XAttr attr) throws TransactionContextException, StorageException {
        StoredXAttr storedXAttr = this.convertXAttrtoStored(attr);
        EntityManager.add((Object)storedXAttr);
    }

    public void updateXAttr(XAttr attr) throws TransactionContextException, StorageException {
        StoredXAttr updatedStoredXAttr = this.convertXAttrtoStored(attr);
        StoredXAttr oldStoredXAttr = (StoredXAttr)EntityManager.find((FinderType)StoredXAttr.Finder.ByPrimaryKeyLocal, (Object[])new Object[]{XAttrFeature.getPrimaryKey(this.inodeId, attr)});
        updatedStoredXAttr.setOldNumParts(oldStoredXAttr.getNumParts());
        EntityManager.add((Object)updatedStoredXAttr);
    }

    public void removeXAttr(XAttr attr) throws TransactionContextException, StorageException {
        StoredXAttr storedXAttr = this.convertXAttrtoStored(attr);
        EntityManager.remove((Object)storedXAttr);
    }

    public ImmutableList<XAttr> getXAttrs() throws TransactionContextException, StorageException {
        Collection extendedAttributes = EntityManager.findList((FinderType)StoredXAttr.Finder.ByInodeIdLocal, (Object[])new Object[]{this.inodeId});
        if (extendedAttributes == null) {
            return EMPTY_ENTRY_LIST;
        }
        ArrayList attrs = Lists.newArrayListWithExpectedSize((int)extendedAttributes.size());
        for (StoredXAttr attr : extendedAttributes) {
            attrs.add(this.convertStoredtoXAttr(attr));
        }
        Collections.sort(attrs, XATTR_NAME_COMPARTOR);
        return ImmutableList.copyOf((Collection)attrs);
    }

    public void remove(final int numXAttrs) throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.REMOVE_XATTRS_FOR_INODE){

            public Object performTask() throws IOException {
                XAttrDataAccess xda = (XAttrDataAccess)HdfsStorageFactory.getDataAccess(XAttrDataAccess.class);
                int removed = xda.removeXAttrsByInodeId(XAttrFeature.this.inodeId);
                requestHandlerLOG.debug((Object)("Successfully removed " + removed + " XAttrs out of " + numXAttrs + " for inode (" + XAttrFeature.this.inodeId + ")"));
                return null;
            }
        }.handle();
    }

    private XAttr convertStoredtoXAttr(StoredXAttr attr) {
        XAttr.Builder builder = new XAttr.Builder();
        builder.setName(attr.getName());
        builder.setNameSpace(XAttr.NameSpace.valueOf(attr.getNamespace()));
        builder.setValue(attr.getValue());
        return builder.build();
    }

    private StoredXAttr convertXAttrtoStored(XAttr attr) {
        return new StoredXAttr(this.inodeId, attr.getNameSpace().getId(), attr.getName(), attr.getValue());
    }

    public static List<StoredXAttr.PrimaryKey> getPrimaryKeys(long inodeId, List<XAttr> attrs) {
        ArrayList pks = Lists.newArrayListWithExpectedSize((int)attrs.size());
        for (XAttr attr : attrs) {
            pks.add(XAttrFeature.getPrimaryKey(inodeId, attr));
        }
        return pks;
    }

    public static StoredXAttr.PrimaryKey getPrimaryKey(long inodeId, XAttr attr) {
        return new StoredXAttr.PrimaryKey(inodeId, attr.getNameSpace().getId(), attr.getName());
    }
}

